/**
 * @file extractarchive.c Extracts all of the files in the specified
 *                        archive.
 * 
 * $Id: extractarchive.c,v 1.2 2002/12/19 23:03:40 defrhymes Exp $
 *
 * @Copyright (C) 2001-2002 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libcomprex/comprex.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef WITH_LEAKBUG
# include <leakbug.h>
#endif


void
__extractprogress(CxArchive *archive, CxFile *file, size_t onFile, size_t fileCount)
{
	static int first_file = 0, last_file = 1;
  	if (first_file++ == 0)
    		fprintf(stdout, "Extracting archive:    %s\n", cxGetArchiveFileName(archive));

  
  	if (onFile == last_file + 1)
		fprintf(stdout, "......done.\n");
	
  	fprintf(stdout,   "      --Decompressing file(%d of %d): %s", 
	  		  onFile, fileCount, cxGetFilePath(file));

  	last_file = onFile;
	
	if (onFile == fileCount)
		fprintf(stdout, ".....done.\n");
}
 
int
main(int argc, char **argv)
{
	CxArchive  *archive;

	if (argc < 2)
	{
		printf("You must specify a filename!\n");
		exit(1);
	}
	
	archive = cxOpenArchive(argv[1]);

	if (archive == NULL)
	{
	        printf("Unable to open the archive!\n");
		exit(1);
	}

	/* Tell libcomprex to notify us of its progress */
	cxSetArchiveExtractCallback(archive, __extractprogress);

	/* umm, yeah */
	cxExtractArchive(archive);

	cxCloseArchive(archive);
	

	/* Clean up everything. We're done with libcomprex. */
	cxCleanup();

#ifdef WITH_LEAKBUG
	lbDumpLeaks();
#endif

	return 0;
}
