/**
 * @file catarchive.c Displays the contents of all files in the specified
 *                    archive.
 * 
 * $Id: catarchive.c,v 1.8 2003/01/01 06:22:31 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libcomprex/comprex.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef WITH_LEAKBUG
# include <leakbug.h>
#endif

int
main(int argc, char **argv)
{
	CxArchive *archive;
	CxFile *file;
	CxFsIterator *iter;

	if (argc < 2)
	{
		printf("You must specify a filename!\n");
		exit(1);
	}
	
	archive = cxOpenArchive(argv[1]);

	if (archive == NULL)
	{
		printf("Unable to open the archive!\n");
		exit(1);
	}

	iter = cxNewFsIterator(archive, CX_FSITER_FILES_DIRS);

	for (file = cxGetFsIterFirst(iter);
		 file != NULL;
		 file = cxGetFsIterNext(iter))
	{
		size_t s;
		char buffer[4096];
		CxFP *fp;

		if (cxGetFsNodeType(file) != CX_FSNODETYPE_FILE)
			continue;

		fp = cxOpenFileHandle(file, CX_MODE_READ_ONLY);

		printf("-----------------------------------\n");
		printf("File: %s\n", cxGetFilePath(file));
		printf("-----------------------------------\n");

		while ((s = cxRead(buffer, sizeof(char), 4095, fp)) > 0)
		{
			buffer[s] = '\0';
			printf("%s", buffer);
		}

		cxClose(fp);

		printf("\n");
	}

	cxDestroyFsIterator(iter);

	cxCloseArchive(archive);

	/* Clean up everything. We're done with libcomprex. */
	cxCleanup();

#ifdef WITH_LEAKBUG
	lbDumpLeaks();
#endif

	return 0;
}
