/**
 * @file header.h Zip header functions and structures
 * 
 * $Id: header.h,v 1.6 2003/01/01 06:22:34 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _MOD_HEADER_H_
#define _MOD_HEADER_H_



/* The various header signatures */
#define ZIP_LOCAL_SIG        0x04034b50  /* Local file header */
#define ZIP_CENTRAL_DIR_SIG  0x02014b50  /* Central directory header entry */
#define ZIP_END_SIG	     0x06054b50  /* End of central directory header */


/* Header sizes in bytes (including signatures) */
#define ZIP_LOCAL_HEADER_SIZE         30
#define ZIP_CENTRAL_DIR_HEADER_SIZE   46
#define ZIP_END_HEADER_SIZE	      22
#define ZIP_DATADESCRIPTOR_SIZE       12



typedef struct
{
	unsigned short version;  	/* Version needed to extract */
	unsigned short flag;		/* General purpose bit flag */
	unsigned short compression;	/* Compression method */
	unsigned int   mtime;		/* Last modified file time */
	unsigned int   crc32;		/* CRC-32 checksum */
	unsigned int   compressedSize;	/* Size of file when compressed */
	unsigned int   uncompressedSize;/* Size of file when decompressed */
	unsigned short filenameLength;  /* Length of file name */
	unsigned short extraLength;	/* Length of the extra-info field */
        long           fileOffset;      /* Not actually part of a local file header */	
	char *filename;			/* Filename of undetermined length */
	char *extraField;		/* Field holding extra info */
} ZipLocalHeader;

/* Data descriptor structure
 * The data descriptor is only used/present if bit 3 of the general
 * purpose flag in the local and central-dir header is set (1). It will
 * immediately follow the last byte of compressed data
 */
typedef struct
{
	unsigned int crc32;	      /* CRC-32 checksum */
	unsigned int compressedSize;  /* Compressed size */
	unsigned int uncompressedSize;/* Uncompressed Size */
} ZipDataDescriptor;


typedef enum
{
	ZIP_ERROR = 0,
	ZIP_SUCCESS,
	ZIP_INVALID_FORMAT,
	ZIP_LAST_FILE,
} ZipStatus;


CxStatus cxZipReadLocalHeader(ZipLocalHeader *header, CxFP *fp);


#endif  /* _MOD_HEADER_H_ */
