/**
 * @file libcomprex/fp.c File Pointers
 * 
 * $Id: fp.c,v 1.8 2003/01/12 07:19:08 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libcomprex/internal.h>

CxFP *
cxNewFp(void)
{
	CxFP *fp;

	MEM_CHECK(fp = (CxFP *)malloc(sizeof(CxFP)));
	memset(fp, 0, sizeof(CxFP));

	CX_LINK(fp);
	
	return fp;
}

void
cxSetFpAccessMode(CxFP *fp, CxAccessMode mode)
{
	if (fp == NULL || (mode & CX_MODE_ERROR) == CX_MODE_ERROR)
		return;

	fp->accessMode = mode;
}

void
cxSetReadFunc(CxFP *fp, size_t (*fnc)(void *, size_t, size_t, CxFP *))
{
	if (fp == NULL)
		return;

	fp->ops.read = fnc;
}

void
cxSetWriteFunc(CxFP *fp, size_t (*fnc)(const void *, size_t, size_t, CxFP *))
{
	if (fp == NULL)
		return;

	fp->ops.write = fnc;
}

void
cxSetSeekFunc(CxFP *fp, void (*fnc)(CxFP *, long, int))
{
	if (fp == NULL)
		return;

	fp->ops.seek = fnc;
}

void
cxSetCloseFunc(CxFP *fp, void (*fnc)(CxFP *))
{
	if (fp == NULL)
		return;

	fp->ops.close = fnc;
}

void
cxSetError(CxFP *fp, int errnum, const char *errstr)
{
	if (fp == NULL)
		return;

	fp->error = errnum;

	if (fp->errStr != NULL)
		free(fp->errStr);

	fp->errStr = (errstr == NULL ? NULL : strdup(errstr));
}

CxAccessMode
cxGetFpAccessMode(CxFP *fp)
{
	if (fp == NULL)
		return CX_MODE_ERROR;

	return fp->accessMode;
}

