dnl # $Id: acinclude.m4,v 1.11 2002/10/31 10:40:46 defrhymes Exp $
dnl #
dnl # Check for --with-leakbug option.

AC_DEFUN(AM_WITH_LEAKBUG,
[
	AC_MSG_CHECKING(if leakbug is wanted)
	AC_ARG_WITH(leakbug,
	[  --with-leakbug          use leakbug],
	[
		if test "$withval" = yes; then
			AC_MSG_RESULT(yes)
			AC_DEFINE(WITH_LEAKBUG, 1, [Define if using the leakbug package])
			LIBS="$LIBS -lleakbug"
		else
			AC_MSG_RESULT(no)
		fi
	],
	[
		AC_MSG_RESULT(no)
	])
])

## ----------------------------------- ##
## Check if --with-dmalloc was given.  ##
## From Franc,ois Pinard               ##
## ----------------------------------- ##

# serial 1

AC_DEFUN([AM_WITH_DMALLOC],
[AC_MSG_CHECKING(if malloc debugging is wanted)
AC_ARG_WITH(dmalloc,
[  --with-dmalloc          use dmalloc, as in
                          ftp://ftp.letters.com/src/dmalloc/dmalloc.tar.gz],
[if test "$withval" = yes; then
  AC_MSG_RESULT(yes)
  AC_DEFINE(WITH_DMALLOC,1,
            [Define if using the dmalloc debugging malloc package])
  LIBS="$LIBS -ldmalloc"
  LDFLAGS="$LDFLAGS -g"
else
  AC_MSG_RESULT(no)
fi], [AC_MSG_RESULT(no)])
])
AC_DEFUN([AM_GNU_GETTEXT_VERSION], [])

dnl ######################################################################
dnl # Check for libz
dnl ######################################################################
AC_DEFUN([AM_PATH_ZLIB],
[
AC_ARG_WITH(zlib,
[  --with-zlib[=DIR]         prefix where zlib is installed (optional)],
	zlib_prefix="$withval", zlib_prefix="")

if test x$zlib_prefix != x ; then
	ZLIB_LIBS="-L$zlib_prefix/lib -lz"
	ZLIB_CFLAGS="-I$zlib_prefix/include"
elif test "x$prefix" != "xNONE"; then
	ZLIB_LIBS="-L$prefix/lib -lz"
	ZLIB_CFLAGS="-I$prefix/include"
else
	ZLIB_LIBS="-L$ac_default_prefix/lib -lz"
	ZLIB_CFLAGS="-I$ac_default_prefix/include"
fi

ac_save_CFLAGS="$CFLAGS"
ac_save_LIBS="$LIBS"

LIBS="$ZLIB_LIBS $LIBS"
CFLAGS="$ZLIB_CFLAGS $CFLAGS"

AC_CHECK_LIB(z, gzread,
[
	AC_DEFINE(HAVE_LIBZ, 1, [Define if libz is installed.])
], [
	AC_MSG_ERROR([You need zlib for .gz and .Z (de)compression. Please download from http://www.gzip.org/])
])

LIBS="$ac_save_LIBS"
CFLAGS="$ac_save_CFLAGS"

AC_SUBST(ZLIB_LIBS)
AC_SUBST(ZLIB_CFLAGS)
])

dnl ######################################################################
dnl # Check for libbz2
dnl ######################################################################
AC_DEFUN([AM_PATH_LIBBZ2],
[
AC_ARG_WITH(libbz2,
[  --with-libbz2[=DIR]         prefix where libbz2 is installed (optional)],
	libbz2_prefix="$withval", libbz2_prefix="")

if test "x$libbz2_prefix" != "x" ; then
	LIBBZ2_LIBS="-L$libbz2_prefix/lib -lbz2"
	LIBBZ2_CFLAGS="-I$libbz2_prefix/include"
elif test "x$prefix" != "xNONE"; then
	LIBBZ2_LIBS="-L$prefix/lib -lbz2"
	LIBBZ2_CFLAGS="-I$prefix/include"
else
	LIBBZ2_LIBS="-L$ac_default_prefix/lib -lbz2"
	LIBBZ2_CFLAGS="-I$ac_default_prefix/include"
fi

ac_save_CFLAGS="$CFLAGS"
ac_save_LIBS="$LIBS"

LIBS="$LIBBZ2_LIBS $LIBS"
CFLAGS="$LIBBZ2_CFLAGS $CFLAGS"

AC_CHECK_LIB(bz2, BZ2_bzRead,
[
	AC_DEFINE(HAVE_LIBBZ2, 1, [Define if libbz2 is installed.])
], [
	AC_MSG_ERROR([You need bzip2 for .bz2 (de)compression. Please download from http://sources.redhat.com/bzip2/])
])

LIBS="$ac_save_LIBS"
CFLAGS="$ac_save_CFLAGS"

AC_SUBST(LIBBZ2_LIBS)
AC_SUBST(LIBBZ2_CFLAGS)
])

dnl ######################################################################
dnl # Module-related checks
dnl #
dnl # Thanks go to gaim for the code below! :)
dnl ######################################################################
AC_DEFUN([AM_MODULE_CHECKS],
[
AC_ARG_ENABLE(archive-mods,
 [  --disable-archive-mods  don't build dynamic archive modules],
 enable_archive_mods=no,
 [
	enable_archive_mods=yes
	enable_dynamic_mods=yes
])

AC_ARG_ENABLE(scheme-mods,
 [  --disable-scheme-mods   don't build dynamic scheme modules],
 enable_scheme_mods=no,
 [
	enable_scheme_mods=yes
	enable_dynamic_mods=yes
])

AM_CONDITIONAL(DYNAMIC_ARCHIVE_MODS, test "x$enable_archive_mods" = "xyes")
AM_CONDITIONAL(DYNAMIC_SCHEME_MODS,  test "x$enable_scheme_mods"  = "xyes")
AM_CONDITIONAL(DYNAMIC_MODS,         test "x$enable_dynamic_mods" = "xyes")

if test "x$enable_dynamic_mods" = "xyes"; then
	AC_DEFINE(DYNAMIC_MODS, 1, [Define if dynamic module support is enabled.])
fi

AC_ARG_WITH(static-archive,
 [  --with-static-archive   link in specified archive modules statically],
 [STATIC_ARCHIVE_MODS=`echo $withval | $sedpath 's/,/ /g'`])
AC_ARG_WITH(static-scheme,
 [  --with-static-scheme    link in specified scheme modules statically],
 [STATIC_SCHEME_MODS=`echo $withval | $sedpath 's/,/ /g'`])

if test "x$STATIC_ARCHIVE_MODS" = "xall"; then
	STATIC_ARCHIVE_MODS="ar bzip2 cab cpio tar zip zlib"
fi

if test "x$STATIC_SCHEME_MODS" = "xall"; then
	STATIC_SCHEME_MODS="curl"
fi

STATIC_LINK_LIBS=
extern_archive_init=
extern_scheme_init=
load_archive_mod=
load_scheme_mod=

for i in $STATIC_ARCHIVE_MODS; do
	STATIC_LINK_LIBS="$STATIC_LINK_LIBS ../modules/archive/$i/lib${i}_s.la"
	extern_archive_init="$extern_archive_init CxArchiveOps *init_${i}_archive_module(void);"
	load_archive_mod="$load_archive_mod init_${i}_archive_module();"

	case $i in
		ar) static_archive_ar=yes ;;
		bzip2) static_archive_bzip2=yes ;;
		cab) static_archive_cab=yes ;;
		cpio) static_archive_cpio=yes ;;
		tar) static_archive_tar=yes ;;
		zip) static_archive_zip=yes ;;
		zlib) static_archive_zlib=yes ;;
		*) echo "Invalid static archive module $i!" ; exit ;;
	esac
done

for i in $STATIC_SCHEME_MODS; do
	if "x$i" != "xcurl"; then
		STATIC_LINK_LIBS="$STATIC_LINK_LIBS ../modules/scheme/$i/lib${i}_s.la"
		extern_scheme_init="$extern_scheme_init CxSchemeOps *init_${i}_scheme_module(void);"
		load_scheme_mod="$load_scheme_mod init_${i}_scheme_module();"
	fi

	case $i in
		curl) static_scheme_curl=yes ;;
		*) echo "Invalid static scheme module $i!" ; exit ;;
	esac
done

AM_CONDITIONAL(STATIC_ARCHIVE_AR,    test "x$static_archive_ar"    = "xyes")
AM_CONDITIONAL(STATIC_ARCHIVE_BZIP2, test "x$static_archive_bzip2" = "xyes")
AM_CONDITIONAL(STATIC_ARCHIVE_TAR,   test "x$static_archive_cab"   = "xyes")
AM_CONDITIONAL(STATIC_ARCHIVE_CPIO,  test "x$static_archive_cpio"  = "xyes")
AM_CONDITIONAL(STATIC_ARCHIVE_TAR,   test "x$static_archive_tar"   = "xyes")
AM_CONDITIONAL(STATIC_ARCHIVE_ZIP,   test "x$static_archive_zip"   = "xyes")
AM_CONDITIONAL(STATIC_ARCHIVE_ZLIB,  test "x$static_archive_zlib"  = "xyes")

AM_CONDITIONAL(STATIC_SCHEME_CURL,   test "x$static_scheme_curl"   = "xyes")

if test "x$enable_archive_mods" = "xyes" -o \
        "x$static_archive_zlib" = "xyes"; then
	AM_PATH_ZLIB
fi

if test "x$enable_archive_mods" = "xyes" -o \
        "x$static_archive_bzip2" = "xyes"; then
	AM_PATH_LIBBZ2
fi

if test "x$enable_scheme_mods" = "xyes" -o \
        "x$static_scheme_curl" = "xyes"; then
	AC_CHECK_LIB(curl, curl_formparse, ac_curl_support=yes)
fi

if test "x$static_scheme_curl" = "xyes"; then
	if test "x$ac_curl_support" = "xyes"; then
		STATIC_LINK_LIBS="$STATIC_LINK_LIBS ../modules/scheme/curl/libcurlscm_s.la"
		extern_scheme_init="$extern_scheme_init CxSchemeOps *init_curl_scheme_module(void);"
		load_scheme_mod="$load_scheme_mod init_curl_scheme_module();"
	else
		dnl Remove from the list.
		STATIC_SCHEME_MODS=`echo $STATIC_SCHEME_MODS | sed s/curl//'`
	fi
fi

AM_CONDITIONAL(HAVE_CURL, test "x$ac_curl_support" = "xyes")


AC_SUBST(STATIC_ARCHIVE_MODS)
AC_SUBST(STATIC_SCHEME_MODS)

AC_SUBST(STATIC_LINK_LIBS)
AC_DEFINE_UNQUOTED(STATIC_ARCHIVE_INIT, $extern_archive_init static void static_archive_init() { $load_archive_mod },
	[Loads static archive module initialization functions.])
AC_DEFINE_UNQUOTED(STATIC_SCHEME_INIT, $extern_scheme_init static void static_scheme_init() { $load_scheme_mod },
	[Loads static scheme module initialization functions.])


])
