'\"-
'\" Copyright (c)1997-2005 Hartmut Brandt.
'\" All rights reserved.
'\"
'\" Author: Harti Brandt <harti@freebsd.org>
'\"
'\" Redistribution and use in source and binary forms, with or without
'\" modification, are permitted provided that the following conditions
'\" are met:
'\" 1. Redistributions of source code must retain the above copyright
'\"    notice, this list of conditions and the following disclaimer.
'\" 2. Redistributions in binary form must reproduce the above copyright
'\"    notice, this list of conditions and the following disclaimer in the
'\"    documentation and/or other materials provided with the distribution.
'\"
'\" THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
'\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
'\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
'\" ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
'\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
'\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
'\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
'\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
'\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
'\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
'\" SUCH DAMAGE.
'\"
'\" $Begemot: libbegemot/xalloc.man,v 1.4 2005/06/01 07:51:19 brandt_h Exp $
'\"
.TH xalloc l "31 May 1996" "BEGEMOT" "BEGEMOT Library"
.SH NAME
xalloc, xrealloc - memory allocation with simple error check
.SH SYNOPSIS
.nf
.LP
.B "# include <begemot.h>"
.LP
.BR "void * xalloc(size_t " "size" ");"
.LP
.BR "void * xrealloc(void *" "ptr" ", size_t " "size" ");"
.LP
.BR "void xfree(void *" "ptr" ");"
.fi
.SH DESCRIPTION
These functions are a layer above the
.BR malloc (3C)
and
.BR realloc (3C)
functions.
They call these basic functions and check whether the returned pointer
is
.BR NULL .
In this case
.BR panic (l)
is called with the message 'Out of memory:
.IR " param' ",
where
.I param
are the parameters to the allocation function.
.P
See
.BR malloc (3C)
and
.BR realloc (3C)
for a description of the arguments.
.P
These functions have the following additional features:
.TP
-
.BR xalloc (0)
returns a unique pointer for each call.
.TP
-
.BR xfree (NULL)
is legal.
.TP
-
.BR xrealloc "(NULL, 0)"
behaves like
.BR xalloc (0).
.TP
-
.BR xrealloc "(NULL, s)"
will behave like
.BR xalloc (s).
.TP
-
.BR xrealloc "(p, 0)"
behaves like a sequence of
.BR free (p)
and
.BR xalloc (0).
.SH "RETURN VALUE"
See
.BR malloc (3C)
and
.BR realloc (3C)
for a description of the return values. Note that these functions
never return
.BR NULL .
.SH "SEE ALSO"
.BR malloc (3C),
.BR realloc (3C),
.BR panic (l)
