'\"-
'\" Copyright (c)1997-2005 Hartmut Brandt.
'\" All rights reserved.
'\"
'\" Author: Harti Brandt <harti@freebsd.org>
'\"
'\" Redistribution and use in source and binary forms, with or without
'\" modification, are permitted provided that the following conditions
'\" are met:
'\" 1. Redistributions of source code must retain the above copyright
'\"    notice, this list of conditions and the following disclaimer.
'\" 2. Redistributions in binary form must reproduce the above copyright
'\"    notice, this list of conditions and the following disclaimer in the
'\"    documentation and/or other materials provided with the distribution.
'\"
'\" THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
'\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
'\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
'\" ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
'\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
'\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
'\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
'\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
'\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
'\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
'\" SUCH DAMAGE.
'\"
'\" $Begemot: libbegemot/getfields.man,v 1.3 2005/06/01 07:50:46 brandt_h Exp $
'\"
.TH getfields l "12 Sep 1996" "BEGEMOT" "BEGEMOT Library"
.SH NAME
getfields, getmfields, setfields \- split string into fields
.SH SYNOPSIS
.LP
.B "# include <begemot.h>"
.LP
.BI "int getfields(char *" "str" ", char **" "fields" ", int"
.IB "nfields" ");"
.LP
.BI "int getmfields(char *" "str" ", char **" "fields" ", int"
.IB "nfields" ");"
.LP
.BI "char *setfields(char *" "delim" ");"
.LP
.SH DESCRIPTION
.B getfields
and
.B getmfields
split the input string in substrings as defined by a set of delimiting characters.
The pointer array
.I fields
is filled with pointers to the starts of the substrings. Each substring is
terminated with a NUL character (the original string is modified). The number
of entries in the array is given with
.IR nfields .
If the string contains more substrings than
.I nfields
specifies, the last pointer in
.I fields
will point to the rest of the string.
If there are lesser substrings than entries in
.IR fields ,
the substring pointer array will be NULL terminated.
Both functions return the number of substrings found.
.LP
.B getfields
and
.B getmfields
differ in the interpretation of multiple delimiting characters.
.B getfields
interprets two consecutive delimiters as an empty field, whereas
.B getmfields
collapses multiple delimiters.
.LP
.B setfields
sets a new set of delimiters. A string containing
the old delimiting characters is returned. The default set is
"\\t\ ". The NUL character is always interpreted as a delimiter and
end of string.
.SH "RETURN VALUE"
.B getfields
and
.B getmfields
return the number of substrings.
.B setfields
returns a pointer to static memory containing the old delimiting characters.
This is valid only until the next call to
.B setfields
and can directly be feed into the next
.B setfields
call.
.SH "SEE ALSO"
.BR strtok (3),
.SH BUGS
Could, perhaps, be more performant.
