/*-
 * Copyright (c)1997-2005 by Hartmut Brandt
 * 	All rights reserved.
 *
 * Author: Harti Brandt <harti@freebsd.org>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Begemot: libbegemot/cstrd.c,v 1.6 2005/06/01 07:57:55 brandt_h Exp $
 */
# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include "begemot.h"

# define GROW 100


char *
cstrd(char *ptr, char delim, size_t ilen)
{
	size_t alloc, len;
	char *str;
	unsigned char c;

	alloc = GROW;
	len = 0;
	str = xalloc(alloc);

	while(ilen--) {
		if(len + 5 > alloc) {
			alloc += GROW;
			str = xrealloc(str, alloc);
		}
		c = *(unsigned char *)ptr;
		ptr++;
		if(!isascii(c)) {
			sprintf(&str[len], "\\x%02x", (unsigned)c);
			len += 4;

		} else if(isprint(c)) {
			if(c == '\\' || c == (unsigned char)delim)
				str[len++] = '\\';

			str[len++] = c;

		} else {
			str[len++] = '\\';
			switch(c) {

			  case '\a':
				str[len++] = 'a';
				break;

			  case '\b':
				str[len++] = 'b';
				break;

			  case '\f':
				str[len++] = 'f';
				break;

			  case '\n':
				str[len++] = 'n';
				break;

			  case '\r':
				str[len++] = 'r';
				break;

			  case '\t':
				str[len++] = 't';
				break;

			  case '\v':
				str[len++] = 'v';
				break;

			  default:
				sprintf(&str[len], "x%02x", (unsigned)c);
				len += 3;
				break;
			}
		}
	}

	if(alloc == len) {
		alloc++;
		str = xrealloc(str, alloc);
	}
	str[len] = '\0';

	return str;
}

# ifdef TEST

# include <unistd.h>

int
main(int argc, char *argv[])
{
	int ret;
	char buf[512], *str;

	if((ret = read(0, buf, 512)) > 0) {
		str = cstrd(buf, ret);
		printf("\"%s\"\n", str);
	}

	return 0;
}

# endif
