
import java.io.*;

public class SerializableTest {
  
  public static void main(String args[]) {
    String string1 = "Hello";
    String string2 = "Goodbye";
    String string3;
    String string4;
    int a[] = {1,2,3,4};
    int b[];
    int i;

    try {
      File f = new File("./testobj");
      
      ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(f));
      os.writeObject(string1);
      os.writeObject(string2);
      os.writeObject(a);
      os.close();
      
      ObjectInputStream is = new ObjectInputStream(new FileInputStream(f));
      string3 = (String)is.readObject();
      string4 = (String)is.readObject();
      b = (int[])is.readObject();

      if (string1.equals(string3))
	System.out.println("PASSED: " + string1 + " = " + string3);
      else
	System.out.println("FAILED: Hello");
      
      if (string2.equals(string4))
	System.out.println("PASSED: " + string2 + " = " + string4);
      else
	System.out.println("FAILED: Goodbye");

      if (a.length != b.length)
	System.out.println("FAILED: array lengths differ");
      for (i = 0; i < a.length; i ++)
	if (a[i] != b[i])
	  System.out.println("FAILED: array elements differ");

      System.out.println("PASSED: arrays are identical");
    }
    catch (Exception e)
      {
	System.out.println("FAILED: " + e);
      }
  }
}
