/* -*- Mode: C; c-file-style: "gnu" -*-
   gc.c -- switchable gc's.
   Created: Chris Toshok <toshok@hungry.com>, 1-Oct-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "gc.h"
#include "jniint.h"

#include <stdlib.h>

#ifdef USE_NSPR_GC
extern JGC_struct *NSPR_GC;
#endif
extern JGC_struct *STUB_GC;

JGC_struct*
JGC_getNamed(const char *name)
{
  JGC_struct *default_gc;

#ifdef USE_NSPR_GC
  default_gc = NSPR_GC;
#else
  default_gc = STUB_GC;
#endif

#ifdef USE_NSPR_GC
  if (!strcmp(name, "nspr"))
    return NSPR_GC;
#endif

  return STUB_GC;
}

void
JGC_initCollector(JavaVM *vm,
		  jint initialHeapSize,
		  jint segmentSize,
		  jboolean verbose)
{
  HungryJavaVM *hvm = (HungryJavaVM*)vm;

  if (hvm && hvm->_gc)
    (*hvm->_gc->initCollector)(vm, initialHeapSize, segmentSize, verbose);
}

void
JGC_shutdownCollector(JavaVM *vm,
		      jboolean finalizeOnExit)
{
  HungryJavaVM *hvm = (HungryJavaVM*)vm;

  if (hvm && hvm->_gc)
    (*hvm->_gc->shutdownCollector)(vm, finalizeOnExit);
}

void*
JGC_allocObject(JavaVM *vm, jsize size)
{
  HungryJavaVM *hvm = (HungryJavaVM*)vm;

  if (hvm && hvm->_gc)
    return (*hvm->_gc->allocObject)(vm, size);
  else
    return calloc(1, size);
}

void*
JGC_allocClazzFile(JavaVM *vm, jsize size)
{
  HungryJavaVM *hvm = (HungryJavaVM*)vm;

  if (hvm && hvm->_gc)
    return (*hvm->_gc->allocClazzFile)(vm, size);
  else
    return calloc(1, size);
}

void
JGC_runCollector(JavaVM *vm)
{
  HungryJavaVM *hvm = (HungryJavaVM*)vm;

  if (hvm && hvm->_gc)
    (*hvm->_gc->runCollector)(vm);
}

void
JGC_runFinalizers(JavaVM *vm)
{
  HungryJavaVM *hvm = (HungryJavaVM*)vm;

  if (hvm && hvm->_gc)
    (*hvm->_gc->runFinalizers)(vm);
}

void
JGC_addThread(JavaVM *vm, JNIEnv *env)
{
  HungryJavaVM *hvm = (HungryJavaVM*)vm;

  if (hvm && hvm->_gc)
    (*hvm->_gc->addThread)(vm, env);
}

void
JGC_removeThread(JavaVM *vm, JNIEnv *env)
{
  HungryJavaVM *hvm = (HungryJavaVM*)vm;

  if (hvm && hvm->_gc)
    (*hvm->_gc->removeThread)(vm, env);
}

void
JGC_printStats(JavaVM *vm, FILE *out)
{
  HungryJavaVM *hvm = (HungryJavaVM*)vm;

  if (hvm && hvm->_gc)
    (*hvm->_gc->printStats)(vm, out);
}
