/* -*- Mode: C; c-file-style: "gnu" -*-
   japharJVMConsole.h -- japhar's java console for mozilla.
   Created: Chris Toshok <toshok@hungry.com>, 19-Sep-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* nscp headers */
#include "nsAgg.h"
#include "nsplugin.h"
#include "nsIJVMConsole.h"

class japharJVMConsole : public nsIJVMConsole {
public:
  NS_DECL_AGGREGATED

  japharJVMConsole(nsISupports* outer);
  virtual ~japharJVMConsole();

  /////////////////////////////////////////////////
  // nsIJVMConsole Interface
  /////////////////////////////////////////////////

  NS_IMETHOD
  ShowConsole(void);
  
  NS_IMETHOD
  HideConsole(void);
  
  NS_IMETHOD
  IsConsoleVisible(PRBool *result);

  // Prints a message to the Java console. The encodingName specifies the
  // encoding of the message, and if NULL, specifies the default platform
  // encoding.
  NS_IMETHOD
  Print(const char* msg, const char* encodingName = NULL);

protected:
  jobject _console;
  jmethodID _printMethod;
  jmethodID _hideMethod;
  jmethodID _showMethod;
};
