/* -*- Mode: C; c-file-style: "gnu" -*-
   japharJVMConsole.cpp -- japhar's java console for mozilla.
   Created: Chris Toshok <toshok@hungry.com>, 19-Sep-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"

#include "jniint.h"
#include "japharJVMConsole.h"

japharJVMConsole::japharJVMConsole(nsISupports* outer)
{
  NS_INIT_AGGREGATED(outer);
}

japharJVMConsole::~japharJVMConsole()
{
  JNIEnv *env = THREAD_getEnv();
  
  env->DeleteGlobalRef(_console);
}

NS_IMPL_AGGREGATED(japharJVMConsole)

  nsresult
japharJVMConsole::AggregatedQueryInterface(const nsIID& aIID,
					   void ** aInstancePtr)
{
  static NS_DEFINE_IID(kISupportsIID, NS_ISUPPORTS_IID);
  static NS_DEFINE_IID(kIJVMConsoleIID, NS_IJVMCONSOLE_IID);

  if (NULL == aInstancePtr)
    {
      return NS_ERROR_NULL_POINTER;
    }
  else if (aIID.Equals(kIJVMConsoleIID))
    {
      *aInstancePtr = (void*) ((nsIJVMConsole*)this);
    }
  else if (aIID.Equals(kISupportsIID))
    {
      *aInstancePtr = (void*) ((nsISupports*)this);
    }
  return NS_NOINTERFACE;
}

/////////////////////////////////////////////////
// nsIJVMConsole Interface
/////////////////////////////////////////////////

nsresult
japharJVMConsole::ShowConsole(void)
{
  JNIEnv *env = THREAD_getEnv();

  printf ("In japharJVMConsole::ShowConsole\n");

  env->CallVoidMethod(_console, _showMethod);

  return NS_OK;
}

nsresult
japharJVMConsole::HideConsole(void)
{
  JNIEnv *env = THREAD_getEnv();

  printf ("In japharJVMConsole::HideConsole\n");

  env->CallVoidMethod(_console, _hideMethod);

  return NS_OK;
}

nsresult
japharJVMConsole::IsConsoleVisible(PRBool *result)
{
  printf ("In japharJVMConsole::isConsoleVisible\n");
  *result = PR_FALSE;
  return NS_OK;
}

// Prints a message to the Java console. The encodingName specifies the
// encoding of the message, and if NULL, specifies the default platform
// encoding.
nsresult
japharJVMConsole::Print(const char* msg,
			const char* encodingName)
{
  JNIEnv *env = THREAD_getEnv();
  jstring msg_str, encoding_str;

  if (encodingName == NULL)
    encodingName = "";

  msg_str = env->NewStringUTF(msg);
  encoding_str = env->NewStringUTF(encodingName);

  printf ("In japharJVMConsole::Print(msg = %s)\n", msg);
  
  env->CallVoidMethod(_console, _printMethod, msg_str, encoding_str);

  return NS_OK;
}
