/* -*- Mode: C; c-file-style: "gnu" -*-
   label.c -- native methods for sun/awt/motif/MLabelPeer
   Created: Chris Toshok <toshok@hungry.com>, 9-Mar-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"
#include "log.h"

#include "common.h"

#include <Xm/Xm.h>
#include <Xm/Label.h>

JNIEXPORT void JNICALL
Java_sun_awt_motif_MLabelPeer_create(JNIEnv *env,
				     jobject peer,
				     jobject parent_peer)
{
  Widget label_widget, parent_widget;
  Arg av[10];
  int ac;

  JAVARLOG1 (AWT_LOG, 2, "in sun_awt_motif_MLabelPeer_create(peer = %p)\n", peer);

  parent_widget = get_component_widget(env, parent_peer);

  LOCK_AWT();

  ac = 0;
  XtSetArg(av[ac], XmNalignment, XmALIGNMENT_BEGINNING); ac++;
  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;
  XtSetArg(av[ac], XmNrecomputeSize, False); ac++;

  label_widget = XmCreateLabel(parent_widget,
			       "label",
			       av, ac);

  inherit_background_from(parent_widget, label_widget);

  UNLOCK_AWT();

  set_component_widget(env, peer, label_widget);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MLabelPeer_setText(JNIEnv *env,
				      jobject peer,
				      jstring text)
{
  Widget label_widget = get_component_widget(env, peer);
  const jbyte *label_text = (*env)->GetStringUTFChars(env, text, NULL);
  XmString label_xmstring;

  JAVARLOG2 (AWT_LOG, 2, "in sun_awt_motif_MLabelPeer_setText(peer = %p, text = %s)\n", peer, label_text);
  printf ("in sun_awt_motif_MLabelPeer_setText(peer = %p, text = %s)\n", peer, label_text);

  LOCK_AWT();

  label_xmstring = XmStringCreate((char*)label_text, XmFONTLIST_DEFAULT_TAG);
  XtVaSetValues(label_widget,
		XmNlabelString, label_xmstring,
		NULL);

  XmStringFree(label_xmstring);

  UNLOCK_AWT();

  (*env)->ReleaseStringUTFChars(env, text, label_text);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MLabelPeer_setAlignment(JNIEnv *env,
					   jobject peer,
					   jint alignment)
{
  Widget label_widget = get_component_widget(env, peer);

  LOCK_AWT();
  XtVaSetValues(label_widget,
		XmNalignment, alignment,
		NULL);
  UNLOCK_AWT();
}
