/* -*- Mode: C; c-file-style: "gnu" -*-
   graphicsconf.c -- native methods for sun/awt/X11GraphicsConfig.
   Created: Chris Toshok <toshok@hungry.com>, 13-Feb-1999
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"
#include "jniint.h"

#include "common.h"

#include <stdlib.h>
#include <string.h>

JNIEXPORT jint JNICALL
Java_sun_awt_X11GraphicsConfig_getNumColors(JNIEnv *env,
					    jobject config_obj)
{
}

JNIEXPORT jdouble JNICALL
Java_sun_awt_X11GraphicsConfig_getXResolution(JNIEnv *env,
					      jobject config_obj)
{
}

JNIEXPORT jdouble JNICALL
Java_sun_awt_X11GraphicsConfig_getYResolution(JNIEnv *env,
					      jobject config_obj)
{
}

JNIEXPORT void JNICALL
Java_sun_awt_X11GraphicsConfig_init(JNIEnv *env,
				    jobject config_obj,
				    jint foo)
{
}

JNIEXPORT jobject JNICALL
Java_sun_awt_X11GraphicsConfig_makeColorModel(JNIEnv *env,
					      jobject config_obj)
{
  jint red_mask = 0xf800;
  jint green_mask = 0x7e0;
  jint blue_mask = 0x1f;
  jclass direct_color_cls = (*env)->FindClass(env, "java/awt/image/DirectColorModel");
  jmethodID ctor;

  ctor = (*env)->GetMethodID(env, direct_color_cls, "<init>",
			     "(IIII)V");

  return (*env)->NewObject(env, direct_color_cls, ctor, 
			   16, red_mask, green_mask, blue_mask);
}

JNIEXPORT void JNICALL
Java_sun_awt_X11GraphicsConfig_initIDs(JNIEnv *env,
				       jclass cls)
{
}
