/* -*- Mode: C; c-file-style: "gnu" -*-
   choice.c -- native methods for sun/awt/motif/MChoicePeer..
   Created: Chris Toshok <toshok@hungry.com>, 14-Sep-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"

#include "common.h"
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushBG.h>

#include <assert.h>
#include <stdlib.h>

/**
 * WARNING: returned pointer must be freed by caller
 */
static char *
jstring2charptr(JNIEnv *env, jstring jstr)
{
  char *str_copy;
  const jbyte *str_chars;
  int str_length;
  str_chars = (*env)->GetStringUTFChars(env, jstr, NULL);
  str_length = (*env)->GetStringUTFLength(env, jstr) + 1;
  str_copy = (char*) malloc(str_length * sizeof(char));
  strncpy(str_copy, (char*)str_chars, str_length);
  (*env)->ReleaseStringUTFChars(env, jstr, str_chars);
  str_copy[str_length-1] = 0; /* Make sure the string is zero terminated */
  return str_copy;
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MChoicePeer_create(JNIEnv *env,
				      jobject peer,
				      jobject parent_peer)
{
  Widget choice;
  Widget parent;
  Widget menu_widget;
  Arg av[10];
  int ac;

  parent = get_component_widget(env, parent_peer);

  LOCK_AWT();

  menu_widget = XmCreatePulldownMenu(parent,
				     "pulldown",
				     NULL, 0);

  ac = 0;
  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;
  XtSetArg(av[ac], XmNsubMenuId, menu_widget); ac++;
  
  choice = XmCreateOptionMenu(parent,
			      "choice",
			      av, ac);

  inherit_background_from(parent, choice);
  inherit_background_from(parent, menu_widget);

  UNLOCK_AWT();

  set_component_widget(env, peer, choice);
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MChoicePeer_pReshape(JNIEnv *env,
					jobject peer,
					jint x,
					jint y,
					jint width,
					jint height)
{
  Widget widget = get_component_widget(env, peer);

  printf ("choicepeer.reshape(%p, %d, %d, %d, %d)\n", peer,
	  x, y, width, height);

  LOCK_AWT();

  XtVaSetValues(widget,
		XmNx, x,
		XmNy, y,
		NULL);

  if (width && height)
    XtVaSetValues(widget,
		  XmNwidth, width,
		  XmNheight, height,
		  NULL);

  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MChoicePeer_select(JNIEnv *env,
				      jobject peer,
				      jint index)
{
  printf ("mchoicepeer_select\n");
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MChoicePeer_setFont(JNIEnv *env,
				       jobject peer,
				       jobject font)
{
  printf ("mchoicepeer_setFont\n");
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MChoicePeer_remove(JNIEnv *env,
				      jobject peer,
				      jint index)
{
  printf ("mchoicepeer_remove\n");
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MChoicePeer_addItem(JNIEnv *env,
				       jobject peer,
				       jstring item_text,
				       jint index)
{
  char *text;
  XmString xmstr;
  Widget choice = get_component_widget(env, peer);
  Widget parent_menu_widget;
  Widget button;
  Arg av[10];
  int ac;

  LOCK_AWT();

  text = jstring2charptr(env, item_text);
  xmstr = XmStringCreateSimple(text);
  free(text);

  XtVaGetValues(choice,
		XmNsubMenuId, &parent_menu_widget,
		NULL);

  ac = 0;
  XtSetArg(av[ac], XmNlabelString, xmstr); ac++;

  button = XmCreatePushButtonGadget(parent_menu_widget,
				    "button",
				    av, ac);
  XtManageChild(button);

  XmStringFree(xmstr);

  UNLOCK_AWT();
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MChoicePeer_setBackground(JNIEnv *env,
					     jobject peer,
					     jobject color)
{
  printf ("mchoicepeer_setBackground\n");
}

JNIEXPORT void JNICALL
Java_sun_awt_motif_MChoicePeer_setForeground(JNIEnv *env,
					     jobject peer,
					     jobject color)
{
  printf ("mchoicepeer_setForeground\n");
}
