/* -*- Mode: C; c-file-style: "gnu" -*-
   adler32.c -- native methods for java/util/zip/Adler32
   Created: Chris Toshok <toshok@hungry.com>, 9-Nov-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"
#include "jni.h"
#include "zlib.h"
#include "objects.h"

static jint
get_adler(JNIEnv *env,
	  jobject obj)
{
  jfieldID adler_field;
  jclass adler_class = (*env)->GetObjectClass(env, obj);

  adler_field = (*env)->GetFieldID(env, adler_class, "adler", "I");

  return (*env)->GetIntField(env, obj, adler_field);
}

static void
set_adler(JNIEnv *env,
	  jobject obj,
	  jint adler)
{
  jfieldID adler_field;
  jclass adler_class = (*env)->GetObjectClass(env, obj);

  adler_field = (*env)->GetFieldID(env, adler_class, "adler", "I");

  (*env)->SetIntField(env, obj, adler_field, adler);
}

JNIEXPORT void JNICALL
Java_java_util_zip_Adler32_update(JNIEnv *env,
				  jobject obj,
				  jbyteArray b,
				  jint off,
				  jint len)
{
  jint adler = get_adler(env, obj);
  jbyte* bytes;

  bytes = (*env)->GetByteArrayElements(env, b, NULL);

  adler = adler32(adler,
		  bytes + off,
		  len);

  (*env)->ReleaseByteArrayElements(env, b, bytes, 0);

  set_adler(env, obj, adler);
}

#ifndef JDK1_1
JNIEXPORT void JNICALL
Java_java_util_zip_Adler32_updateBytes(JNIEnv *env,
				       jclass cls,
				       jbyteArray b,
				       jint off,
				       jint len)
{
  (*env)->FatalError(env, "Java_java_util_zip_Adler32_updateBytes not implemented");
}
#endif

JNIEXPORT void JNICALL
Java_java_util_zip_Adler32_update1(JNIEnv *env,
				   jobject obj,
				   jint b)
{
  jint adler = get_adler(env, obj);
  jbyte byte = (jbyte)b;

  adler = adler32(adler,
		  &byte, 1);

  set_adler(env, obj, adler);
}
