/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"

#include "dynamic_loading.h"

#if !defined HAVE_LIBFFI || !defined HAVE_DLL || defined PROFILING

#include "java_net_PlainSocketImpl_stubs.c"
#include "java_net_PlainDatagramSocketImpl_stubs.c"
#include "java_net_InetAddressImpl_stubs.c"
#include "java_net_SocketInputStream_stubs.c"
#include "java_net_SocketOutputStream_stubs.c"

sym_mapping java_net_mappings[] = {
  MAPPING( Java_java_net_PlainSocketImpl_socketCreate_stub ),
  MAPPING( Java_java_net_PlainSocketImpl_socketConnect_stub ),
  MAPPING( Java_java_net_PlainSocketImpl_socketBind_stub ),
  MAPPING( Java_java_net_PlainSocketImpl_socketListen_stub ),
  MAPPING( Java_java_net_PlainSocketImpl_socketAccept_stub ),
  MAPPING( Java_java_net_PlainSocketImpl_socketAvailable_stub ),
  MAPPING( Java_java_net_PlainSocketImpl_socketClose_stub ),
  MAPPING( Java_java_net_PlainSocketImpl_initProto_stub ),
  MAPPING( Java_java_net_PlainSocketImpl_socketSetOption_stub ),
  MAPPING( Java_java_net_PlainSocketImpl_socketGetOption_stub ),

  MAPPING( Java_java_net_PlainDatagramSocketImpl_getTTL_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_peek_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_socketGetOption_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_bind_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_datagramSocketClose_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_datagramSocketCreate_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_join_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_leave_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_receive_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_send_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_setTTL_stub ),
  MAPPING( Java_java_net_PlainDatagramSocketImpl_socketSetOption_stub ),

  MAPPING( Java_java_net_InetAddressImpl_getLocalHostName_stub ),
  MAPPING( Java_java_net_InetAddressImpl_makeAnyLocalAddress_stub ),
  MAPPING( Java_java_net_InetAddressImpl_lookupAllHostAddr_stub ),
  MAPPING( Java_java_net_InetAddressImpl_getHostByAddr_stub ),
  MAPPING( Java_java_net_InetAddressImpl_getInetFamily_stub ),

  MAPPING( Java_java_net_SocketInputStream_socketRead_stub ),
  MAPPING( Java_java_net_SocketOutputStream_socketWrite_stub )
};

int num_java_net_mappings = sizeof(java_net_mappings) / sizeof(java_net_mappings[0]);

#endif
