/* -*- Mode: C; c-file-style: "gnu" -*-
   fileout.c -- native methods for java/io/FileOutputStream.
   Created: Chris Toshok <toshok@hungry.com>, 28-Jul-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jni.h"
#include "objects.h"
#include "exceptions.h" /* For throw_Exception() */
#include "common.h"
#include <fcntl.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

/* JDK1.2 */
JNIEXPORT void JNICALL
Java_java_io_FileOutputStream_initIDs(JNIEnv *env,
				      jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_io_FileOutputStream_open(JNIEnv *env,
				   jobject obj,
				   jobject name)
{
  file_open(env, obj, name, O_TRUNC | O_CREAT | O_WRONLY
#ifdef O_LARGEFILE
	    | O_LARGEFILE
#endif
	    );
}

JNIEXPORT void JNICALL
Java_java_io_FileOutputStream_openAppend(JNIEnv *env,
					 jobject obj,
					 jobject name)
{
  file_open(env, obj, name, O_APPEND | O_CREAT | O_WRONLY
#ifdef O_LARGEFILE
	    | O_LARGEFILE
#endif
	    );
}

JNIEXPORT void JNICALL
Java_java_io_FileOutputStream_write(JNIEnv *env,
				    jobject obj,
				    jint byte)
{
  file_write(env, obj, byte);
}

JNIEXPORT void JNICALL
Java_java_io_FileOutputStream_writeBytes(JNIEnv *env,
					 jobject obj,
					 jbyteArray array,
					 jint offset,
					 jint length)
{
  file_writeBytes(env, obj, array, offset, length);
}

JNIEXPORT void JNICALL
Java_java_io_FileOutputStream_close(JNIEnv *env,
				    jobject obj)
{
  file_close(env, obj);
}
