/* -*- Mode: C; c-file-style: "gnu" -*-
   jnivtbl.c -- Java Native Interface vtable.
   Created: Chris Toshok <toshok@hungry.com>, 26-Jul-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jni.h"
#include "jniint.h"

jint
JNIFUNC(GetVersion)(JNIEnv *env)
{
  return ((HungryJNIEnv*)env)->_vm->_version;
}

const struct JNINativeInterface _hungryJNIInterface = {
  NULL,
  NULL,
  NULL,
  NULL,
  JNIFUNC(GetVersion),
	
  JNIFUNC(DefineClass),
  JNIFUNC(FindClass),
  NULL,
  NULL,
  NULL,
  JNIFUNC(GetSuperclass),
  JNIFUNC(IsAssignableFrom),
  NULL,

  JNIFUNC(Throw),
  JNIFUNC(ThrowNew),
  JNIFUNC(ExceptionOccurred),
  JNIFUNC(ExceptionDescribe),
  JNIFUNC(ExceptionClear),
  JNIFUNC(FatalError),
  NULL,
  NULL,

  JNIFUNC(NewGlobalRef),
  JNIFUNC(DeleteGlobalRef),
  JNIFUNC(DeleteLocalRef),
  JNIFUNC(IsSameObject),
  NULL,
  NULL,

  JNIFUNC(AllocObject),
  JNIFUNC(NewObject),
  JNIFUNC(NewObjectV),
  JNIFUNC(NewObjectA),
  
  JNIFUNC(GetObjectClass),
  JNIFUNC(IsInstanceOf),

  JNIFUNC(GetMethodID),

  JNIFUNC(CallObjectMethod),
  JNIFUNC(CallObjectMethodV),
  JNIFUNC(CallObjectMethodA),
  JNIFUNC(CallBooleanMethod),
  JNIFUNC(CallBooleanMethodV),
  JNIFUNC(CallBooleanMethodA),
  JNIFUNC(CallByteMethod),
  JNIFUNC(CallByteMethodV),
  JNIFUNC(CallByteMethodA),
  JNIFUNC(CallCharMethod),
  JNIFUNC(CallCharMethodV),
  JNIFUNC(CallCharMethodA),
  JNIFUNC(CallShortMethod),
  JNIFUNC(CallShortMethodV),
  JNIFUNC(CallShortMethodA),
  JNIFUNC(CallIntMethod),
  JNIFUNC(CallIntMethodV),
  JNIFUNC(CallIntMethodA),
  JNIFUNC(CallLongMethod),
  JNIFUNC(CallLongMethodV),
  JNIFUNC(CallLongMethodA),
  JNIFUNC(CallFloatMethod),
  JNIFUNC(CallFloatMethodV),
  JNIFUNC(CallFloatMethodA),
  JNIFUNC(CallDoubleMethod),
  JNIFUNC(CallDoubleMethodV),
  JNIFUNC(CallDoubleMethodA),
  JNIFUNC(CallVoidMethod),
  JNIFUNC(CallVoidMethodV),
  JNIFUNC(CallVoidMethodA),

  JNIFUNC(CallNonvirtualObjectMethod),
  JNIFUNC(CallNonvirtualObjectMethodV),
  JNIFUNC(CallNonvirtualObjectMethodA),
  JNIFUNC(CallNonvirtualBooleanMethod),
  JNIFUNC(CallNonvirtualBooleanMethodV),
  JNIFUNC(CallNonvirtualBooleanMethodA),
  JNIFUNC(CallNonvirtualByteMethod),
  JNIFUNC(CallNonvirtualByteMethodV),
  JNIFUNC(CallNonvirtualByteMethodA),
  JNIFUNC(CallNonvirtualCharMethod),
  JNIFUNC(CallNonvirtualCharMethodV),
  JNIFUNC(CallNonvirtualCharMethodA),
  JNIFUNC(CallNonvirtualShortMethod),
  JNIFUNC(CallNonvirtualShortMethodV),
  JNIFUNC(CallNonvirtualShortMethodA),
  JNIFUNC(CallNonvirtualIntMethod),
  JNIFUNC(CallNonvirtualIntMethodV),
  JNIFUNC(CallNonvirtualIntMethodA),
  JNIFUNC(CallNonvirtualLongMethod),
  JNIFUNC(CallNonvirtualLongMethodV),
  JNIFUNC(CallNonvirtualLongMethodA),
  JNIFUNC(CallNonvirtualFloatMethod),
  JNIFUNC(CallNonvirtualFloatMethodV),
  JNIFUNC(CallNonvirtualFloatMethodA),
  JNIFUNC(CallNonvirtualDoubleMethod),
  JNIFUNC(CallNonvirtualDoubleMethodV),
  JNIFUNC(CallNonvirtualDoubleMethodA),
  JNIFUNC(CallNonvirtualVoidMethod),
  JNIFUNC(CallNonvirtualVoidMethodV),
  JNIFUNC(CallNonvirtualVoidMethodA),

  JNIFUNC(GetFieldID),

  JNIFUNC(GetObjectField),
  JNIFUNC(GetBooleanField),
  JNIFUNC(GetByteField),
  JNIFUNC(GetCharField),
  JNIFUNC(GetShortField),
  JNIFUNC(GetIntField),
  JNIFUNC(GetLongField),
  JNIFUNC(GetFloatField),
  JNIFUNC(GetDoubleField),
  JNIFUNC(SetObjectField),
  JNIFUNC(SetBooleanField),
  JNIFUNC(SetByteField),
  JNIFUNC(SetCharField),
  JNIFUNC(SetShortField),
  JNIFUNC(SetIntField),
  JNIFUNC(SetLongField),
  JNIFUNC(SetFloatField),
  JNIFUNC(SetDoubleField),

  JNIFUNC(GetStaticMethodID),

  JNIFUNC(CallStaticObjectMethod),
  JNIFUNC(CallStaticObjectMethodV),
  JNIFUNC(CallStaticObjectMethodA),
  JNIFUNC(CallStaticBooleanMethod),
  JNIFUNC(CallStaticBooleanMethodV),
  JNIFUNC(CallStaticBooleanMethodA),
  JNIFUNC(CallStaticByteMethod),
  JNIFUNC(CallStaticByteMethodV),
  JNIFUNC(CallStaticByteMethodA),
  JNIFUNC(CallStaticCharMethod),
  JNIFUNC(CallStaticCharMethodV),
  JNIFUNC(CallStaticCharMethodA),
  JNIFUNC(CallStaticShortMethod),
  JNIFUNC(CallStaticShortMethodV),
  JNIFUNC(CallStaticShortMethodA),
  JNIFUNC(CallStaticIntMethod),
  JNIFUNC(CallStaticIntMethodV),
  JNIFUNC(CallStaticIntMethodA),
  JNIFUNC(CallStaticLongMethod),
  JNIFUNC(CallStaticLongMethodV),
  JNIFUNC(CallStaticLongMethodA),
  JNIFUNC(CallStaticFloatMethod),
  JNIFUNC(CallStaticFloatMethodV),
  JNIFUNC(CallStaticFloatMethodA),
  JNIFUNC(CallStaticDoubleMethod),
  JNIFUNC(CallStaticDoubleMethodV),
  JNIFUNC(CallStaticDoubleMethodA),
  JNIFUNC(CallStaticVoidMethod),
  JNIFUNC(CallStaticVoidMethodV),
  JNIFUNC(CallStaticVoidMethodA),

  JNIFUNC(GetStaticFieldID),

  JNIFUNC(GetStaticObjectField),
  JNIFUNC(GetStaticBooleanField),
  JNIFUNC(GetStaticByteField),
  JNIFUNC(GetStaticCharField),
  JNIFUNC(GetStaticShortField),
  JNIFUNC(GetStaticIntField),
  JNIFUNC(GetStaticLongField),
  JNIFUNC(GetStaticFloatField),
  JNIFUNC(GetStaticDoubleField),
  JNIFUNC(SetStaticObjectField),
  JNIFUNC(SetStaticBooleanField),
  JNIFUNC(SetStaticByteField),
  JNIFUNC(SetStaticCharField),
  JNIFUNC(SetStaticShortField),
  JNIFUNC(SetStaticIntField),
  JNIFUNC(SetStaticLongField),
  JNIFUNC(SetStaticFloatField),
  JNIFUNC(SetStaticDoubleField),
  
  JNIFUNC(NewString),
  JNIFUNC(GetStringLength),
  JNIFUNC(GetStringChars),
  JNIFUNC(ReleaseStringChars),

  JNIFUNC(NewStringUTF),
  JNIFUNC(GetStringUTFLength),
  JNIFUNC(GetStringUTFChars),
  JNIFUNC(ReleaseStringUTFChars),

  JNIFUNC(GetArrayLength),

  JNIFUNC(NewObjectArray),
  JNIFUNC(GetObjectArrayElement),
  JNIFUNC(SetObjectArrayElement),

  JNIFUNC(NewBooleanArray),
  JNIFUNC(NewByteArray),
  JNIFUNC(NewCharArray),
  JNIFUNC(NewShortArray),
  JNIFUNC(NewIntArray),
  JNIFUNC(NewLongArray),
  JNIFUNC(NewFloatArray),
  JNIFUNC(NewDoubleArray),

  JNIFUNC(GetBooleanArrayElements),
  JNIFUNC(GetByteArrayElements),
  JNIFUNC(GetCharArrayElements),
  JNIFUNC(GetShortArrayElements),
  JNIFUNC(GetIntArrayElements),
  JNIFUNC(GetLongArrayElements),
  JNIFUNC(GetFloatArrayElements),
  JNIFUNC(GetDoubleArrayElements),

  JNIFUNC(ReleaseBooleanArrayElements),
  JNIFUNC(ReleaseByteArrayElements),
  JNIFUNC(ReleaseCharArrayElements),
  JNIFUNC(ReleaseShortArrayElements),
  JNIFUNC(ReleaseIntArrayElements),
  JNIFUNC(ReleaseLongArrayElements),
  JNIFUNC(ReleaseFloatArrayElements),
  JNIFUNC(ReleaseDoubleArrayElements),

  JNIFUNC(GetBooleanArrayRegion),
  JNIFUNC(GetByteArrayRegion),
  JNIFUNC(GetCharArrayRegion),
  JNIFUNC(GetShortArrayRegion),
  JNIFUNC(GetIntArrayRegion),
  JNIFUNC(GetLongArrayRegion),
  JNIFUNC(GetFloatArrayRegion),
  JNIFUNC(GetDoubleArrayRegion),

  JNIFUNC(SetBooleanArrayRegion),
  JNIFUNC(SetByteArrayRegion),
  JNIFUNC(SetCharArrayRegion),
  JNIFUNC(SetShortArrayRegion),
  JNIFUNC(SetIntArrayRegion),
  JNIFUNC(SetLongArrayRegion),
  JNIFUNC(SetFloatArrayRegion),
  JNIFUNC(SetDoubleArrayRegion),
  
  JNIFUNC(RegisterNatives),
  JNIFUNC(UnregisterNatives),

  JNIFUNC(MonitorEnter),
  JNIFUNC(MonitorExit),

  JNIFUNC(GetJavaVM),

  /* new for JDK 1.2 */
  JNIFUNC(EnsureLocalCapacity),
  JNIFUNC(PushLocalFrame),
  JNIFUNC(PopLocalFrame),
  JNIFUNC(NewLocalRef),
  JNIFUNC(NewWeakGlobalRef),
  JNIFUNC(DeleteWeakGlobalRef),
  JNIFUNC(GetPrimitiveArrayCritical),
  JNIFUNC(ReleasePrimitiveArrayCritical),
  JNIFUNC(GetStringRegion),
  JNIFUNC(GetStringUTFRegion),

  JNIFUNC(GetStringCritical),
  JNIFUNC(ReleaseStringCritical),
  JNIFUNC(FromReflectedMethod),
  JNIFUNC(FromReflectedField),
  JNIFUNC(ToReflectedMethod),
  JNIFUNC(ToReflectedField)
};
