/* -*- Mode: C; c-file-style: "gnu" -*-
   jnicpp.c -- Parts of the JNI that have to be written in C++ (like the JNIEnv* allocation routine.)
   Created: Chris Toshok <toshok@hungry.com>, 30-Jun-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jniint.h"

HungryJNIEnv*
JNIFUNC(AllocHungryJNIEnv)()
{
  HungryJNIEnv *env = new HungryJNIEnv();

  env->next = NULL;
  env->prev = NULL;
  env->_vm = NULL;
  env->_thr = NULL;
  env->_java_info = NULL;
#if 0
  env->_local_refs = NULL;
#endif
  env->_exception = NULL;
  env->_jit = NULL;

  return env;
}

void
JNIFUNC(DeallocHungryJNIEnv)(HungryJNIEnv *env)
{
  delete env;
}

HungryJavaVM*
JNIFUNC(AllocHungryJavaVM)()
{
  HungryJavaVM* vm =  new HungryJavaVM();

  vm->next = NULL;
  vm->prev = NULL;
  vm->_mon = NULL;
  vm->_cp_entries = NULL;
  vm->_class_repository = NULL;
  vm->_envs = NULL;
  vm->_initial_env = NULL;
  vm->_gc = NULL;
  vm->_string_cf =
    vm->_class_cf =
    vm->_object_cf = NULL;

  vm->_num_cp_entries =
    vm->_finalizers_on_exit = 0;

  vm->_verbose_flags = 0;

  vm->vfprintf = NULL;
  vm->exit = NULL;
  vm->abort = NULL;

  return vm;
}

void
JNIFUNC(DeallocHungryJavaVM)(HungryJavaVM *vm)
{
  delete vm;
}
