#ifndef _ARGUMENT_H
#define _ARGUMENT_H

/*
** $Id: argument.h,v 1.2 2001/08/31 22:06:54 buytaert Exp $
*/

#include "jamjar.h"

typedef struct j_Arg {
  j_arg   next;                 // doubly linked list next
  j_arg   previous;             // doubly linked list previous
  size_t  size;                 // Size of the file in bytes
  time_t  time;                 // Time of last modification
  char *  file;                 // The name of the file passed as argument
  char *  z_name;               // The name as it should appear in the jarfile
  j_flags flags;                // Flags, see below for ARG_xxxxxx flags below
  j_res   res;                  // The resource attached to this argument
  char *  dir;                  // The directory we change to, to read the file
  char *  msg;                  // Messages about this argument
} j_Arg;

#define ARG_CLASS    0x00000001 // Argument is classfile
#define ARG_OUT_JAR  0x00000002 // Argument is output jarfile
#define ARG_IN_JAR   0x00000004 // Argument is jarfile that is included in the output jar
#define ARG_MANIFEST 0x00000080 // Argument is manifest file
#define ARG_EXTRACT  0x00000400 // Argument is a file that needs to be extracted from jarfile
#define ARG_LIST     0x00001000 // List argument to standard output
#define ARG_ZPATH    0x00004000 // Argument indicates in file component, the path that should be used for following files
#define ARG_EXISTS   0x00008000 // The file is available in the system
#define ARG_DIR      0x00010000 // Argument is a directory, recursively scan it.
#define ARG_WARNING  0x00020000 // Argument contains a warning, msg may contain more info.
#define ARG_STORE    0x00080000 // Only store the file of argument, don't compress

void args_read(int argc, char * argv[]);
void print_usage(char * msg);

#endif /* _ARGUMENT_H */

