import struct

class CStructure:
	def __init__(self, theTuples):
		self.members = {}
		self.shape = theTuples
		self.packFormat = ''

		for n,f in self.shape:
			self.members[n] = None
			self.packFormat = self.packFormat + f
		
		self.fromBytes(struct.pack('%dx' % (len(self))))

	def checkMember(self, name):
		if not self.members.has_key(name):
			raise AttributeError, "No member is named " + name

	def member(self, name, *value):
		if len(value) == 0:
			return self.getMember(name)
		else:
			return self.setMember(name, value[0])

	def getMember(self, name):
		self.checkMember(name)
		return self.members[name]

	def setMember(self, name, value):
		self.checkMember(name)
		self.members[name] = value
		return value

	def __len__(self):
		return struct.calcsize(self.packFormat)

	def asBytes(self):
		bytes = ''

		for n,f in self.shape:
			if f[-1] == 'x':
				bytes = bytes + struct.pack(f)
			else:
				bytes = bytes + struct.pack(f, self.members[n])

		return bytes

	def fromBytes(self, bytes):
		values = struct.unpack(self.packFormat, bytes)
		for i in range(len(values)):
			self.setMember(self.shape[i][0], values[i])
		return self
