/*
This function was inspired by the ZAP program available on
Data General's AOS/VS systems in the 80s.  I liked
the format of the output so much I created my
own version of it.

zap() returns a pointer to a character buffer containing the 
zap'ed buffer.  DO NOT FREE IT.  It's a static buffer.

This function is NOT THREAD SAFE.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

char *
zapLine(char *buf,				/* array of character to display to the screen */
		int bufsize,			/* the size of the array */
		int cpl					/* characters per line = 16 or 64 */
	)
{
	int size;
	char hex[50], ascii[66];
	static workArea[128];
	char *buffer[2];
	int i, j, pos;

	memset(hex, ' ', sizeof(hex));
	memset(ascii, ' ', sizeof(ascii));

	for (i = 0, j = 0; i < cpl && i < bufsize; i++, j += 3) {
		ascii[i] = buf[i];
		if (cpl == 16)
			sprintf(&hex[j], "%02x ", (unsigned char) ascii[i]);

		if (buf[i] < ' ' || buf[i] >= 0x7f)
			ascii[i] = '.';
	}

	hex[sizeof(hex)] = ascii[cpl] = 0;
	if (cpl == 16)
		sprintf(workArea, "%-47.47s   %s", hex, ascii);
	else
		sprintf(workArea, "%s", ascii);

	return (char *) workArea;
}
