#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_JNI_H

#include "isdio.h"
#include "isect_io_IsdIO.h"


/* #define ISDDEBUG */

#ifdef ISDDEBUG
static void dumpIsdHeader(isdHeader *h)
{
	isdLog(	"header.len=%d\n"
			"header.reply=%d\n"
			"header.sequence=%d\n",
		h->len,
		h->reply,
		h->sequence);
}
#endif

JNIEXPORT jint JNICALL Java_isect_io_IsdIO_isdLogin
  (JNIEnv *env, jobject obj, jstring host, jstring service, jint priority)
{
	int socket;
	char *hostName, *serviceName;

	hostName =    (*env)->GetStringUTFChars(env, host, 0);
	serviceName = (*env)->GetStringUTFChars(env, service, 0);

	socket = isdLogin(hostName, serviceName, priority);

#ifdef ISDDEBUG
	isdLog("getpid() = %d\n", getpid());

	isdLog("isdLogin(%s, %s, %d) = %d\n", 
		hostName,
		serviceName,
		priority,
		socket);
#endif

	(*env)->ReleaseStringUTFChars(env, host, hostName);
	(*env)->ReleaseStringUTFChars(env, service, serviceName);

	return (jint) socket;
}

JNIEXPORT jint JNICALL Java_isect_io_IsdIO_isdLogout
  (JNIEnv *jEnv, jobject jObj, jint fd)
{
	isdLogout(fd);

#ifdef ISDDEBUG
	isdLog("getpid() = %d\n", getpid());
	isdLog("isdLogout(%d)\n", fd);
#endif
}

JNIEXPORT jint JNICALL Java_isect_io_IsdIO_isdSend
  (JNIEnv *env, jobject obj, jint fd, jbyteArray message, jint len, jbyteArray header)
{
	int retValue;
	jbyte *pMessage;
	jbyte *pHeader;
	isdHeader myHeader;

	pMessage = (*env)->GetByteArrayElements(env, message, 0);
	pHeader  = (*env)->GetByteArrayElements(env, header,  0);

	myHeader = *((isdHeader *) pHeader);
	isdHeaderToH(&myHeader);

	retValue = isdSend(fd, (char *) pMessage, len, &myHeader);

#ifdef ISDDEBUG
	isdLog("getpid() = %d\n", getpid());
	dumpIsdHeader(&myHeader);
	isdLog("isdSend(%d, %p, %d, %p) = %d\n",
		fd,
		pMessage,
		len,
		&myHeader,
		retValue);
#endif
	(*env)->ReleaseByteArrayElements(env, message, pMessage, 0);
	(*env)->ReleaseByteArrayElements(env, header,  pHeader,  0);

	return (jint) retValue;
}

JNIEXPORT jint JNICALL Java_isect_io_IsdIO_isdRecvBuffer
  (JNIEnv *env, jobject jobj, jint fd, jbyteArray header, jbyteArray message, 
  jint messageLength)
{
	int retValue;
	jbyte *pMessage;
	jbyte *pHeader;
	isdHeader myHeader;

	pMessage = (*env)->GetByteArrayElements(env, message, 0);
	pHeader  = (*env)->GetByteArrayElements(env, header,  0);

	retValue = isdRecvBuffer(fd, &myHeader, (char *) pMessage, messageLength);

#ifdef ISDDEBUG
	isdLog("getpid() = %d\n", getpid());

	isdLog("isdRecvBuffer(%d, %p, %p, %d) = %d\n",
		fd,
		&myHeader,
		pMessage,
		messageLength, 
		retValue);
#endif

	isdHeaderToN(&myHeader);
	*((isdHeader *) pHeader) = myHeader;

	(*env)->ReleaseByteArrayElements(env, message, pMessage, 0);
	(*env)->ReleaseByteArrayElements(env, header,  pHeader,  0);

	return (jint) retValue;
}

JNIEXPORT jint JNICALL Java_isect_io_IsdIO_isdRecvHeader
  (JNIEnv *env, jobject obj, jint fd, jbyteArray header)
{
	int retValue;
	jbyte *pHeader;
	isdHeader myHeader;

	pHeader  = (*env)->GetByteArrayElements(env, header,  0);

	retValue = isdRecvHeader(fd, &myHeader);

#ifdef ISDDEBUG
	isdLog("isdRecvHeader(%d, %p) = %d\n", fd, &myHeader, retValue);
	dumpIsdHeader(&myHeader);
#endif

	isdHeaderToN(&myHeader);
	*((isdHeader *) pHeader) = myHeader;

	(*env)->ReleaseByteArrayElements(env, header,  pHeader,  0);

	return (jint) retValue;
}

JNIEXPORT jint JNICALL Java_isect_io_IsdIO_isdRecvAll
  (JNIEnv *env, jobject obj, jint fd, jbyteArray buffer, jint bufferLen)
{
	jint retValue;
	jbyte *pBuffer;

	pBuffer  = (*env)->GetByteArrayElements(env, buffer,  0);

#ifdef ISDDEBUG
	isdLog("isdRecvAll(%d, %p, %d)\n", fd, pBuffer, bufferLen);
#endif

	retValue = isdRecvAll(fd, pBuffer, bufferLen);

#ifdef ISDDEBUG
	isdLog("isdRecvAll(%d, %p, %d) = %d\n", fd, pBuffer, bufferLen, retValue);
#endif

	(*env)->ReleaseByteArrayElements(env, buffer,  pBuffer,  0);

	return retValue;
}

JNIEXPORT jint JNICALL Java_isect_io_IsdIO_isdAttach
  (JNIEnv *env, jobject obj, jstring host, jstring service, jstring worker, jint priority)
{
	int socket;
	char *hostName, *serviceName, *workerID;

	hostName =    (*env)->GetStringUTFChars(env, host, 0);
	serviceName = (*env)->GetStringUTFChars(env, service, 0);
	workerID =    (*env)->GetStringUTFChars(env, worker, 0);

	socket = isdAttach(hostName, serviceName, workerID, priority);

#ifdef ISDDEBUG
	isdLog("getpid() = %d\n", getpid());

	isdLog("isdAttach(%s, %s, %s, %d) = %d\n", 
		hostName,
		serviceName,
		workerID,
		priority,
		socket);
#endif

	(*env)->ReleaseStringUTFChars(env, host, hostName);
	(*env)->ReleaseStringUTFChars(env, service, serviceName);
	(*env)->ReleaseStringUTFChars(env, worker, workerID);

	return (jint) socket;
}

#endif
