#include <sys/time.h>
#include <sys/resource.h>
#include <errno.h>

char *
rmtrenice(char *buffer)
{
	int pid, newpriority, oldpriority;
	static char reply[64];

	errno = 0;
	if (sscanf(buffer, "%*s %d %d", &newpriority, &pid) == 2) {
		oldpriority = getpriority(PRIO_PROCESS, pid);
		if (errno == 0) {
			if ((setpriority(PRIO_PROCESS, pid, newpriority)) == 0)
				sprintf(buffer, "%d: old priority %d, new priority %d", pid, oldpriority, newpriority);
			else
				sprintf(buffer, "renice: %d: setpriority: %s", pid, strerror(errno));
		}
		else
			sprintf(buffer, "renice: %d: getpriority: %s", pid, strerror(errno));
	}
	return buffer;
}
