/* 
 * $Id: irr_attrs.c,v 1.14 2001/11/14 17:58:24 ljb Exp $
 */


/*
 * This file has the data structures used by Bison for
 * checking legal, multiple, and mandatory attributes.
 * It also has the long attribute field names array,
 * the object type names array, and the error message
 * buffer.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <irr_rpsl_check.h>

/* Error and warning messages go here */
char error_buf[MAX_ERROR_BUF_SIZE];
/* string lex tokens go here */
int int_size;
FILE *ofile = NULL;
char *flushfntmpl =  "/var/tmp/irrcheck.XXXXXX";

char *too_many_errors = "Too many errors, turning off error messages!\n";
int too_many_size;
/* canonicalized strings go here */
char parse_buf[MAX_CANON_BUF_SIZE];
canon_line_t lineptr[CANON_LINES_MAX]; /* has info about each line in parse buf */
canon_info_t canon_obj; /* global info about objects that are being canonicalized */
/* This is the default value for canonicalization of objects.
 * Use '-c' command flag to turn on canonicalization.
 * Use '-q' to turn on quick check; no object output, report first error and stop
 * Use '-h' to turn on info headers which are used in pipeline fashion
 *          as input to other routines (ie, IRRd object processing)
 */
int CANONICALIZE_OBJS_FLAG = 0;
int QUICK_CHECK_FLAG       = 0;
int INFO_HEADERS_FLAG      = 0;
canon_info_t canon_obj;

const char ERROR_TOKEN[] = "<?>";

/* array of regular expressions */
regex_t re[MAX_ATTRS + REGEX_TOKEN_COUNT];

/* data structs from perl program */

/*--------Bison legal attr------*/
short legal_attrs[MAX_OBJS][MAX_ATTRS] = {
{ 16, 3, 11, 12, 15, 14, 0, 13, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 1, 2, 5, 6, 7, 8, 9, 10, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 20, 21,},
{ 10, 2, 5, 6, 9, 8, 0, 7, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 4, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 14, 15,},
{ 11, 2, 3, 4, 10, 9, 0, 8, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 15, 16,},
{ 16, 2, 11, 12, 15, 14, 3, 13, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 6, 5, 10, 7, 8, 9,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 20, 21,},
{ 16, 2, 11, 12, 15, 14, 3, 13, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 6, 5, 10, 7, 8, 9,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 20, 21,},
{ 11, 5, 6, 7, 10, 9, 0, 8, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 4, 0, 0, 1, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 15, 16,},
{ 17, 2, 12, 13, 16, 15, 0, 14, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 4, 5, 7, 9, 8, 6, 10, 11,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 21, 22,},
{ 11, 2, 6, 7, 10, 9, 0, 8, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 5, 0, 0, 0, 0, 0, 1, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 15, 16,},
{ 10, 0, 0, 0, 9, 8, 0, 7, 11, 3, 4, 5, 6, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 14, 15,},
{ 13, 0, 7, 8, 12, 11, 0, 10, 14, 4, 5, 6, 9, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 17, 18,},
{ 10, 2, 5, 6, 9, 8, 0, 7, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 4, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 14, 15,},
{ 10, 2, 5, 6, 9, 8, 0, 7, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 14, 15,},
{ 9, 0, 0, 0, 8, 7, 0, 6, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 1, 2, 3, 4, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 13, 14,},
{ 12, 2, 3, 4, 11, 10, 0, 9, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 1, 5, 6, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 16, 17,},
{ 15, 9, 10, 11, 14, 13, 0, 12, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 19, 20,},
{ 12, 3, 5, 6, 11, 10, 0, 9, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 4, 7, 8,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 16, 17,},
{ 12, 3, 5, 6, 11, 10, 0, 9, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 7, 8,
 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 16, 17,},
{ 8, 2, 3, 4, 7, 6, 0, 5, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 12, 13,},
{ 13, 2, 3, 4, 12, 11, 0, 10, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 1024, 17, 18,},
{ 9, 2, 4, 0, 8, 7, 0, 6, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 5, 1024, 1024, 13, 14,},
{ 14, 3, 0, 0, 13, 12, 2, 11, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 1, 4, 6, 7, 8, 9, 10, 0, 0, 0, 1024, 1024, 18, 19,},
};

/*--------Bison multiple_attrs------*/
short mult_attrs[MAX_OBJS][MAX_ATTRS] = {
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,},
{ 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,},
{ 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0,},
};

/*--------attr_hash------*/
char *attr_hash[MAX_OBJS][MAX_ATSQ_LEN] = {
{"aut-num", "as-name", "descr", "member-of", "import", "mp-import", "export", "mp-export", "default", "mp-default", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"as-set", "descr", "members", "mbrs-by-ref", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"mntner", "descr", "admin-c", "tech-c", "upd-to", "mnt-nfy", "auth", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"route", "descr", "origin", "holes", "member-of", "inject", "aggr-bndry", "aggr-mtd", "export-comps", "components", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"route6", "descr", "origin", "holes", "member-of", "inject", "aggr-bndry", "aggr-mtd", "export-comps", "components", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"route-set", "members", "mp-members", "mbrs-by-ref", "descr", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"inet-rtr", "descr", "alias", "local-as", "ifaddr", "interface", "peer", "mp-peer", "member-of", "rs-in", "rs-out", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"rtr-set", "descr", "members", "mp-members", "mbrs-by-ref", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"person", "address", "phone", "fax-no", "e-mail", "nic-hdl", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"role", "trouble", "address", "phone", "fax-no", "e-mail", "admin-c", "tech-c", "nic-hdl", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"filter-set", "descr", "filter", "mp-filter", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"peering-set", "descr", "peering", "mp-peering", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"key-cert", "method", "owner", "fingerpr", "certif", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"dictionary", "descr", "admin-c", "tech-c", "typedef", "rp-attribute", "protocol", "afi", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"repository", "query-address", "response-auth-type", "submit-address", "submit-auth-type", "repository-cert", "expire", "heartbeat-interval", "descr", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"inetnum", "netname", "descr", "country", "admin-c", "tech-c", "rev-srv", "status", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"inet6num", "netname", "descr", "country", "admin-c", "tech-c", "rev-srv", "status", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"as-block", "descr", "admin-c", "tech-c", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"domain", "descr", "admin-c", "tech-c", "zone-c", "nserver", "sub-dom", "dom-net", "refer", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"limerick", "descr", "text", "admin-c", "author", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
{"ipv6-site", "origin", "descr", "location", "country", "prefix", "application", "tunnel", "contact", "url", "remarks", "notify", "mnt-by", "changed", "source", "delete", "override", "password", "cookie", ""},
};


/*--------attr_map_field------*/
short attr_map_field[MAX_OBJS][MAX_ATSQ_LEN] = {
{ 60, 61, 1, 68, 62, 63, 64, 65, 66, 67, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 81, 1, 82, 80, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 99, 1, 2, 3, 100, 101, 102, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 51, 1, 6, 53, 55, 54, 57, 58, 59, 56, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 52, 1, 6, 53, 55, 54, 57, 58, 59, 56, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 83, 84, 85, 80, 1, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 70, 1, 71, 72, 73, 77, 74, 76, 75, 78, 79, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 86, 1, 87, 88, 80, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 95, 96, 9, 10, 11, 12, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 97, 98, 96, 9, 10, 11, 2, 3, 12, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 92, 1, 93, 94, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 89, 1, 90, 91, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 41, 42, 43, 44, 45, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 46, 1, 2, 3, 47, 48, 49, 50, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 21, 22, 23, 24, 25, 26, 27, 28, 1, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 35, 36, 1, 37, 2, 3, 38, 39, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 40, 36, 1, 37, 2, 3, 38, 39, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 69, 1, 2, 3, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 29, 1, 2, 3, 30, 31, 32, 33, 34, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 110, 1, 111, 2, 112, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
{ 103, 6, 1, 104, 37, 105, 106, 107, 108, 109, 7, 5, 4, 0, 8, 113, 114, 115, 116, -1},
};

/*--------Bison mandatory's------*/
short mand_attrs[MAX_OBJS][MAX_MANDS] = {
{ 60, 61, 1, 2, 3, 4, 0, 8, -1},
{ 81, 1, 4, 0, 8, -1},
{ 99, 1, 2, 100, 102, 4, 0, 8, -1},
{ 51, 1, 6, 4, 0, 8, -1},
{ 52, 1, 6, 4, 0, 8, -1},
{ 83, 1, 4, 0, 8, -1},
{ 70, 72, 4, 0, 8, -1},
{ 86, 1, 4, 0, 8, -1},
{ 95, 96, 9, 11, 12, 4, 0, 8, -1},
{ 97, 96, 9, 11, 12, 4, 0, 8, -1},
{ 92, 93, 1, 4, 0, 8, -1},
{ 89, 1, 4, 0, 8, -1},
{ 41, 45, 4, 0, 8, -1},
{ 46, 1, 4, 0, 8, -1},
{ 21, 22, 23, 24, 25, 26, 27, 28, 2, 3, 4, 0, 8, -1},
{ 35, 36, 1, 39, 37, 2, 3, 4, 0, 8, -1},
{ 40, 36, 1, 37, 2, 3, 39, 4, 0, 8, -1},
{ 69, 1, 2, 3, 4, 0, 8, -1},
{ 29, 1, 2, 3, 30, 0, 8, -1},
{ 110, 111, 2, 112, 4, 0, 8, -1},
{ 103, 6, 1, 108, 4, 0, 8, -1},
};

/*--------attrs which are keys-----------*/
short attr_is_key[MAX_ATTRS] = {
-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
-1, -1, -1, -1, -1, -1, 14, -1, -1, -1, -1, -1, -1, -1, 18,
-1, -1, -1, -1, -1, 15, -1, -1, -1, -1, 16, 12, -1, -1, -1,
-1, 13, -1, -1, -1, -1, 3, 4, -1, -1, -1, -1, -1, -1, -1,
0, -1, -1, -1, -1, -1, -1, -1, -1, 17, 6, -1, -1, -1, -1,
-1, -1, -1, -1, -1, -1, 1, -1, 5, -1, -1, 7, -1, -1, 11,
-1, -1, 10, -1, -1, 8, -1, 9, -1, 2, -1, -1, -1, 20, -1,
-1, -1, -1, -1, -1, 19, -1, -1, -1, -1, -1, -1
};

/*-------long attributes char array------*/
char *attr_name[MAX_ATTRS] = {
    "changed", "descr", "admin-c", "tech-c", "mnt-by",
    "notify", "origin", "remarks", "source", "phone",
    "fax-no", "e-mail", "nic-hdl", "delegated", "integrity",
    "mnt-lower", "mnt-routes", "reclaim", "no-reclaim", "referral-by",
    "auth-override", "repository", "query-address", "response-auth-type", "submit-address",
    "submit-auth-type", "repository-cert", "expire", "heartbeat-interval", "domain",
    "zone-c", "nserver", "sub-dom", "dom-net", "refer",
    "inetnum", "netname", "country", "rev-srv", "status",
    "inet6num", "key-cert", "method", "owner", "fingerpr",
    "certif", "dictionary", "typedef", "rp-attribute", "protocol",
    "afi", "route", "route6", "holes", "inject",
    "member-of", "components", "aggr-bndry", "aggr-mtd", "export-comps",
    "aut-num", "as-name", "import", "mp-import", "export",
    "mp-export", "default", "mp-default", "member-of", "as-block",
    "inet-rtr", "alias", "local-as", "ifaddr", "peer",
    "member-of", "mp-peer", "interface", "rs-in", "rs-out",
    "mbrs-by-ref", "as-set", "members", "route-set", "members",
    "mp-members", "rtr-set", "members", "mp-members", "peering-set",
    "peering", "mp-peering", "filter-set", "filter", "mp-filter",
    "person", "address", "role", "trouble", "mntner",
    "upd-to", "mnt-nfy", "auth", "ipv6-site", "location",
    "prefix", "application", "tunnel", "contact", "url",
    "limerick", "text", "author", "delete", "override",
    "password", "cookie"
};

/*-------object types char array------*/
char *obj_type[MAX_OBJS] = {
    "aut-num", "as-set", "mntner", "route", "route6",
    "route-set", "inet-rtr", "rtr-set", "person", "role",
    "filter-set", "peering-set", "key-cert", "dictionary", "repository",
    "inetnum", "inet6num", "as-block", "domain", "limerick",
    "ipv6-site"
};

/* -------Countries char array------ */
#define MAX_COUNTRIES 241
char *countries[MAX_COUNTRIES] = {
    "AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ",
    "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE",
    "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS",
    "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG",
    "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV",
    "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC",
    "EE", "EG", "EH", "ER", "ES", "ET", "EU", "FI", "FJ", "FK",
    "FM", "FO", "FR", "FX", "GA", "GB", "GD", "GE", "GF", "GH",
    "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU",
    "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE",
    "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP",
    "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY",
    "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU",
    "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM",
    "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW",
    "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL",
    "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG",
    "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY",
    "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE",
    "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR",
    "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ",
    "TK", "TM", "TN", "TO", "TP", "TR", "TT", "TV", "TW", "TZ",
    "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG",
    "VI", "VN", "VU", "WF", "WS", "YE", "YT", "YU", "ZA", "ZM",
    "ZW"
};

char RPSL_dictionary[] =
"dictionary: RPSL\nrp-attribute: pref operator=(integer[0, 65535])\nrp-attribute: med operator=(union integer[0, 65535], enum[igp_cost])\nrp-attribute: dpa operator=(integer[0, 65535])\nrp-attribute: aspath prepend(as_number, ...)\ntypedef: community_elm union integer[1, 4294967295], enum[internet, no_export, no_advertise]\ntypedef: community_list list of community_elm\nrp-attribute: community operator=(community_list) operator.=(community_list) append(community_elm, ...) delete(community_elm, ...) contains(community_elm, ...) operator()(community_elm, ...) operator==(community_list)\nrp-attribute: next-hop operator=(union ipv4_address, ipv6_address, enum[self])\nrp-attribute: cost operator=(integer[0, 65535])\nprotocol: BGP4\n MANDATORY asno(as_number) OPTIONAL flap_damp() OPTIONAL flap_damp(integer[0,65535],integer[0,65535],integer[0,65535],integer[0,65535],integer[0,65535],integer[0,65535])\nprotocol: MPBGP\n MANDATORY asno(as_number) OPTIONAL flap_damp() OPTIONAL flap_damp(integer[0,65535],integer[0,65535],integer[0,65535],integer[0,65535],integer[0,65535],integer[0,65535])\nprotocol: OSPF\nprotocol: RIP\nprotocol: IGRP\nprotocol: IS-IS\nprotocol: STATIC\nprotocol: RIPng\nprotocol: DVMRP\nprotocol: PIM-DM\nprotocol: PIM-SM\nprotocol: CBT\nprotocol: MOSPF\nafi: ipv4\nafi: ipv4.unicast\nafi: ipv4.multicast\nafi: ipv6\nafi: ipv6.unicast\nafi: ipv6.multicast\nafi: any\nafi: any.unicast\nafi: any.multicast\ndescr: Initial RPSL Dictionary\ntech-c: IRRD-US\nchanged: ljb@merit.edu 20061103\nsource: RADB\n\n";


