/* Internal mail system declarations.
 *
 * IRC Services is copyright (c) 1996-2009 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#ifndef MAIL_LOCAL_H
#define MAIL_LOCAL_H

/*************************************************************************/

/* Pointer to low-level send routine.  Low-level modules should set this
 * to point to their own send routine.  This routine should send mail as
 * indicated (`fromname' may be NULL, but no other parameters will be) and
 * return a value suitable for sendmail()'s return value.
 */
extern int (*low_send)(const char *from, const char *fromname, const char *to,
		       const char *subject, const char *body);

/*************************************************************************/

#endif	/* MAIL_H */
