# Emacs: -*- mode: fundamental; coding: binary; -*-

# Dutch language file.
#
# IRC Services is copyright (c) 1996-2009 Andrew Church.
#     E-mail: <achurch@achurch.org>
# Parts written by Andrew Kempe and others.
# This program is free but copyrighted software; see the file COPYING for
# details.

# When translating this file to another language, keep in mind that the
# order of parameters for sprintf() is fixed in the source code, so your
# messages need to take the same parameters in the same order as the
# English messages do.  (Obviously, this doesn't hold for the strftime()
# format lines immediately below.)  If you can't get a natural translation
# of a message without changing the order of the parameters, please inform
# the Services developers.
#
# In help messages, "%S" (capital S, not lowercase) refers to the name of
# the service sending the message; for example, in NickServ help messages,
# "%S" is replaced by "NickServ" (or whatever it is renamed to in
# config.h).  The %S's do not count as sprintf() parameters, so they can be
# rearranged, removed, or added as necessary.
#
# Also in help messages, please try to limit line lengths to 60 characters
# of text (not including the leading tab).  This length was chosen because
# it does not cause line wrap under default settings on most current IRC
# clients.  Remember that format characters (control-B, control-_) are not
# included in that 60-character limit (since they don't show on the user's
# screen).  Also remember that format specifiers (%S, etc.) will expand
# when displayed, so remember to take this into account; you can assume
# that the length of a pseudoclient name (%S replacement) will be eight
# characters, so reduce the maximum line length by 6 for every %S on a
# line.
#
# Finally, remember to put a tab at the beginning of every line of text
# (including empty lines).  This has to be a tab, not spaces.

###########################################################################
#
# Name of this language
#
###########################################################################

# For languages other than English, this string should have the following
# format:
#     language-name-in-language (language-name-in-English)
# For example, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Nederlands (Dutch)

###################################################
# Translated by Martin Pels (rodecker@mp3crew.nu) #
# Tested by Mp3CreW (www.mp3crew.nu)              #
###################################################

###########################################################################
#
# General messages
#
###########################################################################

# strftime() format strings.  man 3 strftime for information on the
# meanings of the format specifiers.  Short version:
#	%a = weekday name (short)	%H = hour
#	%b = month name (short)		%M = minute
#	%d = day of month		%S = second
#	%Y = year			%Z = time zone

# This is used as the format string for strftime() for a date and time
# together.
STRFTIME_DATE_TIME_FORMAT
	%b %d %H:%M:%S %Y %Z
# This is used as the format string for strftime() for a date alone in long
# format (English: including weekday).
STRFTIME_LONG_DATE_FORMAT
	%a %b %d %Y
# This is used as the format string for strftime() for a date alone in
# short format (English: without weekday).
STRFTIME_SHORT_DATE_FORMAT
	%b %d %Y

# These tell our strftime() what the names of months and days are.  If you
# don't use %a, %A, %b, or %B in your strftime() strings above, you can
# leave these empty.  However, if you enter names, they MUST stay in order,
# one per line, and the list MUST be complete!

# %a
STRFTIME_DAYS_SHORT
	Zo
	Ma
	Di
	Wo
	Do
	Vr
	Za
# %A
STRFTIME_DAYS_LONG
	Zondag
	Maandag
	Dinsdag
	Woensdag
	Donderdag
	Vrijdag
	Zaterdag
# %b
STRFTIME_MONTHS_SHORT
	Jan
	Feb
	Mrt
	Apr
	Mei
	Jun
	Jul
	Aug
	Sep
	Okt
	Nov
	Dec
# %B
STRFTIME_MONTHS_LONG
	Januari
	Februari
	Maart
	April
	Mei
	Juni
	Juli
	Augustus
	September
	Oktober
	November
	December


# "day", "hour", "minute", and "second" in singular and plural.
STR_DAY
	 dag
STR_DAYS
	 dagen
STR_HOUR
	 uur
STR_HOURS
	 uren
STR_MINUTE
	 minuut
STR_MINUTES
	 minuten
STR_SECOND
	 seconde
STR_SECONDS
	 seconden
# Separator used between units of time; in English, a comma followed by a
# space (the ", " in "3 hours, 10 minutes").
STR_TIMESEP
	, 


# This is used in ChanServ/NickServ INFO displays, and is a comma followed
# by a space (", " -- trailing space is significant), or the equivalent in
# the language's character set.
COMMA_SPACE
	, 


# Various error messages.
INTERNAL_ERROR
	Interne Fout - Opdracht kan niet worden uitgevoerd.
SERVICES_IS_BUSY
	Services is momenteel druk; probeer het later nog eens.

UNKNOWN_COMMAND
	Onbekend commando %s.
UNKNOWN_COMMAND_HELP
	Onbekend commando %s.  Typ /msg %s HELP voor hulp.
SYNTAX_ERROR
	Syntax: %s
MORE_INFO
	Typ /msg %s HELP %s voor meer informatie.
NO_HELP_AVAILABLE
	Geen hulp beschikbaar voor %s.
MISSING_QUOTE
	Dubbele aanhalingstekens (") ontbreken.

BAD_EMAIL
	E-mail adres dient gegeven te worden in de vorm gebruikersnaam@hostnaam.  Kleur, vetgedrukte, onderstreepte, omgekeerde tekst of n van deze karakters: , : ; | \ " ( ) < > kunnen niet gebruikt worden.
BAD_URL
	Pagina's dienen in de volgende vorm gegeven te worden:
	http://hostnaam[:poort]/... (of ftp://, enz.).
BAD_USERHOST_MASK
	Masker dient gegeven te worden in de vorm gebruiker@host.
BAD_NICKUSERHOST_MASK
	Masker dient gegeven te worden in de vorm bijnaam!gebruiker@host.
BAD_EXPIRY_TIME
	Ongeldige vervaltijd.

SENDMAIL_NO_RESOURCES
	Het systeem is momenteel te druk om e-mail te versturen; probeer het later nog eens.
READ_ONLY_MODE
	Opmerking: Services staan in alleen-lezen modus. Veranderingen worden niet opgeslagen!
PASSWORD_INCORRECT
	Wachtwoord onjuist.
PASSWORD_WARNING
	Waarschuwing: Na een volgend fout wachtwoord wordt u van de server verwijderd.

# What's the difference between "Access denied" and "Permission denied"?
# Very little; you can safely make them the same message with no real loss
# of meaning.  If you want to make a distinction, "Access denied" is
# usually used more generally; for example, a non-oper trying to access
# OperServ gets "Access denied", while a non-Services admin trying to use
# NickServ SET NOEXPIRE gets "Permission denied".
ACCESS_DENIED
	Geen toegang.
PERMISSION_DENIED
	Geen permissie.

MORE_OBSCURE_PASSWORD
	Probeer het nogmaals met een ingewikkelder wachtwoord. Wachtwoorden dienen minimaal 5 karakters te zijn en moeten niet makkelijk te raden zijn (b.v. naam of bijnaam).
PASSWORD_TRUNCATED
	Opmerking:  Uw wachtwoord is verkleind tot %d karakters.

NICK_NOT_REGISTERED
	Uw bijnaam is niet geregistreerd.
NICK_NOT_REGISTERED_HELP
	Uw bijnaam is niet geregistreerd.  Typ /msg %s HELP voor informatie over het registreren van bijnamen.
NICK_TOO_LONG
	Bijnamen mogen niet langer dan %d karakters zijn.
NICK_INVALID
	%s is geen geldige bijnaam.
NICK_X_NOT_REGISTERED
	Bijnaam %s is niet geregistreerd.
NICK_X_ALREADY_REGISTERED
	Bijnaam %s is al geregistreerd!
NICK_X_NOT_IN_USE
	Bijnaam %s is momenteel niet in gebruik.
NICK_X_FORBIDDEN
	Bijnaam %s mag niet geregistreerd of gebruikt worden.
NICK_X_SUSPENDED
	Bijnaam %s is buiten werking en mag niet gebruikt of geidentificeerd worden.
NICK_X_SUSPENDED_MEMOS
	Bijnaam %s is buiten werking en mag geen memo's ontvangen.
NICK_IDENTIFY_REQUIRED
	Wachtwoord verificatie vereist voor dit commando. Probeer het nogmaals na het typen van /msg %s IDENTIFY wachtwoord.
NICK_PLEASE_AUTH
	Uw bijnaam is nog niet geauthenticeerd.  Authenticeer uw bijnaam d.m.v. de authenticatie-code in de E-mail gestuurd naar : %s

NICK_X_NOT_ON_CHAN_X
	Bijnaam %s is momenteel niet in kamer %s.

CHAN_INVALID
	%s is geen geldige kamer.
CHAN_X_NOT_REGISTERED
	Kamer %s is niet geregistreerd.
CHAN_X_NOT_IN_USE
	Kamer %s is momenteel niet in gebruik.
CHAN_X_FORBIDDEN
	Kamer %s mag niet geregistreerd of gebruikt worden.
CHAN_X_SUSPENDED
	Kamer %s is buiten werking en mag niet gebruikt of geidentificeerd worden.
CHAN_X_SUSPENDED_MEMOS
	Kamer %s is buiten gebruik en mag geen memo's ontvangen.
CHAN_IDENTIFY_REQUIRED
	Wachtwoord verificatie vereist voor dit commando. Probeer het nogmaals na het typen van /msg %s IDENTIFY %s wachtwoord.

SERV_X_NOT_FOUND
	Server %s niet gevonden.

EXPIRES_NONE
	vervalt niet
EXPIRES_SOON
	vervalt na volgende database update
EXPIRES_IN
	vervalt over %s

###########################################################################
#
# NickServ messages
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Deze bijnaam is van iemand anders. Kies een andere. (Als dit uw bijnaam is, typ /msg %s IDENTIFY wachtwoord.)
NICK_IS_SECURE
	Deze bijnaam is geregistreerd en beschermd. typ /msg %s IDENTIFY wachtwoord. Als dit uw bijnaam is, anders dient u een andere bijnaam te kiezen.
NICK_MAY_NOT_BE_USED
	Deze bijnaam mag niet gebruikt worden. Kies een andere.
DISCONNECT_IN_1_MINUTE
	Als u uw bijnaam niet binnen n minuut verandert wordt uw verbinding verbroken.
DISCONNECT_IN_20_SECONDS
	Als u uw bijnaam niet binnen 20 seconden verandert wordt uw verbinding verbroken.
DISCONNECT_NOW
	Deze bijnaam is geregistreerd: U kunt deze niet gebruiken. Kies een andere bijnaam voordat u opnieuw verbinding maakt.
FORCENICKCHANGE_IN_1_MINUTE
	Als u uw bijnaam niet binnen n minuut verandert zal deze automatisch gewijzigd worden.
FORCENICKCHANGE_IN_20_SECONDS
	Als u uw bijnaam niet binnen 20 seconden verandert zal deze automatisch gewijzigd worden.
FORCENICKCHANGE_NOW
	Deze bijnaam is geregistreerd: U kunt deze niet gebruiken. Uw bijnaam wordt nu veranderd naar %s.
NICK_EXPIRES_SOON
	Opmerking: De registratie van uw bijnaam vervalt over %s.  Als u de bijnaam %s wil blijven gebruiken, identificeer dan d.m.v.: /msg %s IDENTIFY wachtwoord
NICK_EXPIRED
	Opmerking: De registratie van uw bijnaam is vervallen. Registreer uw bijnaam opnieuw als u deze wilt blijven gebruiken.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER wachtwoord [E-mail]
NICK_REGISTER_REQ_EMAIL_SYNTAX
	REGISTER wachtwoord E-mail
NICK_REGISTRATION_DISABLED
	Sorry, bijnaam registratie is tijdelijk uitgeschakeld.
NICK_REGISTRATION_FAILED
	Sorry, registratie mislukt.
NICK_REG_PLEASE_WAIT
	Wacht a.u.b. %s voordat u het REGISTER commando opnieuw gebruikt.
NICK_REG_PLEASE_WAIT_FIRST
	Wacht a.u.b. %s voordat u het REGISTER commando gebruikt.
NICK_CANNOT_BE_REGISTERED
	Bijnaam %s mag niet geregistreerd worden.
NICK_REGISTER_EMAIL_UNAUTHED
	Het gegeven E-mail adres is nog niet geauthenticeerd.  Gebruik het AUTH commando om het adres te authenticeren voordat u er nieuwe bijnamen mee registreerd.
NICK_REGISTER_TOO_MANY_NICKS
	U heeft teveel bijnamen geregistreerd (%d, maximum van %d).  U kunt geen nieuwe bijnamen registreren totdat u enkele van uw oude bijnamen verwijderd.
NICK_REGISTERED
	Bijnaam %s is geregistreerd voor u.
NICK_PASSWORD_IS
	Uw wachtwoord is %s - onthoud dit voor later gebruik.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY wachtwoord
NICK_IDENTIFY_FAILED
	Sorry, identificatie niet geslaagd.
NICK_IDENTIFY_EMAIL_MISSING
	U dient een E-mail adres in te stellen voor uw bijnaam voor u deze verder kunt gebruiken. Stel er nu een in met het commando: /msg %s SET EMAIL adres
NICK_IDENTIFY_SUCCEEDED
	Wachtwoord geaccepteerd - U bent nu herkend.

# DROP responses
NICK_DROP_SYNTAX
	DROP wachtwoord
NICK_DROP_WARNING
	Waarschuwing: Het DROP commando maakt registratie van al uw gelinkte bijnamen ongedaan!
NICK_DROP_DISABLED
	Sorry, bijnaam registratie ongedaan maken is tijdelijk uitgeschakeld.
NICK_DROP_FAILED
	Sorry, bijnaam registratie ongedaan maken niet geslaagd.
NICK_DROPPED
	Uw bijnaam registratie is geannuleerd.
NICK_DROPPED_LINKS
	Registratie van uw bijnaam en alle gekoppelde bijnamen is ongedaan gemaakt.

# DROPNICK responses
NICK_DROPNICK_SYNTAX
	DROPNICK bijnaam
NICK_X_DROPPED
	Registratie van bijnaam %s is geannuleerd.
NICK_X_DROPPED_LINKS
	Registratie van bijnaam %s en alle gekoppelde bijnamen is ongedaan gemaakt.

# DROPEMAIL and DROPEMAIL-CONFIRM responses
NICK_DROPEMAIL_SYNTAX
	DROPEMAIL patroon
NICK_DROPEMAIL_PATTERN_TOO_LONG
	Het gegeven patroon is te lang (maximaal %d karakters).
NICK_DROPEMAIL_NONE
	Er zijn geen bijnamen met E-mail adressen volgens het gegeven patroon.
NICK_DROPEMAIL_COUNT
	%d bijnamen hebben E-mail adressen volgens het gegeven patroon.
	Om deze bijnamen te verwijderen, typ: /msg %s DROPEMAIL-CONFIRM %s
NICK_DROPEMAIL_CONFIRM_SYNTAX
	DROPEMAIL-CONFIRM patroon
NICK_DROPEMAIL_CONFIRM_UNKNOWN
	Het gegeven patroon is niet herkend. Gebruik het DROPEMAIL commando opnieuw met dit patroon voordat u het DROPEMAIL-CONFIRM commando gebruikt.
NICK_DROPEMAIL_CONFIRM_DROPPING
	Bezig met verwijderen van %d bijnamen...
NICK_DROPEMAIL_CONFIRM_DROPPED
	Verwijderen van bijnamen voltooid.

# SET responses
NICK_SET_SYNTAX
	SET optie parameters
NICK_SET_OPER_SYNTAX
	SET [bijnaam] optie parameters
NICK_SET_DISABLED
	Sorry, veranderen van bijnaam opties is tijdelijk uitgeschakeld.
NICK_SET_UNKNOWN_OPTION
	Onbekende SET optie %s.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Onbekende SET optie %s, of bijnaam is niet geregistreerd.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Sorry, kon wachtwoord niet veranderen.
NICK_SET_PASSWORD_CHANGED
	Wachtwoord veranderd.
NICK_SET_PASSWORD_CHANGED_TO
	Wachtwoord veranderd naar %s.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE nummer
NICK_SET_LANGUAGE_UNKNOWN
	Onbekend taal-nummer %d.  Typ /msg %s HELP SET LANGUAGE voor een lijst van talen.
NICK_SET_LANGUAGE_CHANGED
	Taal veranderd naar %s.

# SET URL responses
NICK_SET_URL_CHANGED
	Pagina van %s veranderd naar %s.

# SET EMAIL responses
NICK_SET_EMAIL_UNAUTHED
	Het gegeven E-mail adres is nog niet geauthenticeerd.  Gebruik het AUTH commando om het adres te authenticeren.
NICK_SET_EMAIL_TOO_MANY_NICKS
	%s heeft al %d bijnamen geregistreerd (maximum is %d).  E-mail adres wijziging mislukt.
NICK_SET_EMAIL_CHANGED
	E-mail adres van %s veranderd naar %s.

# SET INFO responses
NICK_SET_INFO_CHANGED
	Informatie van %s veranderd.

# SET KILL responses
NICK_SET_KILL_SYNTAX
	SET KILL {ON | QUICK | OFF}
NICK_SET_KILL_IMMED_SYNTAX
	SET KILL {ON | QUICK | IMMED | OFF}
NICK_SET_KILL_ON
	Kill protectie staat nu ON (aan).
NICK_SET_KILL_QUICK
	Kill protectie staat nu ON (aan), met een kleinere
	kill-vertraging.
NICK_SET_KILL_IMMED
	Kill protectie staat nu ON (aan), zonder kill-vertraging.
NICK_SET_KILL_IMMED_DISABLED
	De IMMED optie is niet beschikbaar op dit netwerk.
NICK_SET_KILL_OFF
	Kill protectie staat nu OFF (uit).

# SET SECURE responses
NICK_SET_SECURE_SYNTAX
	SET SECURE {ON | OFF}
NICK_SET_SECURE_ON
	Beveiliging staat nu ON (aan).
NICK_SET_SECURE_OFF
	Beveiliging staat nu OFF (uit).

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	Priv optie staat nu ON (aan).
NICK_SET_PRIVATE_OFF
	Priv optie staat nu OFF (uit).

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	Uw E-mail adres wordt nu verborgen in %s INFO weergave.
NICK_SET_HIDE_EMAIL_OFF
	Uw E-mail adres wordt nu getoond in %s INFO weergave.
NICK_SET_HIDE_MASK_ON
	Uw laatst gebruikte gebruiker@host masker wordt nu verborgen in %s INFO weergave.
NICK_SET_HIDE_MASK_OFF
	Uw laatst gebruikte gebruiker@host masker wordt nu getoond in %s INFO weergave.
NICK_SET_HIDE_QUIT_ON
	Uw laatste vertrek-boodschap wordt nu verborgen in %s INFO weergave.
NICK_SET_HIDE_QUIT_OFF
	Uw laatste vertrek-boodschap wordt nu getoond in %s INFO weergave.


# SET TIMEZONE responses
NICK_SET_TIMEZONE_SYNTAX
	SET TIMEZONE {UTC-verschil | tijd-zone | DEFAULT}
NICK_SET_TIMEZONE_TO
	Uw tijdzone is veranderd naar UTC%c%d:%02d.
	De huidige tijd in deze tijdzone is %s.
NICK_SET_TIMEZONE_DEFAULT
	Uw tijdzone is teruggezet naar die van Services.

# SET MAINNICK responses
NICK_SET_MAINNICK_NOT_FOUND
	De bijnaam %s is niet gekoppeld aan uw bijnaam.
NICK_SET_MAINNICK_CHANGED
	Uw hoofd bijnaam is veranderd naar %s.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [bijnaam] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	Bijnaam %s zal niet vervallen.
NICK_SET_NOEXPIRE_OFF
	Bijnaam %s zal vervallen.

# UNSET responses
NICK_UNSET_SYNTAX
	UNSET {URL | EMAIL | INFO}
NICK_UNSET_SYNTAX_REQ_EMAIL
	UNSET {URL | INFO}
NICK_UNSET_URL
	Pagina van %s verwijderd.
NICK_UNSET_EMAIL
	E-mail adres van %s verwijderd.
NICK_UNSET_INFO
	Informatie van %s verwijderd.
NICK_UNSET_EMAIL_BAD
	U kunt uw E-mail adres niet verwijderen.
NICK_UNSET_EMAIL_OTHER_BAD
	Bijnaam E-mail adressen mogen niet verwijderd worden.

# ACCESS responses
NICK_ACCESS_SYNTAX
	ACCESS {ADD | DEL | LIST} [masker]
NICK_ACCESS_DISABLED
	Sorry, aanpassen van de bijnaam toegangslijst is tijdelijk uitgeschakeld.
NICK_ACCESS_ALREADY_PRESENT
	Masker %s staat al op uw toeganglijst.
NICK_ACCESS_REACHED_LIMIT
	Sorry, het maximum aantal toegangen voor een bijnaam is %d.
NICK_ACCESS_NO_NICKS
	Waarschuwing: Bijnaam toegangsmaskers mogen geen bijnamen bevatten.  Controleer of u het gebruiker@host masker juist heeft ingevoerd.
NICK_ACCESS_ADDED
	%s is toegevoegd aan uw toegangslijst.
NICK_ACCESS_NOT_FOUND
	%s niet gevonden op uw toegangslijst.
NICK_ACCESS_DELETED
	%s verwijderd van uw toegangslijst.
NICK_ACCESS_LIST_EMPTY
	Uw toegangslijst is leeg.
NICK_ACCESS_LIST
	Toegangslijst:
NICK_ACCESS_LIST_X_EMPTY
	Toegangslijst van %s is leeg.
NICK_ACCESS_LIST_X
	Toegangslijst van %s:

# LINK responses
NICK_OLD_LINK_SYNTAX
	LINK bijnaam wachtwoord
NICK_LINK_SYNTAX
	LINK bijnaam
NICK_LINK_DISABLED
	Sorry, koppelen van bijnamen is tijdelijk uitgeschakeld.
NICK_LINK_FAILED
	Sorry, koppelen niet geslaagd.
NICK_CANNOT_BE_LINKED
	Bijnaam %s mag niet worden gekoppeld.
NICK_OLD_LINK_SAME
	U kunt niet koppelen met uw huidige bijnaam!
NICK_LINK_SAME
	U kunt niet aan uw huidige bijnaam koppelen!
NICK_LINK_ALREADY_LINKED
	Bijnaam %s is reeds gekoppeld aan uw bijnaam.
NICK_LINK_IN_USE
	Bijnaam %s is momenteel in gebruik.
NICK_LINK_TOO_MANY
	U kunt niet meer dan %d bijnamen aan elkaar koppelen.
NICK_LINK_TOO_MANY_NICKS
	U heeft reeds %d bijnamen geregistreerd (maximum is %d).  Linken mislukt.
NICK_OLD_LINK_TOO_MANY_CHANNELS
	Kan niet koppelen aan bijnaam %s: teveel kamers geregistreerd (gecombineerd maximum %d).
NICK_OLD_LINKED
	Uw bijnaam is gekoppeld aan %s.
NICK_LINKED
	Bijnaam %s is gekoppeld aan uw bijnaam.

# UNLINK responses
NICK_OLD_UNLINK_SYNTAX
	UNLINK [bijnaam wachtwoord]
NICK_UNLINK_SYNTAX
	UNLINK bijnaam
NICK_UNLINK_OPER_SYNTAX
	UNLINK bijnaam [FORCE]
NICK_UNLINK_DISABLED
	Sorry, ongedaan maken van koppelingen tussen bijnamen is tijdelijk uitgeschakeld.
NICK_UNLINK_FAILED
	Sorry, koppeling ongedaan maken niet geslaagd.
NICK_UNLINK_SAME
	U kunt de koppeling met uw huidige bijnaam ongedaan maken!
NICK_OLD_UNLINK_NOT_LINKED
	Uw bijnaam is niet gelinkt.
NICK_UNLINK_NOT_LINKED_YOURS
	Bijnaam %s is niet gelinkt aan uw bijnaam.
NICK_UNLINK_NOT_LINKED
	Bijnaam %s is niet gelinkt.
NICK_OLD_UNLINKED
	De koppeling van uw bijnaam met %s is ongedaan gemaakt.
NICK_UNLINKED
	Koppeling van bijnaam %s aan uw bijnaam is ongedaan gemaakt.
NICK_X_UNLINKED
	Bijnaam %s is niet meer gekoppeld aan %s.

# LISTLINKS responses
NICK_OLD_LISTLINKS_SYNTAX
	LISTLINKS bijnaam
NICK_LISTLINKS_SYNTAX
	LISTLINKS
NICK_LISTLINKS_HEADER
	Lijst van bijnamen gekoppeld aan %s:
NICK_LISTLINKS_FOOTER
	%d gekoppelde bijnamen.

# INFO responses
NICK_INFO_SYNTAX
	INFO bijnaam [ALL]
NICK_INFO_REALNAME
	%s is %s
NICK_INFO_ADDRESS
	Laatst geziene adres: %s
NICK_INFO_ADDRESS_ONLINE
	Aanwezig vanaf: %s
NICK_INFO_ADDRESS_ONLINE_NOHOST
	%s is momenteel aanwezig.
NICK_INFO_TIME_REGGED
	Tijd geregistreerd: %s
NICK_INFO_LAST_SEEN
	Laatst gezien: %s
NICK_INFO_LAST_QUIT
	Laatste vertrek-boodschap: %s
NICK_INFO_URL
	Pagina: %s
NICK_INFO_EMAIL
	E-mail adres: %s
NICK_INFO_EMAIL_UNAUTHED
	E-mail adres: %s (niet geverifieerd)
NICK_INFO_INFO
	Informatie: %s
NICK_INFO_OPTIONS
	Opties: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Kill protectie
NICK_INFO_OPT_SECURE
	Beveiliging
NICK_INFO_OPT_PRIVATE
	Priv
NICK_INFO_OPT_NONE
	Geen
NICK_INFO_NO_EXPIRE
	Deze bijnaam zal niet vervallen.
NICK_INFO_SUSPEND_DETAILS
	Buiten werking gesteld door %s op %s (%s).
NICK_INFO_SUSPEND_REASON
	Rede: %s
NICK_INFO_SHOW_ALL
	Voor meer informatie, typ: /msg %s INFO %s ALL

# LISTCHANS responses
NICK_LISTCHANS_SYNTAX
	LISTCHANS
NICK_LISTCHANS_NONE
	%s heeft geen kamers geregistreerd.
NICK_LISTCHANS_HEADER
	Kamers geregistreerd door %s:
NICK_LISTCHANS_END
	Einde van de lijst (%d kamers geregistreerd).

# LIST responses
NICK_LIST_SYNTAX
	%s patroon
NICK_LIST_OPER_SYNTAX
	%s patroon [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
NICK_LIST_OPER_SYNTAX_AUTH
	%s patroon [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
NICK_LIST_HEADER
	Lijst van bijnamen met patroon %s:
NICK_LIST_RESULTS
	Einde van de lijst - %d/%d Gevonden bijnamen getoond.
NICK_LISTEMAIL_NONE
	(niet ingesteld)

# RECOVER responses
NICK_RECOVER_SYNTAX
	RECOVER bijnaam [wachtwoord]
NICK_NO_RECOVER_SELF
	U kunt RECOVER niet op uzelf uitvoeren!
NICK_RECOVERED
	Gebruiker met uw bijnaam is verwijderd.
	Typ /msg %s RELEASE %s om uw bijnaam terug te
	krijgen voor de 1-minuut timeout.

# RELEASE responses
NICK_RELEASE_SYNTAX
	RELEASE bijnaam [wachtwoord]
NICK_RELEASE_NOT_HELD
	Bijnaam %s wordt niet vastgehouden.
NICK_RELEASED
	Services houdt uw bijnaam niet langer vast.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST bijnaam [wachtwoord]
NICK_NO_GHOST_SELF
	U kunt GHOST niet op uzelf uitvoeren!
NICK_GHOST_KILLED
	Spook met uw bijnaam is verwijderd.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS bijnaam
NICK_GETPASS_UNAVAILABLE
	GETPASS commando is niet beschikbaar omdat encryptie aan staat.
NICK_GETPASS_PASSWORD_IS
	Wachtwoord van %s is %s.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID bijnaam
NICK_FORBID_SUCCEEDED
	Bijnaam %s is nu onbruikbaar.
NICK_FORBID_FAILED
	Kan bijnaam %s niet onbruikbaar maken!

# SUSPEND responses
NICK_SUSPEND_SYNTAX
	SUSPEND [+vervaltijd] bijnaam rede
NICK_SUSPEND_SUCCEEDED
	Bijnaam %s, en alle bijnamen met dezelfde bodem-bijnaam
	zijn buiten werking gesteld.
NICK_SUSPEND_ALREADY_SUSPENDED
	Bijnaam %s is al buiten werking.

# UNSUSPEND responses
NICK_UNSUSPEND_SYNTAX
	UNSUSPEND bijnaam
NICK_UNSUSPEND_SUCCEEDED
	Bijnaam %s is weer bruikbaar.
NICK_UNSUSPEND_NOT_SUSPENDED
	Bijnaam %s is niet buiten werking.

################ autojoin module messages/responses

# AJOIN responses
NICK_AJOIN_SYNTAX
	AJOIN {ADD | DEL | LIST} [kamer]
NICK_AJOIN_ADD_SYNTAX
	AJOIN ADD kamer
NICK_AJOIN_DEL_SYNTAX
	AJOIN DEL kamer
NICK_AJOIN_DISABLED
	Sorry, aanpassen van de bijnaam autojoin lijst is tijdelijk uitgeschakeld.
NICK_AJOIN_ALREADY_PRESENT
	Kamer %s is al aanwezig in uw auto-entree lijst.
NICK_AJOIN_LIST_FULL
	Sorry, u kan slechts %d auto-entree invoeren hebben per bijnaam.
NICK_AJOIN_ADDED
	%s toegevoegd aan auto-entree lijst.
NICK_AJOIN_NOT_FOUND
	%s niet gevonden in uw auto-entree lijst.
NICK_AJOIN_DELETED
	%s verwijderd uit uw auto-entree lijst.
NICK_AJOIN_LIST_EMPTY
	Uw auto-entree lijst is leeg.
NICK_AJOIN_LIST
	Auto-entree lijst:
NICK_AJOIN_LIST_X_EMPTY
	Auto-entree lijst van %s is leeg.
NICK_AJOIN_LIST_X
	Auto-entree lijst van %s:

################ mail-auth module messages/responses

# General-purpose messages
NICK_AUTH_SENT
	Een authenticatie code voor uw bijnaam is gestuurd naar %s.
NICK_AUTH_FOR_REGISTER
	Wanneer u dit bericht ontvangt, typ /msg %s AUTH code (vervang code door de authenticatie code in het bericht) om uw bijnaam registratie te voltooien.
NICK_AUTH_FOR_SET_EMAIL
	Wanneer u dit bericht ontvangt, typ /msg %s AUTH code (vervang code door de authenticatie code in het bericht) om uw E-mail wijziging te voltooien.
	Let op dat u uw bijnaam niet kan gebruiken tot de wijziging voltooid is.
NICK_AUTH_NOT_NEEDED
	Er is momenteel niets dat authenticatie vereist.
NICK_AUTH_NO_AUTHCODE
	Bijnaam %s heeft geen authenticatie code.
NICK_AUTH_HAS_AUTHCODE
	Bijnaam %s heeft al een authenticatie code.
PASSWORD_WARNING_FOR_AUTH
	Waarschuwing: Bij een volgende foute authenticatie code wordt u verwijderd.

# Mail text.  The last "%s" (before the user@host) in the body text is
# replaced by one of the NICK_AUTH_MAIL_TEXT_* messages.
NICK_AUTH_MAIL_SUBJECT
	Authenticatie code van %s
NICK_AUTH_MAIL_BODY
	De authenticatie code van uw bijnaam (%s) is: %09d
	Geef deze code aan %s met het commando:
	    /msg %s AUTH %09d
	
	Dit bericht is gestuurd door %s als reactie op %s
	%s@%s.
NICK_AUTH_MAIL_TEXT_REG
	registratie door
NICK_AUTH_MAIL_TEXT_EMAIL
	een E-mail wijziging door
NICK_AUTH_MAIL_TEXT_SENDAUTH
	een SENDAUTH commando van
NICK_AUTH_MAIL_BODY_SETAUTH
	De authenticatie code van uw bijnaam (%s) is: %09d
	Geef deze code aan %s met het commando:
	    /msg %s AUTH %09d

# AUTH responses
NICK_AUTH_SYNTAX
	AUTH code
NICK_AUTH_DISABLED
	Sorry, bijnaam authenticatie is tijdelijk uitgeschakeld.
NICK_AUTH_FAILED
	Deze authenticatie code is onjuist.
NICK_AUTH_SUCCEEDED_REGISTER
	Authenticatie geslaagd; uw bijnaam registratie is voltooid.
NICK_AUTH_SUCCEEDED_SET_EMAIL
	Authenticatie geslaagd; uw E-mail wijziging is voltooid.
NICK_AUTH_SUCCEEDED_SETAUTH
	Authenticatie geslaagd; u kunt uw bijnaam verder gebruiken.

# SENDAUTH responses
NICK_SENDAUTH_SYNTAX
	SENDAUTH
NICK_SENDAUTH_TOO_SOON
	Wacht %s voordat u het SENDAUTH commando weer gebruikt.
NICK_SENDAUTH_FAILED
	Sorry, kon authenticatie code niet verzenden.

# SETAUTH responses
NICK_SETAUTH_SYNTAX
	SETAUTH bijnaam
NICK_SETAUTH_NO_EMAIL
	Bijnaam %s heeft geen E-mail adres ingesteld.
NICK_SETAUTH_AUTHCODE_SET
	Een nieuwe authenticatie code (%09d) is ingesteld voor bijnaam %s.
NICK_SETAUTH_SEND_FAILED
	Waarschuwing: kon geen E-mail versturen aan %s.
NICK_SETAUTH_SEND_TEMPFAIL
	Waarschuwing: kon geen E-mail versturen aan %s (onvoldoende systeembronnen).
NICK_SETAUTH_USER_NOTICE
	U dient zich te authenticeren voor uw bijnaam om deze verder te kunnen gebruiken.  Een authenticatie code is verstuurd naar uw E-mail adres: %s
	Typ /msg %s HELP AUTH voor meer informatie.

# GETAUTH responses
NICK_GETAUTH_SYNTAX
	GETAUTH bijnaam
NICK_GETAUTH_AUTHCODE_IS
	De authenticatie code voor bijnaam %s is: %09d

# CLEARAUTH responses
NICK_CLEARAUTH_SYNTAX
	CLEARAUTH bijnaam
NICK_CLEARAUTH_CLEARED
	De authenticatie code van bijnaam %s is verwijderd.

################ sendpass module messages/responses

# Mail text
NICK_SENDPASS_MAIL_SUBJECT
	Wachtwoord van %s
NICK_SENDPASS_MAIL_BODY
	Het wachtwoord voor uw bijnaam is: %s
	
	Dit bericht is verstuurd door %s als reactie op een SENDPASS verzoek
	van %s@%s.

# SENDPASS responses
NICK_SENDPASS_SYNTAX
	SENDPASS
NICK_SENDPASS_FAILED
	Sorry, wachtwoord versturen mislukt.
NICK_SENDPASS_NO_EMAIL
	U heeft geen E-mail adres ingesteld.
NICK_SENDPASS_NOT_AUTHED
	Het E-mail adres van bijnaam %s is nog niet geauthenticeerd.
# parameter is "NNN days/hours/minutes"
NICK_SENDPASS_TOO_SOON
	Wacht %s voor u het SENDPASS commando opnieuw gebruikt.
NICK_SENDPASS_SENT
	Het wachtwoord voor bijnaam %s is verstuurd naar het bijbehorende E-mail adres.

###########################################################################
#
# ChanServ messages
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Automatische kamer operator status
CHAN_LEVEL_AUTOVOICE
	Automatische voice (+v)
CHAN_LEVEL_INVITE
	Mag INVITE gebruiken
CHAN_LEVEL_AKICK
	Mag AKICK gebruiken
CHAN_LEVEL_SET
	Mag SET gebruiken (niet FOUNDER/PASSWORD)
CHAN_LEVEL_CLEAR
	Mag CLEAR gebruiken
CHAN_LEVEL_UNBAN
	Mag UNBAN gebruiken
CHAN_LEVEL_OPDEOP
	Mag OP/DEOP commando's gebruiken
CHAN_LEVEL_ACCESS_LIST
	Mag de toegangslijst bekijken
CHAN_LEVEL_ACCESS_CHANGE
	Mag de toegangslijst aanpassen
CHAN_LEVEL_MEMO
	Mag kamer memo's lezen
CHAN_LEVEL_VOICE
	Mag VOICE/DEVOICE commando's gebruiken
CHAN_LEVEL_AUTOHALFOP
	Automatische halfop (+h) status
CHAN_LEVEL_HALFOP
	Mag HALFOP/DEHALFOP commando's gebruiken
CHAN_LEVEL_AUTOPROTECT
	Automatische kamer bescherming (+a) status
CHAN_LEVEL_PROTECT
	Mag PROTECT/DEPROTECT commando's gebruiken
CHAN_LEVEL_KICK
	Mag KICK commando gebruiken
CHAN_LEVEL_STATUS
	Mag STATUS commando gebruiken
CHAN_LEVEL_TOPIC
	Mag TOPIC commando gebruiken

# Automatic responses
CHAN_IS_REGISTERED
	Deze kamer is geregistreerd met %s.
CHAN_MAY_NOT_BE_USED
	Deze kamer mag niet gebruikt worden.
CHAN_NOT_ALLOWED_TO_JOIN
	U bent niet bevoegd deze kamer binnen te gaan.

# Multi-purpose responses
CHAN_MUST_IDENTIFY_NICK
	Identificeer u eerst bij %s, d.m.v. het commando:
	    /msg %s IDENTIFY wachtwoord
CHAN_BOUNCY_MODES
	Sorry, het %s commando is tijdelijk niet beschikbaar.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER kamer wachtwoord beschrijving
CHAN_REGISTER_DISABLED
	Sorry, kamer registratie is tijdelijk uitgeschakeld.
CHAN_REGISTER_SHORT_CHANNEL
	De kamer # mag niet worden geregistreerd.
CHAN_REGISTER_NOT_LOCAL
	Lokale kamers kunnen niet geregistreerd worden.
CHAN_REGISTER_INVALID_NAME
	U kunt alleen kamers registreren waarvan de naam begint met #.
CHAN_MUST_REGISTER_NICK
	U dient uw bijnaam eerst te registreren.  Typ /msg %s
	HELP voor info over registreren van bijnamen.
CHAN_MAY_NOT_BE_REGISTERED
	Kamer %s mag niet geregistreerd worden.
CHAN_ALREADY_REGISTERED
	Kamer %s is al geregistreerd!
CHAN_MUST_BE_CHANOP
	U dient kamer operator te zijn om de kamer te registreren.
CHAN_REACHED_CHANNEL_LIMIT
	Sorry, u heeft uw limiet van %d kamers bereikt.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Sorry, u heeft uw limiet van %d kamers overschreden.
CHAN_REGISTRATION_FAILED
	Sorry, registratie niet geslaagd.
CHAN_REGISTERED
	Kamer %s geregistreerd onder bijnaam: %s
CHAN_PASSWORD_IS
	Uw kamer wachtwoord is %s - Onthoud dit voor later gebruik.

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY kamer wachtwoord
CHAN_IDENTIFY_FAILED
	Sorry, identificatie niet geslaagd.
CHAN_IDENTIFY_SUCCEEDED
	Wachtwoord geaccepteerd - U heeft nu eigenaar rechten voor kamer %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP kamer
CHAN_DROP_DISABLED
	Sorry, kamer registratie ongedaan maken is tijdelijk
	uitgeschakeld.
CHAN_DROPPED
	Registratie van kamer %s is ongedaan gemaakt.

# SET responses
CHAN_SET_SYNTAX
	SET kamer optie parameters
CHAN_SET_DISABLED
	Sorry, veranderen van kamer opties is tijdelijk
	uitgeschakeld.
CHAN_SET_UNKNOWN_OPTION
	Onbekende SET optie %s.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s heeft te veel geregistreerde kamers.
CHAN_FOUNDER_CHANGED
	Eigenaar van %s veranderd naar %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Opvolger van %s veranderd naar %s.
CHAN_SUCCESSOR_IS_FOUNDER
	Eigenaar en opvolger van een kamer kunnen niet dezelfde
	persoon zijn.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Sorry, kon wachtwoord niet veranderen.
CHAN_PASSWORD_CHANGED
	%s wachtwoord veranderd.
CHAN_PASSWORD_CHANGED_TO
	%s wachtwoord veranderd naar %s.

# SET DESC responses
CHAN_DESC_CHANGED
	Beschrijving van %s veranderd naar %s.

# SET URL responses
CHAN_URL_CHANGED
	Pagina van %s veranderd naar %s.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	E-mail adres van %s veranderd naar %s.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Binnenkomst bericht van %s veranderd.

# SET MLOCK responses
CHAN_SET_MLOCK_NEED_PLUS_MINUS
	Mode lijst dient te beginnen met een + (plus) of - (min).
CHAN_SET_MLOCK_NEED_PARAM
	Parameter vereist voor MLOCK +%c.
CHAN_SET_MLOCK_NEED_POSITIVE
	Parameter voor MLOCK +%c dient een positief nummer te zijn.
CHAN_SET_MLOCK_MODE_REG_BAD
	Mode +%c is is altijd aanwezig in geregistreerde kamers,
	en kan niet gebruikt worden met MLOCK.
CHAN_SET_MLOCK_LINK_BAD
	Parameter voor MLOCK +%c is geen geldige kamer naam.
CHAN_SET_MLOCK_LINK_SAME
	Parameter voor MLOCK +%c dient een andere kamer te zijn.
CHAN_SET_MLOCK_REQUIRES
	MLOCK +%c vereist dat MLOCK +%c is ingesteld.
CHAN_SET_MLOCK_BAD_PARAM
	Ongeldige parameter voor MLOCK +%c.
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Onbekend mode karakter %c genegeerd.
CHAN_SET_MLOCK_CANNOT_LOCK
	Mode %c kan niet vastgezet worden.
CHAN_MLOCK_CHANGED
	Mode slot van kamer %s veranderd naar %s.
CHAN_MLOCK_REMOVED
	Mode slot van kamer %s verwijderd.

# SET HIDE responses
CHAN_SET_HIDE_SYNTAX
	SET kamer HIDE {EMAIL | TOPIC | MLOCK} {ON | OFF}
CHAN_SET_HIDE_EMAIL_ON
	Kamer %s E-mail adres wordt nu verborgen in %s INFO overzichten.
CHAN_SET_HIDE_EMAIL_OFF
	Kamer %s E-mail adres wordt nu getoond in %s INFO overzichten.
CHAN_SET_HIDE_TOPIC_ON
	Kamer %s onderwerp wordt nu verborgen in %s INFO overzichten.
CHAN_SET_HIDE_TOPIC_OFF
	Kamer %s onderwerp wordt nu getoond in %s INFO overzichten.
CHAN_SET_HIDE_MLOCK_ON
	Kamer %s mode slot wordt nu verborgen in %s INFO overzichten.
CHAN_SET_HIDE_MLOCK_OFF
	Kamer %s mode slot wordt nu getoond in %s INFO overzichten.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET kamer KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Onderwerp behoud is nu ON (aan).
CHAN_SET_KEEPTOPIC_OFF
	Onderwerp behoud is nu OFF (uit).

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET kamer TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Onderwerp slot is nu ON (aan).
CHAN_SET_TOPICLOCK_OFF
	Onderwerp slot is nu OFF (uit).

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET channel PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Priv optie staat nu ON (aan).
CHAN_SET_PRIVATE_OFF
	Priv optie staat nu OFF (uit).

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET kamer SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Operator beveiligingsoptie staat nu ON (aan).
CHAN_SET_SECUREOPS_OFF
	Operator beveiligingsoptie staat nu OFF (uit).

# SET LEAVEOPS responses
CHAN_SET_LEAVEOPS_SYNTAX
	SET kamer LEAVEOPS {ON | OFF}
CHAN_SET_LEAVEOPS_ON
	Operator behoud staat nu ON (aan).
CHAN_SET_LEAVEOPS_OFF
	Operator behoud optie staat nu OFF (uit).

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET channel RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Beperkte toegang staat nu ON (aan).
CHAN_SET_RESTRICTED_OFF
	Beperkte toegang staat nu OFF (uit).

# SET SECURE responses
CHAN_SET_SECURE_SYNTAX
	SET kamer SECURE {ON | OFF}
CHAN_SET_SECURE_ON
	Beveiliging staat nu ON (aan).
CHAN_SET_SECURE_OFF
	Beveiliging staat nu OFF (uit).

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET kamer OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Operator-alarm staat nu ON (aan).
CHAN_SET_OPNOTICE_OFF
	Operator-alarm staat nu OFF (uit).

# SET ENFORCE responses
CHAN_SET_ENFORCE_SYNTAX
	SET kamer ENFORCE {ON | OFF}
CHAN_SET_ENFORCE_ON
	Behoud optie staat nu ON (aan).
CHAN_SET_ENFORCE_OFF
	Behoud optie staat nu OFF (uit).

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET kamer NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	kamer %s zal niet vervallen.
CHAN_SET_NOEXPIRE_OFF
	Kamer %s zal vervallen.

# UNSET responses
CHAN_UNSET_SYNTAX
	UNSET kamer {SUCCESSOR | URL | EMAIL | ENTRYMSG}
CHAN_SUCCESSOR_UNSET
	Opvolger van %s verwijderd.
CHAN_URL_UNSET
	Pagina van %s verwijderd.
CHAN_EMAIL_UNSET
	E-mail adres van %s verwijderd.
CHAN_ENTRY_MSG_UNSET
	Binnenkomst bericht van %s verwijderd.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS channel {ADD | DEL | LIST | COUNT} [bijnaam [level] | invoerlijst]
CHAN_ACCESS_DISABLED
	Sorry, aanpassen van de kamer toegangslijst is tijdelijk
	uitgeschakeld.
CHAN_ACCESS_LEVEL_NONZERO
	Toegangs-status mag geen nul zijn.
CHAN_ACCESS_LEVEL_RANGE
	Toegangs-status dient tussen %d en %d te zijn.
CHAN_ACCESS_NICKS_ONLY
	Kamer toegangslijst mag alleen geregistreerde bijnamen
	bevatten.
CHAN_ACCESS_REACHED_LIMIT
	Sorry, Het aantal toegangen in de lijst is beperkt tot %d.
CHAN_ACCESS_LEVEL_UNCHANGED
	Toegangs-status van %s in %s onveranderd op %d.
CHAN_ACCESS_LEVEL_CHANGED
	Toegangs-status van %s in %s veranderd naar %d.
CHAN_ACCESS_ADDED
	%s toegevoegd aan %s toegangslijst met status %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Invoer (#%d) komt niet voor in toegangslijst van %s.
CHAN_ACCESS_NOT_FOUND
	%s niet gevonden in toegangslijst van %s.
CHAN_ACCESS_NO_MATCH
	Invoer niet gevonden in toegangslijst van %s.
CHAN_ACCESS_DELETED
	%s verwijderd uit toegangslijst van %s.
CHAN_ACCESS_DELETED_ONE
	1 invoer verwijderd uit toegangslijst van %s.
CHAN_ACCESS_DELETED_SEVERAL
	%d invoeren verwijderd uit toegangslijst van %s.
CHAN_ACCESS_LIST_EMPTY
	Toegangslijst van %s is leeg.
CHAN_ACCESS_LIST_HEADER
	Toegangslijst voor %s:
	   Nr  Stat  naam
CHAN_ACCESS_LIST_FORMAT
	 %4d  %4d  %s
CHAN_ACCESS_COUNT
	De toegangslijst van %s heeft %d invoeren.

# XOP (AOP/SOP/VOP) responses
CHAN_SOP_SYNTAX
	SOP kamer {ADD | DEL | LIST | COUNT} [bijnaam | invoerlijst]
CHAN_AOP_SYNTAX
	AOP kamer {ADD | DEL | LIST | COUNT} [bijnaam | invoerlijst]
CHAN_HOP_SYNTAX
	HOP kamer {ADD | DEL | LIST | COUNT} [bijnaam | invoerlijst]
CHAN_VOP_SYNTAX
	VOP kamer {ADD | DEL | LIST | COUNT} [bijnaam | invoerlijst]
CHAN_XOP_ADDED
	%s toegevoegd aan %s %s lijst.
CHAN_XOP_LEVEL_CHANGED
	%s verplaatst naar %s %s lijst.
CHAN_XOP_LEVEL_UNCHANGED
	%s staat al in %s %s lijst.
CHAN_XOP_NICKS_ONLY
	SOP, AOP, en VOP lijsten mogen alleen geregistreerde
	bijnamen bevatten.
CHAN_XOP_NICKS_ONLY_HOP
	SOP, AOP, HOP, en VOP lijsten mogen alleen geregistreerde
	bijnamen bevatten.
CHAN_XOP_REACHED_LIMIT
	Sorry, het aantal invoeren in SOP, AOP en VOP lijsten
	mag niet groter zijn dan %d.  Aantal overschreden.
CHAN_XOP_REACHED_LIMIT_HOP
	Sorry, het aantal invoeren in SOP, AOP, HOP en VOP lijsten
	mag niet groter zijn dan %d.  Aantal overschreden.
CHAN_XOP_NOT_FOUND
	%s niet gevonden in %s %s lijst.
CHAN_XOP_NO_SUCH_ENTRY
	Invoer (#%d) komt niet voor in %s %s lijst.
CHAN_XOP_NO_MATCH
	Invoer niet gevonden in %s %s lijst.
CHAN_XOP_DELETED
	%s verwijderd uit %s %s lijst.
CHAN_XOP_DELETED_ONE
	1 invoer verwijderd uit %s %s lijst.
CHAN_XOP_DELETED_SEVERAL
	%d invoeren verwijderd uit %s %s lijst.
CHAN_XOP_LIST_EMPTY
	%s %s lijst is leeg.
CHAN_XOP_LIST_HEADER
	%s list for %s:
	   Nr   Naam
CHAN_XOP_LIST_FORMAT
	 %4d   %s
CHAN_XOP_COUNT
	De %s %s lijst heeft %d invoeren.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK kamer {ADD | DEL | LIST | VIEW | ENFORCE | COUNT} [masker | lijst]
CHAN_AKICK_DISABLED
	Sorry, kamer AKICK lijst bewerking is tijdelijk
	uitgeschakeld.
CHAN_AKICK_ALREADY_EXISTS
	%s bestaat al in AKICK lijst van %s.
CHAN_AKICK_REACHED_LIMIT
	Sorry, u kunt slechts %d AKICK maskers invoeren
	per kamer.
CHAN_AKICK_ADDED
	%s toegevoegd aan %s AKICK lijst.
CHAN_AKICK_NO_SUCH_ENTRY
	Invoer (#%d) bestaat niet in %s AKICK lijst.
CHAN_AKICK_NOT_FOUND
	%s niet gevonden in %s AKICK lijst.
CHAN_AKICK_NO_MATCH
	Invoer niet gevonden in %s AKICK lijst.
CHAN_AKICK_DELETED
	%s verwijderd uit %s AKICK lijst.
CHAN_AKICK_DELETED_ONE
	1 invoer verwijderd uit %s AKICK lijst.
CHAN_AKICK_DELETED_SEVERAL
	%d invoeren verwijderd uit %s AKICK lijst.
CHAN_AKICK_LIST_EMPTY
	%s AKICK lijst is leeg.
CHAN_AKICK_LIST_HEADER
	AKICK lijst van %s:
# index, mask, set-by, set-time, last-used, reason
CHAN_AKICK_VIEW_FORMAT
	  %3d %s (door %s op %s; laatst gebruikt %s)
	         %s
# index, mask, set-by, set-time, reason
CHAN_AKICK_VIEW_UNUSED_FORMAT
	  %3d %s (door %s op %s; nooit gebruikt)
	         %s
CHAN_AKICK_ENFORCE_DONE
	AKICK ENFORCE in %s voltooid; %d gebruikers verwijderd.
CHAN_AKICK_COUNT
	%s heeft %d invoeren in de AKICK lijst.

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS kamer {SET | DIS[ABLE] | LIST | RESET} [optie [level]]
CHAN_LEVELS_READONLY
	Sorry, aanpassen van kamer toegangsniveaus is tijdelijk uitgeschakeld.
CHAN_LEVELS_RANGE
	Level moet tussen %d en %d liggen.
CHAN_LEVELS_CHANGED
	Level van %s in kamer %s veranderd naar %d.
CHAN_LEVELS_UNKNOWN
	Optie %s onbekend.  Typ /msg %s HELP LEVELS DESC voor
	een lijst van geldige opties.
CHAN_LEVELS_DISABLED
	%s uitgeschakeld in kamer %s.
CHAN_LEVELS_LIST_HEADER
	Toegangslevel van kamer %s ingesteld op:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (uitgeschakeld)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (alleen voor eigenaar)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %4d
CHAN_LEVELS_RESET
	Toegangslevels van %s Teruggezet naar standaardwaarden.

# INFO responses
CHAN_INFO_SYNTAX
	INFO kamer [ALL]
CHAN_INFO_HEADER
	Informatie over kamer %s:
CHAN_INFO_FOUNDER
	Eigenaar: %s
CHAN_INFO_SUCCESSOR
	Opvolger: %s
CHAN_INFO_DESCRIPTION
	Beschrijving: %s
CHAN_INFO_ENTRYMSG
	Binnenkomst bericht: %s
CHAN_INFO_TIME_REGGED
	Geregistreerd: %s
CHAN_INFO_LAST_USED
	Laatst gebruikt: %s
CHAN_INFO_LAST_TOPIC
	Laatste onderwerp: %s
CHAN_INFO_TOPIC_SET_BY
	Onderwerp ingesteld door: %s
CHAN_INFO_URL
	Pagina: %s
CHAN_INFO_EMAIL
	E-mail adres: %s
CHAN_INFO_OPTIONS
	Opties: %s
CHAN_INFO_OPT_PRIVATE
	Priv
CHAN_INFO_OPT_KEEPTOPIC
	Onderwerp behoud
CHAN_INFO_OPT_TOPICLOCK
	Onderwerp slot
CHAN_INFO_OPT_SECUREOPS
	Operator beveiliging
CHAN_INFO_OPT_LEAVEOPS
	Operator behoud
CHAN_INFO_OPT_RESTRICTED
	Beperkte toegang
CHAN_INFO_OPT_SECURE
	Beveiligd
CHAN_INFO_OPT_OPNOTICE
	Operator alarm
CHAN_INFO_OPT_ENFORCE
	Behoud
CHAN_INFO_OPT_NONE
	Geen
CHAN_INFO_MODE_LOCK
	Mode slot: %s
CHAN_INFO_NO_EXPIRE
	Deze kamer zal niet vervallen.
CHAN_INFO_SUSPEND_DETAILS
	Buiten werking gesteld door %s op %s (%s).
CHAN_INFO_SUSPEND_REASON
	Rede: %s
CHAN_INFO_SHOW_ALL
	Voor meer informatie, typ: /msg %s INFO %s ALL

# LIST responses
CHAN_LIST_SYNTAX
	LIST patroon
CHAN_LIST_OPER_SYNTAX
	LIST patroon [FORBIDDEN] [NOEXPIRE]
CHAN_LIST_HEADER
	Lijst van invoeren met %s:
CHAN_LIST_END
	Einde van de lijst - %d/%d invoeren getoond.

# INVITE responses
CHAN_INVITE_SYNTAX
	INVITE kamer
CHAN_INVITE_OK
	%s wordt uitgenodigd voor kamer %s.

# OP/DEOP/VOICE/DEVOICE responses
CHAN_OPVOICE_SYNTAX
	%s kamer [bijnaam]
CHAN_OP_SUCCEEDED
	%s operator status gegeven in kamer %s.
CHAN_OP_ALREADY
	%s heeft al operator status in kamer %s.
CHAN_OP_FAILED
	Kan %s geen operator status geven in kamer %s.
CHAN_DEOP_SUCCEEDED
	Operator status van %s in kamer %s verwijderd.
CHAN_DEOP_ALREADY
	%s heeft al geen operator status meer in kamer %s.
CHAN_DEOP_FAILED
	Kon operator status van %s in kamer %s niet verwijderen.
CHAN_VOICE_SUCCEEDED
	%s voice gegeven in kamer %s.
CHAN_VOICE_ALREADY
	%s heeft al voice in kamer %s.
CHAN_VOICE_FAILED
	Kon %s geen voice geven in kamer %s.
CHAN_DEVOICE_SUCCEEDED
	Voice van %s in kamer %s verwijderd.
CHAN_DEVOICE_ALREADY
	%s heeft al geen voice meer in kamer %s.
CHAN_DEVOICE_FAILED
	Kon voice van %s in kamer %s niet verwijderen.
CHAN_HALFOP_SUCCEEDED
	%s halfop status gegeven in kamer %s.
CHAN_HALFOP_ALREADY
	%s heeft al halfop status in kamer %s.
CHAN_HALFOP_FAILED
	Kon %s geen halfop status geven in kamer %s.
CHAN_DEHALFOP_SUCCEEDED
	Halfop status van %s in kamer %s verwijderd.
CHAN_DEHALFOP_ALREADY
	%s heeft al geen halfop status meer in kamer %s.
CHAN_DEHALFOP_FAILED
	Kon halfop status van %s in kamer %s niet verwijderen.
CHAN_PROTECT_SUCCEEDED
	 %s beschermd in kamer %s.
CHAN_PROTECT_ALREADY
	%s is al beschermd in kamer %s.
CHAN_PROTECT_FAILED
	Kon %s niet beschermen in kamer %s.
CHAN_DEPROTECT_SUCCEEDED
	Bescherming van %s in kamer %s verwijderd.
CHAN_DEPROTECT_ALREADY
	%s is al onbeschermd in kamer %s.
CHAN_DEPROTECT_FAILED
	Kon bescherming van %s in kamer %s niet verwijderen.

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN kamer
CHAN_UNBANNED
	U bent niet langer verbannen van kamer %s.

# KICK responses
CHAN_KICK_SYNTAX
	KICK kamer bijnaam [rede]
CHAN_KICK_PROTECTED
	%s mag niet verwijderd worden van kamer %s.
CHAN_KICKED
	%s verwijderd van kamer %s.

# TOPIC responses
CHAN_TOPIC_SYNTAX
	TOPIC kamer onderwerp

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR kamer optie
CHAN_CLEARED_BANS
	Alle verbannenen van kamer %s kunnen weer binnengaan.
CHAN_CLEARED_EXCEPTIONS
	Alle uitzonderingen van kamer %s zijn verwijderd.
CHAN_CLEARED_INVITES
	Alle uitnodigingsmaskers van kamer %s zijn verwijderd.
CHAN_CLEARED_MODES
	Alle modes van kamer %s zijn teruggezet naar de
	standaardwaardes.
CHAN_CLEARED_OPS
	Mode +o verwijderd in kamer %s.
CHAN_CLEARED_HALFOPS
	Mode +h verwijderd in kamer %s.
CHAN_CLEARED_VOICES
	Mode +v verwijderd in kamer %s.
CHAN_CLEARED_USERS
	Alle gebruikers zijn verwijderd uit kamer %s.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS kamer
CHAN_GETPASS_UNAVAILABLE
	GETPASS niet beschikbaar omdat versleuteling aan staat.
CHAN_GETPASS_PASSWORD_IS
	Wachtwoord van kamer %s is %s.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID kamer
CHAN_FORBID_SHORT_CHANNEL
	De kamer # mag niet onbruikbaar gemaakt worden.
CHAN_FORBID_SUCCEEDED
	Kamer %s is nu onbruikbaar.
CHAN_FORBID_FAILED
	Kon kamer %s niet onbruikbaar maken!

# SUSPEND responses
CHAN_SUSPEND_SYNTAX
	SUSPEND [+vervaltijd] kamer rede
CHAN_SUSPEND_SUCCEEDED
	Kamer %s is buiten werking gesteld.
CHAN_SUSPEND_ALREADY_SUSPENDED
	Kamer %s is reeds buiten werking.

# UNSUSPEND responses
CHAN_UNSUSPEND_SYNTAX
	UNSUSPEND kamer
CHAN_UNSUSPEND_SUCCEEDED
	Kamer %s is niet langer buiten werking.
CHAN_UNSUSPEND_NOT_SUSPENDED
	Kamer %s is niet buiten werking.

################ sendpass module messages/responses

# Mail text
CHAN_SENDPASS_MAIL_SUBJECT
	Wachtwoord van %s
CHAN_SENDPASS_MAIL_BODY
	Het wachtwoord van kamer %s is: %s
	
	Dit bericht is verstuurd door %s als reactie op een SENDPASS verzoek
	van %s@%s.

# SENDPASS responses
CHAN_SENDPASS_SYNTAX
	SENDPASS kamer
CHAN_SENDPASS_FAILED
	Sorry, wachtwoord versturen mislukt.
CHAN_SENDPASS_FOUNDER_ONLY
	Alleen de eigenaar van de kamer kan het SENDPASS commando gebruiken.
CHAN_SENDPASS_NO_EMAIL
	U heeft geen E-mail adres ingesteld voor uw bijnaam.
# parameter is "NNN days/hours/minutes"
CHAN_SENDPASS_TOO_SOON
	Wacht %s voordat u het SENDPASS commando opnieuw gebruikt.
CHAN_SENDPASS_SENT
	Het wachtwoord voor kamer %s is verstuurd naar %s.

###########################################################################
#
# MemoServ messages
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	U heeft 1 nieuwe memo.
MEMO_HAVE_NEW_MEMOS
	U heeft %d nieuwe memo's.
MEMO_TYPE_READ_LAST
	Typ /msg %s READ LAST om deze te lezen.
MEMO_TYPE_READ_NUM
	Typ /msg %s READ %d om deze te lezen.
MEMO_TYPE_LIST_NEW
	Typ /msg %s LIST NEW voor een lijst van nieuwe memo's.
MEMO_AT_LIMIT
	Waarschuwing: U heeft het maximum aantal memo's (%d)
	bereikt. U kunt geen nieuwe memo's ontvangen totdat u oude
	verwijdert.
MEMO_OVER_LIMIT
	Waarschuwing: U heeft het maximum aantal memo's (%d)
	overschreden. U kunt geen nieuwe memo's ontvangen totdat u
	oude verwijdert.
MEMO_NEW_MEMO_ARRIVED
	U heeft een nieuwe memo ontvangen van %s.
	Typ /msg %s READ %d om deze te lezen.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	U heeft geen memo's.
MEMO_X_HAS_NO_MEMOS
	%s heeft geen memo's.
MEMO_DOES_NOT_EXIST
	Memo %d bestaat niet!
MEMO_LIST_NOT_FOUND
	Geen memo volgens dit patroon gevonden.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {bijnaam | kamer} memo-tekst
MEMO_SEND_DISABLED
	Sorry, het sturen van memo's is tijdelijk uitgeschakeld.
MEMO_SEND_PLEASE_WAIT
	Wacht %s voordat u het SEND commando weer gebruikt.
MEMO_X_GETS_NO_MEMOS
	%s kan geen memo's ontvangen.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s heeft momenteel teveel memo's en kan geen nieuwe
	ontvangen.
MEMO_SENT
	Memo verstuurd naar %s.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [kamer] [num | list | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	U heeft geen nieuwe memo's.
MEMO_X_HAS_NO_NEW_MEMOS
	%s heeft geen nieuwe memo's.
MEMO_LIST_MEMOS
	Memo's van %s.  Om te lezen, typ: /msg %s READ num
MEMO_LIST_NEW_MEMOS
	Nieuwe memo's van %s.  Om te lezen, typ: /msg %s READ num
MEMO_LIST_CHAN_MEMOS
	Memo's van %s.  Om te lezen, typ: /msg %s READ %s num
MEMO_LIST_CHAN_NEW_MEMOS
	Nieuwe memo's van %s.  Om te lezen, typ: /msg %s READ %s num
MEMO_LIST_HEADER
	  Num  Afzender          Datum/Tijd
MEMO_LIST_FORMAT
	%c%c%3d  %-16s  %s

# READ responses
MEMO_READ_SYNTAX
	READ [kamer] {num | list | LAST | NEW}
MEMO_HEADER
	Memo %d van %s (%s).  Om te verwijderen,
	typ: /msg %s DEL %d
MEMO_CHAN_HEADER
	Memo %d van %s (%s).  Om te verwijderen,
	typ: /msg %s DEL %s %d

# SAVE responses
MEMO_SAVE_SYNTAX
	SAVE [kamer] {num | lijst}
MEMO_SAVED_ONE
	Memo %d vervalt niet.
MEMO_SAVED_SEVERAL
	%d memo's vervallen niet.

# DEL responses
MEMO_DEL_SYNTAX
	DEL [kamer] {num | list | ALL}
MEMO_DELETED_NONE
	Geen memo's verwijderd.
MEMO_DELETED_ONE
	Memo %d verwijderd.
MEMO_DELETED_SEVERAL
	%d memo's verwijderd.
MEMO_DELETED_ALL
	Al uw memo's zijn verwijderd.

# SET responses
MEMO_SET_SYNTAX
	SET optie parameters
MEMO_SET_DISABLED
	Sorry, het veranderen van memo-opties is tijdelijk
	uitgeschakeld.
MEMO_SET_UNKNOWN_OPTION
	Onbekende SET optie %s.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s zal u bericht geven van nieuwe memo's wanneer u inlogt
	en wanneer ze verstuurd worden.
MEMO_SET_NOTIFY_LOGON
	%s zal u bericht geven van nieuwe memo's wanneer u inlogt
	of terugkomt van /AWAY.
MEMO_SET_NOTIFY_NEW
	%s zal u bericht geven van nieuwe memo's wanneer ze
	verstuurd worden.
MEMO_SET_NOTIFY_OFF
	%s zal u geen bericht geven van nieuwe memo's.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [kamer] limiet
MEMO_SET_LIMIT_OPER_SYNTAX
	SET LIMIT [bijnaam | kamer] {limiet | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	U kunt uw memo-limiet niet veranderen.
MEMO_SET_LIMIT_FORBIDDEN
	De memo-limiet van %s mag niet veranderd worden.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	U kunt uw memo-limiet niet hoger dan %d zetten.
MEMO_SET_LIMIT_TOO_HIGH
	U kunt de memo-limiet van %s niet hoger dan %d zetten.
MEMO_SET_LIMIT_OVERFLOW
	Memo-limiet te groot; limiet ingesteld op %d.
MEMO_SET_YOUR_LIMIT
	Uw memo-limiet is ingesteld op %d.
MEMO_SET_YOUR_LIMIT_ZERO
	U kunt niet langer memo's ontvangen.
MEMO_SET_YOUR_LIMIT_DEFAULT
	Uw memo-limiet is ingesteld op standaard (%d).
MEMO_UNSET_YOUR_LIMIT
	Uw memo-limiet is uitgeschakeld.
MEMO_SET_LIMIT
	Memo-limiet van %s veranderd naar %d.
MEMO_SET_LIMIT_ZERO
	Memo-limiet van %s veranderd naar 0.
MEMO_SET_LIMIT_DEFAULT
	Memo-limiet van %s veranderd naar standaard (%d).
MEMO_UNSET_LIMIT
	Memo-limiet uitgeschakeld voor %s.

# INFO responses
MEMO_INFO_NO_MEMOS
	U heeft momenteel geen memo's.
MEMO_INFO_MEMO
	U heeft momenteel 1 memo.
MEMO_INFO_MEMO_UNREAD
	 U heeft momenteel 1 memo, en deze is nog niet gelezen.
MEMO_INFO_MEMOS
	U heeft momenteel %d memo's.
MEMO_INFO_MEMOS_ONE_UNREAD
	U heeft momenteel %d memo's, waarvan er 1 nog niet is
	gelezen.
MEMO_INFO_MEMOS_SOME_UNREAD
	U heeft momenteel %d memo's, waarvan er %d nog niet
	zijn gelezen.
MEMO_INFO_MEMOS_ALL_UNREAD
	U heeft momenteel %d memo's; waarvan er nog geen is
	gelezen.
MEMO_INFO_LIMIT
	Uw memo-limiet is %d.
MEMO_INFO_HARD_LIMIT
	Uw memo-limiet is %d, en mag niet veranderd worden.
MEMO_INFO_LIMIT_ZERO
	Uw memo-limiet is 0; u kunt geen memo's ontvangen.
MEMO_INFO_HARD_LIMIT_ZERO
	Uw memo-limiet is 0; u kunt geen memo's ontvangen.
	U kunt deze limiet niet veranderen.
MEMO_INFO_NO_LIMIT
	U heeft geen limiet op het aantal memo's dat u mag hebben.
MEMO_INFO_NOTIFY_OFF
	U krijgt geen nieuw bericht over nieuwe memo's.
MEMO_INFO_NOTIFY_ON
	U krijgt bericht van nieuwe memo's wanneer u inlogt en
	wanneer ze verstuurd worden.
MEMO_INFO_NOTIFY_RECEIVE
	U krijgt bericht van nieuwe memo's wanneer deze verstuurd
	worden.
MEMO_INFO_NOTIFY_SIGNON
	U krijgt bericht van nieuwe memo's wanneer u inlogt op IRC.
MEMO_INFO_X_NO_MEMOS
	%s heeft momenteel geen memo's.
MEMO_INFO_X_MEMO
	%s heeft momenteel 1 memo.
MEMO_INFO_X_MEMO_UNREAD
	%s heeft momenteel 1 memo, deze is nog niet gelezen.
MEMO_INFO_X_MEMOS
	%s heeft momenteel %d memo's.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s heeft momenteel %d memo's, waarvan er 1 nog niet
	is gelezen.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s heeft momenteel %d memo's, waarvan er %d nog niet
	zijn gelezen.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s heeft momenteel %d memo's; waarvan er geen gelezen is.
MEMO_INFO_X_LIMIT
	%s's memo-limiet is %d.
MEMO_INFO_X_HARD_LIMIT
	%s's memo-limiet is %d, en mag niet veranderd worden.
MEMO_INFO_X_NO_LIMIT
	%s heeft geen memo-limiet.
MEMO_INFO_X_NOTIFY_OFF
	%s krijgt geen bericht van nieuwe memo's.
MEMO_INFO_X_NOTIFY_ON
	%s krijgt bericht van nieuwe memo's wanneer hij/zij inlogt
	en wanneer ze verstuurd worden.
MEMO_INFO_X_NOTIFY_RECEIVE
	%s krijgt bericht van nieuwe memo's wanneer deze verstuurd
	worden.
MEMO_INFO_X_NOTIFY_SIGNON
	%s krijgt bericht van nieuwe memo's wanneer hij/zij inlogt
	op IRC.

################ forward module messages/responses

# Mail format
MEMO_FORWARD_MAIL_SUBJECT
	Memo voor %s
MEMO_FORWARD_MAIL_BODY
	Memo van %s (%s)
	%s

# FORWARD responses
MEMO_FORWARD_SYNTAX
	FORWARD {num | lijst | ALL}
MEMO_FORWARD_NEED_EMAIL
	U dient een E-mail adres in te stellen voordat memo's naar u doorgestuurd
	kunnen worden.
MEMO_FORWARD_PLEASE_WAIT
	Wacht %s voordat u het FORWARD commando weer gebruikt.
MEMO_FORWARD_FAILED
	Sorry, doorsturen mislukt.
MEMO_FORWARDED_NONE
	Er zijn geen memo's doorgestuurd.
MEMO_FORWARDED_ONE
	Memo %d is doorgestuurd.
MEMO_FORWARDED_SEVERAL
	%d memo's zijn doorgestuurd.
MEMO_FORWARDED_ALL
	All uw memo's zijn doorgestuurd.
MEMO_FORWARDED_ALSO_TEMPFAIL
	Opmerking: Sommige memo's zijn niet doorgestuurd omdat het systeem te druk was.
MEMO_FORWARDED_ALSO_PERMFAIL
	Opmerking: Sommige memo's zijn niet doorgestuurd vanwege een systeemfout.

# SET FORWARD responses
MEMO_SET_FORWARD_SYNTAX
	SET FORWARD {ON | COPY | OFF}
MEMO_SET_FORWARD_ON
	Uw memo's worden nu doorgestuurd naar uw  E-mail adres: %s
MEMO_SET_FORWARD_COPY
	Uw memo's worden nu doorgestuurd naar uw  E-mail adres: %s
	Uw memo's worden ook bewaard door Services.
MEMO_SET_FORWARD_OFF
	Uw memo's worden niet doorgestuurd naar uw E-mail adres.

################ ignore module messages/responses

# IGNORE responses
MEMO_IGNORE_SYNTAX
	IGNORE {ADD | DEL | LIST} [bijnaam | masker]
MEMO_IGNORE_ADD_SYNTAX
	IGNORE ADD bijnaam | masker
MEMO_IGNORE_DEL_SYNTAX
	IGNORE DEL bijnaam | masker
MEMO_IGNORE_LIST_FULL
	Uw negeer lijst is vol.
MEMO_IGNORE_ALREADY_PRESENT
	%s staat al in uw negeer lijst.
MEMO_IGNORE_ADDED
	%s toegevoegd aan uw negeer lijst.
MEMO_IGNORE_NOT_FOUND
	%s niet gevonden in uw negeer lijst.
MEMO_IGNORE_DELETED
	%s verwijderd uit uw negeer lijst.
MEMO_IGNORE_LIST_EMPTY
	Uw negeer-lijst is leeg.
MEMO_IGNORE_LIST
	Negeer lijst:
MEMO_IGNORE_LIST_X_EMPTY
	Negeer lijst van %s is leeg.
MEMO_IGNORE_LIST_X
	Negeer lijst van %s:

###########################################################################
#
# OperServ messages
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Services kan mode niet veranderen.  Zijn uw services juist
	geconfigureerd?
OPER_BOUNCY_MODES_U_LINE
	Services kan mode niet veranderen.  Zijn de U:lines van uw
	servers juist geconfigureerd?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL bericht

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Onbekende STATS optie %s.
OPER_STATS_RESET_USER_COUNT
	Het maximum getelde gebruikers is teruggezet naar de standaardwaarde.

OPER_STATS_CURRENT_USERS
	Aantal gebruikers op dit moment: %d (%d ops)
OPER_STATS_MAX_USERS
	Maximum aantal gebruikers: %d (%s)
OPER_STATS_UPTIME_DHMS
	Services online: %d %s, %02d:%02d
# If >= 1 hour, hours and minutes; if < 1 hour, minutes and seconds
OPER_STATS_UPTIME_HM_MS
	Services online: %s

OPER_STATS_KBYTES_READ
	Ontvangen data:   %10u kB
OPER_STATS_KBYTES_WRITTEN
	Verstuurde data:  %10u kB
OPER_STATS_NETBUF_SOCK
	Server socket buffers: %5u kB
OPER_STATS_NETBUF_SOCK_PERCENT
	Server socket buffers: %5u kB (%d%%)
OPER_STATS_NETBUF_TOTAL
	Totale socket buffers: %5u kB
OPER_STATS_NETBUF_TOTAL_PERCENT
	Totale socket buffers: %5u kB (%d%%)

OPER_STATS_ALL_USER_MEM
	Gebruikers:      %6d invoeren, %5d kB
OPER_STATS_ALL_CHANNEL_MEM
	Kamers:          %6d invoeren, %5d kB
OPER_STATS_ALL_SERVER_MEM
	Servers:         %6d invoeren, %5d kB
OPER_STATS_ALL_NICKGROUPINFO_MEM
	Bijnaam groepen: %6d invoeren, %5d kB
OPER_STATS_ALL_NICKINFO_MEM
	Bijnamen:        %6d invoeren, %5d kB
OPER_STATS_ALL_CHANSERV_MEM
	ChanServ:        %6d invoeren, %5d kB
OPER_STATS_ALL_STATSERV_MEM
	StatServ:        %6d invoeren, %5d kB
OPER_STATS_ALL_NEWS_MEM
	Nieuws:          %6d invoeren, %5d kB
OPER_STATS_ALL_AKILL_MEM
	Autokills:       %6d invoeren, %5d kB
OPER_STATS_ALL_EXCEPTION_MEM
	Uitzonderingen:  %6d invoeren, %5d kB
OPER_STATS_ALL_SGLINE_MEM
	SGlines:         %6d invoeren, %5d kB
OPER_STATS_ALL_SQLINE_MEM
	SQlines:         %6d invoeren, %5d kB
OPER_STATS_ALL_SZLINE_MEM
	SZlines:         %6d invoeren, %5d kB
OPER_STATS_ALL_SESSION_MEM
	Sessies:         %6d invoeren, %5d kB

# MODE responses
OPER_MODE_SYNTAX
	MODE kamer modes

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES kamer [ALL]
OPER_CLEARMODES_DONE
	Binaire modes en verbanningen verwijderd van kamer %s.
OPER_CLEARMODES_EXCEPT_DONE
	Binaire modes, verbanningen en uitzonderingen verwijderd van kamer %s.
OPER_CLEARMODES_ALL_DONE
	Alle modes verwijderd van kamer %s.

# CLEARCHAN responses
OPER_CLEARCHAN_SYNTAX
	CLEARCHAN kamer
OPER_CLEARCHAN_DONE
	Alle gebruikers verwijderd van kamer %s.

# KICK responses
OPER_KICK_SYNTAX
	KICK kamer gebruiker rede

# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD | DEL | LIST} [bijnaam]
OPER_ADMIN_ADD_SYNTAX
	ADMIN ADD bijnaam
OPER_ADMIN_DEL_SYNTAX
	ADMIN DEL bijnaam
OPER_ADMIN_NO_NICKSERV
	NickServ is momenteel uitgeschakeld; het ADMIN commando is niet
	beschikbaar.
OPER_ADMIN_EXISTS
	%s bestaat al in Services admin lijst.
OPER_ADMIN_ADDED
	%s toegevoegd aan Services admin lijst.
OPER_ADMIN_TOO_MANY
	Teveel invoeren (%d) in Services admin lijst; kan niet meer
	toevoegen.
OPER_ADMIN_REMOVED
	%s verwijderd uit Services admin lijst.
OPER_ADMIN_NOT_FOUND
	%s niet gevonden in Services admin lijst.
OPER_ADMIN_LIST_HEADER
	Services admin lijst:

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD | DEL | LIST} [bijnaam]
OPER_OPER_ADD_SYNTAX
	OPER ADD bijnaam
OPER_OPER_DEL_SYNTAX
	OPER DEL bijnaam
OPER_OPER_NO_NICKSERV
	NickServ is momenteel uitgeschakeld; het OPER commando is niet
	beschikbaar.
OPER_OPER_EXISTS
	%s bestaat al in Services operator lijst.
OPER_OPER_ADDED
	%s toegevoegd aan Services operator lijst.
OPER_OPER_TOO_MANY
	Teveel invoeren (%d) in Services operator lijst; kan niet
	meer toevoegen.
OPER_OPER_REMOVED
	%s verwijderd uit Services operator lijst.
OPER_OPER_NOT_FOUND
	%s niet gevonden in Services operator lijst.
OPER_OPER_LIST_HEADER
	Services operator lijst:

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW | COUNT} [[+vervaltijd] masker [rede]]
OPER_AKILL_ADD_SYNTAX
	AKILL ADD [+vervaltijd] masker rede
OPER_AKILL_DEL_SYNTAX
	AKILL DEL masker
OPER_TOO_MANY_AKILLS
	Autokill lijst is vol!
OPER_AKILL_EXISTS
	%s bestaat al in autokill list.
OPER_AKILL_NO_NICK
	Notice: Autokill maskers mogen geen bijnamen bevatten; Let
	op of u geen bijnaam in uw masker heeft gezet.
OPER_AKILL_MASK_TOO_GENERAL
	Het autokill masker is te algemeen.
OPER_AKILL_EXPIRY_LIMITED
	U mag geen vervaltijd opgeven groter dan %s.
OPER_AKILL_ADDED
	%s toegevoegd aan autokill lijst.
OPER_AKILL_REMOVED
	%s verwijderd uit autokill lijst.
OPER_AKILL_NOT_FOUND
	%s niet gevonden in autokill lijst.
OPER_AKILL_LIST_HEADER
	Huidige autokill lijst:
# mask, reason
OPER_AKILL_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_AKILL_VIEW_FORMAT
	%s (door %s op %s, laatst gebruikt %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_UNUSED_FORMAT
	%s (door %s op %s, nooit gebruikt; %s)
	    %s
OPER_AKILL_COUNT
	Er staan %d host maskers op de autokill lijst.

# AKILLCHAN responses
OPER_AKILLCHAN_SYNTAX
	AKILLCHAN [KILL] [+vervaltijd] kamer rede
OPER_AKILLCHAN_AKILLED
	%d gebruikers verwijderd met autokill.
OPER_AKILLCHAN_KILLED
	%d gebruikers verwijderd.
OPER_AKILLCHAN_AKILLED_ONE
	1 gebruiker verwijderd met autokill.
OPER_AKILLCHAN_KILLED_ONE
	1 gebruiker verwijderd.

# EXCLUDE responses
OPER_EXCLUDE_SYNTAX
	EXCLUDE {ADD | DEL | LIST | VIEW | COUNT} [[+vervaltijd] masker [rede]]
OPER_EXCLUDE_ADD_SYNTAX
	EXCLUDE ADD [+vervaltijd] masker rede
OPER_EXCLUDE_DEL_SYNTAX
	EXCLUDE DEL masker
OPER_TOO_MANY_EXCLUDES
	EXCLUDE lijst is vol!
OPER_EXCLUDE_EXISTS
	%s bestaat al in autokill uitzonderingen lijst.
OPER_EXCLUDE_ADDED
	%s toegevoegd aan autokill uitzonderingen lijst.
OPER_EXCLUDE_REMOVED
	%s verwijderd uit autokill uitzonderingen lijst.
OPER_EXCLUDE_NOT_FOUND
	%s niet gevonden in autokill uitzonderingen lijst.
OPER_EXCLUDE_LIST_HEADER
	Huidige autokill uitzonderingen lijst:
# mask, reason
OPER_EXCLUDE_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_EXCLUDE_VIEW_FORMAT
	%s (door %s op %s, laatst gebruikt %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_EXCLUDE_VIEW_UNUSED_FORMAT
	%s (door %s op %s, nooit gebruikt; %s)
	    %s
OPER_EXCLUDE_COUNT
	Er zijn %d host maskers in de autokill uitzonderingen lijst.

# SxLINE responses
OPER_SLINE_SYNTAX
	%s {ADD | DEL | LIST | VIEW | COUNT} [[+vervaltijd] masker [rede]]
OPER_SLINE_ADD_SYNTAX
	%s ADD [+vervaltijd] masker rede
OPER_SLINE_DEL_SYNTAX
	%s DEL masker
OPER_TOO_MANY_SLINES
	%s lijst is vol!
OPER_SLINE_EXISTS
	%s bestaat al in %s lijst.
OPER_SLINE_ADDED
	%s toegevoegd aan %s lijst.
OPER_SLINE_REMOVED
	%s verwijderd uit %s lijst.
OPER_SLINE_NOT_FOUND
	%s niet gevonden in %s lijst.
OPER_SLINE_LIST_HEADER
	Huidige %s lijst:
# mask, reason
OPER_SLINE_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, last-used, expires, reason
OPER_SLINE_VIEW_FORMAT
	%s (door %s op %s, laatst gebruikt %s; %s)
	    %s
# mask, set-by, set-time, expires, reason
OPER_SLINE_VIEW_UNUSED_FORMAT
	%s (door %s op %s, nooit gebruikt; %s)
	    %s
OPER_SLINE_COUNT
	Er zijn %d invoeren in de %s lijst.
OPER_SZLINE_NOT_AVAIL
	SZLINE is niet beschikbaar bij deze IRC server.

# SU responses
OPER_SU_SYNTAX
	SU wachtwoord
OPER_SU_NO_PASSWORD
	Het SU commando is onbeschikbaar omdat geen super-gebruiker
	wachtwoord is ingesteld.
OPER_SU_SUCCEEDED
	U heeft nu super-gebruiker rechten.
OPER_SU_FAILED
	Kon wachtwoord niet verifiren.

# SET responses
OPER_SET_SYNTAX
	SET optie instelling
OPER_SET_IGNORE_ON
	Negeer code wordt gebruikt.
OPER_SET_IGNORE_OFF
	Negeer code wordt niet gebruikt.
OPER_SET_IGNORE_ERROR
	Instelling voor IGNORE (negeer) moet ON (aan) of OFF
	(uit) zijn.
OPER_SET_READONLY_ON
	Services staat nu in alleen-lezen modus.
OPER_SET_READONLY_OFF
	Services staat nu in lees-schrijf modus.
OPER_SET_READONLY_ERROR
	Instelling voor READONLY (alleen-lezen) moet ON (aan)
	of OFF (uit) zijn.
OPER_SET_DEBUG_ON
	Services staat nu in debug modus.
OPER_SET_DEBUG_OFF
	Services staat nu in in non-debug modus.
OPER_SET_DEBUG_LEVEL
	Services staat nu in debug modus (level %d).
OPER_SET_DEBUG_ERROR
	Instelling voor DEBUG moet ON (aan), OFF (uit), of
	een positief getal zijn.
OPER_SET_SUPASS_FAILED
	 Kon Services super-gebruiker wachtwoord niet veranderen.
OPER_SET_SUPASS_OK
	Services super-gebruiker wachtwoord is veranderd.
OPER_SET_SUPASS_NONE
	Services super-gebruiker wachtwoord is uitgeschakeld.
OPER_SET_UNKNOWN_OPTION
	Onbekende optie %s.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE servernaam [rede]
OPER_JUPE_INVALID_NAME
	Ongeldige server naam (server namen dienen een punt te bevatten).
OPER_JUPE_ALREADY_JUPED
	Er bestaat al een jupe van server %s.

# RAW responses
OPER_RAW_SYNTAX
	RAW tekst

# UPDATE responses
OPER_UPDATE_SYNTAX
	UPDATE [FORCE]
OPER_UPDATE_FORCE_FAILED
	Kon databases niet vrijgeven.
OPER_UPDATING
	Database wordt geupdate...
OPER_UPDATE_COMPLETE
	Database update voltooid.
OPER_UPDATE_FAILED
	Database update mislukt.

# REHASH responses
OPER_REHASHING
	Configuratie instellingen worden opnieuw ingelezen.
OPER_REHASHED
	Alle configuratie instellingen zijn succesvol geupdate.
OPER_REHASH_ERROR
	Er is een fout opgetreden bij het opnieuw inlezen van de configuratie
	instellingen. Bekijk het Services log bestand voor details.

# LISTIGNORE responses
OPER_IGNORE_LIST
	Services negeer lijst:
OPER_IGNORE_LIST_EMPTY
	Negeer lijst is leeg.

# KILLCLONES responses
OPER_KILLCLONES_SYNTAX
	KILLCLONES bijnaam
OPER_KILLCLONES_UNKNOWN_NICK
	Kon gebruiker %s niet vinden.
OPER_KILLCLONES_KILLED
	%s gebruikte KILLCLONES op %s %d klonen worden verwijderd.
OPER_KILLCLONES_KILLED_AKILL
	%s gebruikte KILLCLONES op %s %d klonen worden verwijderd.
	Een tijdelijke AKILL is toegevoegd voor %s.

###########################################################################
#
# Session limiting and exception messages
#
###########################################################################

# EXCEPTION responses
OPER_EXCEPTION_SYNTAX
	EXCEPTION {ADD | DEL | MOVE | LIST | VIEW} [parameters]
OPER_EXCEPTION_ADD_SYNTAX
	EXCEPTION ADD [+vervaltijd] masker limiet rede
OPER_EXCEPTION_DEL_SYNTAX
	EXCEPTION DEL {masker | lijst}
OPER_EXCEPTION_MOVE_SYNTAX
	EXCEPTION MOVE num nieuwnum
OPER_EXCEPTION_ALREADY_PRESENT
	Masker %s staat al op uitzonderingslijst.
OPER_EXCEPTION_TOO_MANY
	Sessie-limiet uitzonderingslijst is vol!
OPER_EXCEPTION_ADDED
	Sessie limiet voor %s veranderd naar %d.
OPER_EXCEPTION_MOVED
	Uitzondering voor %s (#%d) veranderd naar nummer %d.
OPER_EXCEPTION_NO_SUCH_ENTRY
	Invoer (#%d) niet gevonden in sessie-limiet
	uitzonderingslijst.
OPER_EXCEPTION_NOT_FOUND
	%s niet gevonden in sessie-limiet uitzonderingslijst.
OPER_EXCEPTION_NO_MATCH
	Invoer niet gevonden in sessie-limiet uitzonderingslijst.
OPER_EXCEPTION_EMPTY
	Sessie-limiet uitzonderingslijst is leeg.
OPER_EXCEPTION_DELETED
	%s verwijderd uit sessie-limiet uitzonderingslijst.
OPER_EXCEPTION_DELETED_ONE
	1 invoer verwijderd uit sessie-limiet uitzonderingslijst.
OPER_EXCEPTION_DELETED_SEVERAL
	%d invoeren verwijderd uit sessie-limiet uitzonderingslijst.
OPER_EXCEPTION_LIST_HEADER
	Huidige sessie-limiet uitzonderingslijst:
# mask, limit
OPER_EXCEPTION_LIST_COLHEAD
	Num  Limiet  Host
OPER_EXCEPTION_LIST_FORMAT
	%3d  %4d   %s
# mask, set-by, set-time, expires, limit, reason
OPER_EXCEPTION_VIEW_FORMAT
	%3d.  %s  (by %s on %s; %s)
	    Limiet: %-4d  - %s
OPER_EXCEPTION_INVALID_LIMIT
	Ongeldige sessie limiet; Limiet moet minstens nul zijn en
	niet groter dan %d.
OPER_EXCEPTION_INVALID_HOSTMASK
	Ongeldig hostmasker. Alleen echte hostmaskers zijn geldig
	als uitzonderingen.

# SESSION responses
OPER_SESSION_SYNTAX
	SESSION {LIST limiet | VIEW host}
OPER_SESSION_LIST_SYNTAX
	SESSION LIST limiet
OPER_SESSION_VIEW_SYNTAX
	SESSION VIEW host
OPER_SESSION_INVALID_THRESHOLD
	Ongeldige drempelwaarde; Drempel dient een geheel getal te
	zijn groter dan 1.
OPER_SESSION_NOT_FOUND
	%s niet gevonden in sessie lijst.
OPER_SESSION_LIST_HEADER
	Hosts met minstens %d sessies:
OPER_SESSION_LIST_COLHEAD
	Sessies  Host
# limit, host
OPER_SESSION_LIST_FORMAT
	%6d    %s
# host, sessions, limit
OPER_SESSION_VIEW_FORMAT
	De host %s heeft momenteel %d sessies met een limiet van %d.


###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Inlog Nieuws - %s] %s
NEWS_OPER_TEXT
	[Oper Nieuws - %s] %s

NEWS_LOGON_SYNTAX
	LOGONNEWS {ADD | DEL | LIST} [tekst | num]
NEWS_LOGON_LIST_HEADER
	Inlog Nieuws punten:
NEWS_LOGON_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_LOGON_LIST_NONE
	Er is geen inlog nieuws.
NEWS_LOGON_ADD_SYNTAX
	LOGONNEWS ADD tekst
NEWS_LOGON_ADD_FULL
	Nieuws lijst is vol!
NEWS_LOGON_ADDED
	Nieuw inlog nieuws punt (#%d) toegevoegd.
NEWS_LOGON_DEL_SYNTAX
	LOGONNEWS DEL {num | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Inlog nieuws punt #%d niet gevonden!
NEWS_LOGON_DELETED
	Inlog nieuws punt #%d verwijderd.
NEWS_LOGON_DEL_NONE
	Geen inlog nieuws punten om te verwijderen!
NEWS_LOGON_DELETED_ALL
	Alle inlog nieuws punten zijn verwijderd.

NEWS_OPER_SYNTAX
	OPERNEWS {ADD | DEL | LIST} [tekst | num]
NEWS_OPER_LIST_HEADER
	Oper nieuws punten:
NEWS_OPER_LIST_ENTRY
	%5d (%s by %s)
	    %s
NEWS_OPER_LIST_NONE
	Er is geen oper nieuws.
NEWS_OPER_ADD_SYNTAX
	OPERNEWS ADD tekst
NEWS_OPER_ADD_FULL
	Nieuws lijst is vol!
NEWS_OPER_ADDED
	Nieuw oper nieuws punt (#%d) toegevoegd.
NEWS_OPER_DEL_SYNTAX
	OPERNEWS DEL {num | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Oper nieuws punt #%d niet gevonden!
NEWS_OPER_DELETED
	Oper nieuws punt #%d verwijderd.
NEWS_OPER_DEL_NONE
	Geen oper nieuws punten om te verwijderen!
NEWS_OPER_DELETED_ALL
	Alle oper nieuws punten zijn verwijderd.

NEWS_HELP_LOGON
	Syntax: LOGONNEWS ADD tekst
	        LOGONNEWS DEL {num | ALL}
	        LOGONNEWS LIST
	
	Toont of muteert de lijst van inlog nieuws berichten.
	Wanneer een gebruiker inlogt worden deze aan hem/haar
	getoond. (Let op, niet meer dan 3 berichten worden
	verstuurd om te voorkomen dat de gebruiker overladen wordt.
	Als er meer dan 3 berichten zijn worden alleen de 3 meest
	recente berichten gestuurd.)
	
	LOGONNEWS LIST kan gebruikt worden door elke IRC Operator
	voor een lijst van huidige berichten.  ADD and DEL kunnen
	alleen door Services operators gebruikt worden.

NEWS_HELP_OPER
	Syntax: OPERNEWS ADD tekst
	        OPERNEWS DEL {num | ALL}
	        OPERNEWS LIST
	
	Toont of muteert de lijst van oper nieuws berichten.
	Wanneer een gebruiker opert (/OPER) worden deze berichten
	naar hem/haar gestuurd. (Let op, niet meer dan 3 berichten
	worden verstuurd om te voorkomen dat de gebruiker overladen
	wordt. Als er meer dan 3 berichten zijn worden alleen de 3
	meest recente berichten gestuurd.)
	
	OPERNEWS LIST kan gebruikt worden door elke IRC Operator
	voor een lijst van huidige berichten.  ADD and DEL kunnen
	alleen door Services operators gebruikt worden.


###########################################################################
#
# StatServ messages
#
############################################################################

# General SERVERS responses
STAT_SERVERS_REMOVE_SERV_FIRST
	Server %s is online. Verwijder deze van het netwerk en
	probeer het nogmaals.
STAT_SERVERS_SERVER_EXISTS
	Server %s bestaat al.

# SERVERS command syntax
STAT_SERVERS_SYNTAX
	SERVERS optie parameters

# STATS responses
STAT_SERVERS_STATS_TOTAL
	Totaal aantal Servers: %2d
STAT_SERVERS_STATS_ON_OFFLINE
	       Online: %2d (%d%%)  Offline: %2d (%d%%)
STAT_SERVERS_LASTQUIT_WAS
	    Laatste vertrek: %-30s  %s

# LIST responses
STAT_SERVERS_LIST_HEADER
	Server Naam                   Gebruikers  Opers
STAT_SERVERS_LIST_FORMAT
	%-30s %3d (%2d%%)  %3d (%2d%%)
STAT_SERVERS_LIST_RESULTS
	Einde van de lijst -- %d/%d online servers getoond.

# VIEW responses
STAT_SERVERS_VIEW_HEADER_ONLINE
	%-30s  (online)
STAT_SERVERS_VIEW_HEADER_OFFLINE
	%-30s  (offline)
STAT_SERVERS_VIEW_LASTJOIN
	    Laatste komst: %s
STAT_SERVERS_VIEW_LASTQUIT
	    Laatste vertrek: %s
STAT_SERVERS_VIEW_QUITMSG
	 Vertrek bericht: %s
STAT_SERVERS_VIEW_USERS_OPERS
	        Gebruikers: %3d (%2d%%)  Opers: %3d (%2d%%)
STAT_SERVERS_VIEW_RESULTS
	Einde van de lijst -- %d/%d servers getoond.

# DELETE responses
STAT_SERVERS_DELETE_SYNTAX
	SERVERS DELETE server
STAT_SERVERS_DELETE_DONE
	Statistieken van server %s zijn verwijderd.

# COPY responses
STAT_SERVERS_COPY_SYNTAX
	SERVERS COPY server nieuwenaam
STAT_SERVERS_COPY_DONE
	Statistieken van server %s gekopierd naar %s.

# RENAME responses
STAT_SERVERS_RENAME_SYNTAX
	SERVERS RENAME server nieuwename
STAT_SERVERS_RENAME_DONE
	Statistieken van server %s hernoemd naar %s.

# USERS command syntax
STAT_USERS_SYNTAX
	USERS STATS
STAT_USERS_TOTUSERS
	              Totaal aantal gebruikers: %d
STAT_USERS_TOTOPERS
	               Totaal aantal operators: %d
STAT_USERS_SERVUSERS
	Gemiddeld aantal gebruikers per server: %d
STAT_USERS_SERVOPERS
	 Gemiddeld aantal operators per server: %d.%d


###########################################################################
#
# NickServ help messages
#
###########################################################################

NICK_HELP
	%S geeft u de mogelijkheid een bijnaam te "registreren"
	zodat anderen deze niet kunnen gebruiken.  %S wordt bediend
	door middel van verschillende commando's die registratie
	en bijhouden van bijnamen mogelijk maken.  Voor een lijst van
	commando's, typ /msg %S HELP COMMANDS; om een commando
	te gebruiken, typ /msg %S commando, en voor meer
	informatie over een bepaald commando, typ
	/msg %S HELP commando.

NICK_HELP_EXPIRES
	
	Wanneer een geregistreerde bijnaam langer dan %s niet gebruikt
	wordt vervalt de registratie en is de bijnaam weer vrij voor
	gebruik voor iedereen.

NICK_HELP_WARNING
	
	OPMERKING: Deze service is bedoeld om IRC gebruikers de
	mogelijkheid te geven te zorgen dat hun identiteit niet in
	twijfel wordt gebracht. Het is NIET bedoeld voor het "stelen"
	van bijnamen of andere kwaadaardige doelen. Misbruik van %S
	zorgt, op zijn minst, voor verlies van de misbruikte
	bijna(a)m(en).

NICK_HELP_COMMANDS
	De volgende commando's kunnen gebruikt worden met %S:
	
	    REGISTER   Registreer een bijnaam
NICK_HELP_COMMANDS_AUTH
	    AUTH       Authenticeer een bijnaam registratie
	    SENDAUTH   Stuur uzelf de bijnaam authenticatie code
NICK_HELP_COMMANDS_IDENTIFY
	    IDENTIFY   Identificeer uzelf met uw wachtwoord
NICK_HELP_COMMANDS_SENDPASS
	    SENDPASS   Stuur uw wachtwoord naar uw E-mail adres
NICK_HELP_COMMANDS_DROP
	    DROP       Maak de registratie van een bijnaam ongedaan
NICK_HELP_COMMANDS_LINK
	    LINK       Koppel een andere bijnaam aan uw eigen bijnaam
	    UNLINK     Maak een koppeling ongedaan
	    LISTLINKS  Toon all uw gekoppelde bijnamen
NICK_HELP_COMMANDS_OLDLINK
	    LINK       Maak van uw bijnaam een alias voor een andere
	                 bijnaam
	    UNLINK     Maak een koppeling van uw bijnaam ongedaan
NICK_HELP_COMMANDS_ACCESS
	    ACCESS     Verander de lijst van toegestane adressen
NICK_HELP_COMMANDS_AJOIN
	    AJOIN      Bewerk uw autojoin lijst
NICK_HELP_COMMANDS_SET
	    SET        Verander opties, bijvoorbeeld kill protectie
	    UNSET      Verwijder bijnaam informatie
	    RECOVER    Verwijder een gebruiker die uw bijnaam gebruikt
	    RELEASE    Verkrijg beschikking over uw bijnaam na RECOVER
	    GHOST      Verwijder een "spook" sessie
	    INFO       Geef informatie over een bijnaam
NICK_HELP_COMMANDS_LIST
	    LIST       Geef een lijst van alle bijnamen met een bepaald
	                 masker
	    LISTEMAIL  Geef een lijst van alle bijnamen met een bepaald
	                 E-mail adres
NICK_HELP_COMMANDS_LISTCHANS
	    LISTCHANS  Geef een lijst van al uw kamers
	    STATUS     Bekijk of er voor een bijnaam is geidentificeerd

NICK_HELP_REGISTER
	Syntax: %s
	
	Registreerd uw bijnaam in de %S database.  Wanneer
	uw bijnaam is geregistreerd kan u met de SET en
	ACCESS commando's instellingen van uw bijnaam veranderen.
	Let op dat u het wachtwoord waarmee u geregistreerd heeft
	niet vergeet - u heeft deze nog nodig later.
	(Let op dat type letters uitmaakt!  FIDO, Fido, en
	fido zijn allen verschillende wachtwoorden!)
NICK_HELP_REGISTER_EMAIL
	
	U mag een E-mail adres invoeren bij het registreren;
	dit kan ook naderhand door middel van het SET EMAIL
	commando.
NICK_HELP_REGISTER_EMAIL_REQ
	
	U MOET een E-mail adres invoeren bij het registreren;
	u kunt deze verbergen doormiddel van het HIDE commando
	(typ /msg %S HELP SET HIDE voor meer informatie).
NICK_HELP_REGISTER_EMAIL_AUTH
	
	U moet een geldig e-mail adres invoeren bij het
	registreren van uw bijnaam; %S stuurt een bericht met een
	authenticatie code naar dit adres, welke u moet gebruiken met
	het AUTH om uw registratie te voltooien. U kunt uw e-mail
	adres verbergen voor andere gebruikers met het SET HIDE
	commando (typ /msg %S HELP SET HIDE voor meer informatie).
NICK_HELP_REGISTER_END
	
	Regels voor het kiezen van een wachtwoord:
	
	Wachtwoorden moeten niet makkelijk te raden zijn.
	Uw echte naam als wachtwoord nemen is bijvoorbeeld een
	slecht idee.  Uw bijnaam als wachtwoord is nog slechter ;)
	en %S zal dat ook niet toestaan.  Korte wachtwoorden zijn
	gevaarlijk als iemand zomaar wat probeerd, daarom dient
	uw wachtwoord minimaal 5 tekens te zijn.

NICK_HELP_AUTH
	Syntax: AUTH code
	
	Authenticeert registratie of verandering van E-mail van een
	bijnaam. Om er zeker van te zijn dat uw E-mail adres correct
	is stuurt %S een bericht met een authenticatie code naar het
	E-mail adres gegeven wanneer u uw bijnaam registreert of uw
	E-mail adres verandert met het SET EMAIL commando. Dit
	commando geeft u de mogelijkheid te bevestigen dat u het
	bericht heeft ontvangen en uw bijnaam verder normaal te
	gebruiken.  Vervang code in het commando met de 9 karakters
	lange authenticatie code, gegeven in het E-mail bericht.

NICK_HELP_SENDAUTH
	Syntax: SENDAUTH
	
	Stuurt u een kopie van de authenticatie code voor uw bijnaam
	na gebruik van REGISTER of SET EMAIL.  Wanneer u per ongeluk
	het bericht met de authenticatie code verwijdert of verliest
	kunt u dit commando gebruiken om een nieuwe kopie naar u te
	verzenden.
	
	Om misbruik te voorkomen kan dit commando slechts eenmaal
	per 24 uur gebruikt worden.

NICK_HELP_SENDPASS
	Syntax: SENDPASS bijnaam
	
	Stuur u een E-mail bericht met het wachtwoord van de gegeven
	bijnaam naar het E-mail adres van de bijnaam.
	Het E-mail adres dient bevestigd te zijn met het AUTH commando.

NICK_HELP_IDENTIFY
	Syntax: IDENTIFY wachtwoord
	
	Verteld %S dat u werkelijk de eigenaar bent van uw
	bijnaam.  Veel commando's kunnen pas gebruikt worden
	nadat u zich geindentificeerd heeft.  Het wachtwoord
	is de zelfde die u gebruikt heeft bij het REGISTER
	commando.

NICK_HELP_DROP
	Syntax: DROP wachtwoord
	
	Verwijdert uw bijnaam uit de %S database.  Een bijnaam
	die verwijderd is kan door iedereen geregistreerd worden.
NICK_HELP_DROP_LINK
	
	Let op dat wanneer u een bijnaam verwijdert alle bijnamen die
	er aan gekoppeld zijn ook verwijderd worden.  Om slechts een
	gekoppelde bijnaam te verwijderen dient u het UNLINK commando
	te gebruiken.
NICK_HELP_DROP_END
	
	Om te zorgen dat dit commando niet per ongeluk gebruikt wordt
	dient u uw wachtwoord te geven om uw bijnaam te verwijderen.

NICK_HELP_OLD_LINK
	Syntax: LINK bijnaam wachtwoord
	
	Koppelt uw bijnaam aan een andere waardoor de bijnaam die
	u op dat moment gebruikt een alias wordt voor de gegeven
	bijnaam.  Wanneer u dit commando geeft wordt de
	toegangslijst van uw huidige bijnaam verwijderd en vervangen
	door de bijnaam die u koppelt; alle memo's van uw huidige
	bijnaam worden aan de lijst van de andere naam toegevoegd
	(hierdoor kan de bijnaam teveel memo's hebben, in dat geval
	dient u er een aantal te verwijderen om meer memo's te
	kunnen ontvangen met beide bijnamen).
	
	Wanneer de bijnamen gekoppeld zijn wordt uw bijnaam
	onzichtbaar veranderd naar de andere bijnaam in Services,
	behalve voor het %S UNLINK commando.  U kunt
	bijvoorbeeld beide bijnamen gebruiken om dezelfde memo's te
	lezen (en memo's voor beide bijnamen komen in dezelfde
	lijst).
	Als een van de bijnamen op een kamer toegangslijst staat
	krijgen beide bijnamen dezelfde rechten.  Let op, de
	bijnamen vervallen onafhankelijk; wanneer u slechts 1 van
	de gekoppelde bijnamen gebruikt vervallen alle anderen.
	
	Om dit commando te gebruiken dient u te identificeren voor
	uw huidige bijnaam (d.m.v. het IDENTIFY commando) en u
	dient het wachtwoord voor de bijnaam waaraan u wilt koppelen
	te geven.

NICK_HELP_LINK
	Syntax: LINK bijnaam
	
	Koppelt een nieuwe bijnaam aan de bijnaam die u momenteel gebruikt
	en maakt daarmee een nieuwe "alias" voor uw bijnaam.
	De nieuwe bijnaam zal gelijkwaardig zijn aan uw oude bijnaam op het
	gebied van toegangsrechten en memo's.
	U kunt bijvoorbeeld memo's die naar de ene bijnaam verstuurd zijn
	lezen met de andere bijnaam, en wanneer een van uw bijnamen
	auto-op rechten heeft in een kamer, krijgt u automatisch operator
	status welke gekoppelde bijnaam u ook gebruikt.
	
	Om een koppeling ongedaan te maken gebruikt u het UNLINK commando.
	
	Om dit commando te kunnen gebruiken dient u zich te
	identificeren voor uw huidige bijnaam (door middel van het
	IDENTIFY commando), en de te linken bijnaam dient niet in gebruik
	te zijn.

NICK_HELP_OLD_UNLINK
	Syntax: UNLINK [bijnaam wachtwoord]
	
	Verwijdert de koppeling tussen 2 bijnamen.  Wanneer de
	koppeling verwijderd is kunnen bijnaam opties en
	toegangslijsten onafhankelijk veranderd worden.  Memo's
	worden niet naar uw huidige bijnaam gekopieerd; deze blijven
	allemaal bij de voorheen gekoppelde bijnaam.
	
	Wanneer een bijnaam en wachtwoord als parameters gegeven
	worden kan een andere bijnaam dan uw huidige ontkoppeld
	worden.

NICK_HELP_UNLINK
	Syntax: UNLINK bijnaam
	
	Verwijdert een koppeling (alias) van uw bijnaam gemaakt met het
	LINK commando. U kan de koppeling van de bijnaam die u momenteel
	gebruikt niet verwijderen; verander uw bijnaam naar een andere
	gekoppelde bijnaam voordat u dit commando gebruikt.
	
	Wanneer u de link met de "hoofd bijnaam" die u geselecteerd heeft
	met het SET MAINNICK commando verwijderd, wordt uw huidige bijnaam
	automatisch ingesteld als hoofd bijnaam.

NICK_HELP_LISTLINKS
	Syntax: LISTLINKS
	
	Geeft een lijst van alle bijnamen die aan uw bijnaam gekoppeld
	zijn.  De hoofd bijnaam van de groep van bijnamen wordt aangegeven
	met een "*" aan de linkerkant van de bijnaam.

NICK_HELP_ACCESS
	Syntax: ACCESS ADD masker
	        ACCESS DEL masker
	        ACCESS LIST
	
	Verandert of toont de toegangslijst van uw bijnaam.  Dit
	is de lijst met gebruiker@host adressen die %S automatisch
	toestaat om uw bijnaam te gebruiken.  Wanneer u inlogt op IRC
	via een adres op deze lijst wordt u niet gehinderd door de
	SET KILL instelling van de bijnaam, en wanneer de SECURE optie
	uit staat krijgt u automatische operator status en andere
	rechten zonder het IDENTIFY commando te hoeven gebruiken.
	
	Het masker dat meegegeven wordt met de ADD en DEL commando's
	mag de tekens * en ? bevatten.
	
	Voorbeelden:
	
	    ACCESS ADD achurch@*.dragonfire.net
	        Geeft toegang aan gebruiker achurch vanaf elke
	        machine in het dragonfire.net domein.
	
	    ACCESS DEL achurch@*.dragonfire.net
	        Verwijdert de vorige toevoeging.
	
	    ACCESS LIST
	        Toont de huidige toegangslijst.

NICK_HELP_SET
	Syntax: SET optie parameters
	
	Verandert verschillende bijnaam opties.  optie kan zijn:
	
	    PASSWORD   Verander uw bijnaam wachtwoord
	    LANGUAGE   Verander de taal waarin Services u berichten
	                   stuurt
	    URL        Associeer een pagina met uw bijnaam
	    EMAIL      Associeer een E-mail adres met uw bijnaam
	    INFO       Verander de tekst die getoond wordt met het
	                   INFO commando
	    KILL       Zet kill protectie aan of uit
	    SECURE     Zet bijnaam beveiliging aan of uit
	    PRIVATE    Zorg dat uw bijnaam niet voorkomt in een
	                   /msg %S LIST
	    HIDE       Verberg bepaalde bijnaam informatie
	    TIMEZONE   Verander de tijdzone die gebruikt wordt voor
	                   weergave van tijden.
NICK_HELP_SET_OPTION_MAINNICK
	    MAINNICK   Stelt de bijnaam in die getoond wordt in kamer
	                   toegangslijsten.
NICK_HELP_SET_END
	
	Om dit commando te kunnen gebruiken dient u zich eerst te
	identificeren met uw wachtwoord (/msg %S HELP IDENTIFY
	voor meer informatie).
	
	Typ /msg %S HELP SET optie voor meer informatie over een
	specifieke optie.

NICK_HELP_SET_PASSWORD
	Syntax: SET PASSWORD nieuw-wachtwoord
	
	Verandert het wachtwoord waarmee u zich identificeerd als
	de eigenaar van uw bijnaam.

NICK_HELP_SET_LANGUAGE
	Syntax: SET LANGUAGE nummer
	
	Verandert de taal waarin Services berichten naar u stuurt
	(bijvoorbeeld als antwoord op een commando dat u geeft).
	nummer moet 1 van de volgende punten zijn:
	

NICK_HELP_SET_URL
	Syntax: SET URL pagina
	
	Associeerd de gegeven pagina met uw bijnaam.  Deze pagina
	wordt getoond wanneer iemand informatie opvraagd over uw
	bijnaam met het INFO commando.

NICK_HELP_SET_EMAIL
	Syntax: SET EMAIL adres
	
	Associeerd het gegeven E-mail adres met uw bijnaam.  Dit
	adres wordt getoond wanneer iemand informatie opvraagd over
	uw bijnaam met het INFO commando.

NICK_HELP_SET_INFO
	Syntax: SET INFO tekst
	
	Associeert de gegeven tekst met uw bijnaam; deze zal getoond
	worden wanneer iemand informatie over uw bijnaam opvraagt met
	het INFO commando.

NICK_HELP_SET_KILL
	Syntax: SET KILL {ON | QUICK | IMMED | OFF}
	
	Zet de automatische kill protectie voor uw bijnaam aan of
	uit.
	Wanneer kill protectie aanstaat krijgt iemand die uw bijnaam
	wil gebruiken 60 seconden de tijd om te identificeren.  Doet
	hij/zij dit niet dan wordt de persoon verwijderd van het IRC
	netwerk door %S.
	
	Als u QUICK selecteerd krijgt de gebruiker slechts 20
	seconden de tijd.  Wanneer u IMMED selecteerd wordt de
	gebruiker meteen verwijderd van het netwerk zonder kans
	te krijgen om zijn/haar bijnaam te veranderen; gebruik
	deze optie alleen in geval van nood.  Uw netwerk
	administrators kunnen deze optie uitgeschakeld hebben.

NICK_HELP_SET_SECURE
	Syntax: SET SECURE {ON | OFF}
	
	Zet %S's beveiligings optie aan voor uw bijnaam.  Wanneer
	SECURE aanstaat dient u zich met uw wachtwoord te
	identificeren voor uw bijnaam of uw adres nu op de toegangs-
	lijst van de bijnaam staat of niet. Let op, wanneer uw adres
	op de toegangslijst van de bijnaam staat zal kill protectie
	niet in werking treden, ook al heeft u deze aan gezet met
	de KILL optie.

NICK_HELP_SET_PRIVATE
	Syntax: SET PRIVATE {ON | OFF}
	
	Zet de %S priv optie aan of uit voor uw bijnaam. Wanneer
	PRIVATE aan staat zal uw bijnaam niet getoond worden in
	een %S LIST. (Let op, iemand die uw bijnaam weet kan nog
	steeds informatie over u verkrijgen met het INFO commando.)

NICK_HELP_SET_HIDE
	Syntax: SET HIDE {EMAIL | USERMASK | QUIT} {ON | OFF}
	
	Voorkomt dat bepaalde informatie over u getoond wordt
	wanneer iemand %S INFO van uw bijnaam opvraagd. U kunt uw
	E-mail adres (EMAIL), laatst gebruikte user@host masker
	(USERMASK) en laatste vertrek boodschap (QUIT) verbergen.
	De tweede parameter geeft aan of de informatie verborgen
	(ON) of niet (OFF) moet worden.

NICK_HELP_SET_TIMEZONE
	Syntax: SET TIMEZONE {UTC-verschil | tijdzone | DEFAULT}
	
	Verandert de tijdzone waarin tijden weergegeven worden (zoals
	laatst gebruikte tijd van een kamer of bijnaam), in plaats van
	de tijdzone waarin Services werkt te gebruiken; De DEFAULT
	waarde kan gebruikt worden om de tijdzone van Services weer te
	geven. De tijdzone kan opgegeven worden op 2 manieren:
	
	   - Als een UTC verschil, het tijdsverschil tussen uw lokale
	     tijd en UTC (Universal Coordinated Time, ookwel bekend als
	     GMT, Greenwich Mean Time).  Het verschil wordt gegeven als
	     "+" of "-" om aan te geven of het om voor (ten oosten) of
	     na (ten westen) van UTC gaat, gevolgd door een geheel aantal
	     uur of een regel in de vorm "hh:mm".
	
	   - Als een tijdzone naam, zoals "GMT" of "EDT". Niet alle
	     tijdzone namen worden ondersteund door Services, en tijdzone
	     namen van sommige landen zijn hetzelfde, dus wanneer u een
	     foutmelding krijgt of wanneer de weergegeven tijd fout is
	     dient u een UTC verschil te gebruiken.
	
	Let op dat Services niet automatisch zomertijd/wintertijd aanpast;
	u dient de tijdzone handmatig te veranderen.
	
	Voorbeelden:
	
	    SET TIMEZONE -5
	        Stelt de tijdzone in op 5 uur na UTC.
	
	    SET TIMEZONE +3:30
	        Stelt de tijdzone in op 3 uur en 30 minuten voor UTC.
	
	    SET TIMEZONE JST
	        Stelt de tijdzone in op Japan Standard Time (UTC+9:00).

NICK_HELP_SET_MAINNICK
	Syntax: SET MAINNICK bijnaam
	
	Wanneer u meerdere bijnaam aan elkaar gekoppeld heeft, geeft dit
	commando u de mogelijkheid de bijnaam te selecteren die wordt
	weergegeven in kamer toegangslijsten.  Wanneer u de koppeling van
	deze bijnaam ongedaan maakt zal er automatisch een andere bijnaam
	geselecteerd worden.

NICK_HELP_UNSET
	Syntax: UNSET {URL | EMAIL | INFO}
	
	Geeft u de mogelijkheid om de pagina (URL), E-mail adres
	(EMAIL), of informatie tekst (INFO) van uw bijnaam te
	verwijderen.

NICK_HELP_UNSET_REQ_EMAIL
	Syntax: UNSET (URL | INFO)
	
	Geeft u de mogelijkheid de pagina (URL) of informatie tekst
	(INFO) van uw bijnaam te verwijderen.

NICK_HELP_RECOVER
	Syntax: RECOVER bijnaam [wachtwoord]
	
	Geeft u de mogelijkheid uw bijnaam te heroveren als iemand
	anders hem gebruikt; Dit doet hetzelfde als %S automatisch
	doet als iemand een bijnaam probeert te gebruiken waarbij
	kill protectie aan staat.
	
	Wanneer het commando gegeven wordt brengt %S een nep
	gebruiker online met de bijnaam die heroverd wordt. Dit
	zorgt ervoor dat de IRC server de andere gebruiker
	verwijdert van het netwerk.  De nep gebruiker blijft %s
	online om te zorgen dat de andere gebruiker niet meteen weer
	terugkomt; daarna kunt u uw bijnaam weer gebruiken.
	Als u de bijnaam eerder wilt gebruiken kan dat met het
	RELEASE commando (/msg %S HELP RELEASE).
	
	Om het RECOVER commando te gebruiken dient uw huidige
	adres (zoals vermeld in /WHOIS) in de toegangslijst van de
	bijnaam te staan of dient u het wachtwoord van de bijnaam
	te geven.

NICK_HELP_RELEASE
	Syntax: RELEASE bijnaam [wachtwoord]
	
	Geeft %S opdracht om een bijnaam die vastgehouden wordt
	door kill protectie of gebruik van RECOVER los te laten.
	Normaal wordt een bijnaam %s vastgehouden; dit
	commando zorgt dat dit korter duurt.
	
	Om het RELEASE commando te gebruiken dient uw huidige
	adres (zoals vermeld in /WHOIS) in de toegangslijst van de
	bijnaam te staan of dient u het wachtwoord van de bijnaam te
	geven.

NICK_HELP_GHOST
	Syntax: GHOST nickname [password]
	
	Verwijdert een "spook" met uw bijnaam.  Een "spook" sessie
	is een gebruiker die niet werkelijk aanwezig is, maar
	waarvan de server denkt dat deze nog online is voor 1 of
	andere reden. Mogelijke oorzaak kan een computercrash
	of modemstoring zijn.
	
	Om het GHOST commando te gebruiken dient uw huidige adres
	(zoals vermeld in /WHOIS) in de toegangslijst van de bijnaam
	te staan of dient u het wachtwoord van de bijnaam te geven.

NICK_HELP_INFO
	Syntax: INFO bijnaam [ALL]
	
	Geeft informatie over de gegeven bijnaam, zoals eigenaar,
	laatst geziene hostmask en tijd en bijnaam opties. Als u
	geidentificeerd bent voor de bijnaam en de optie ALL
	meegeeft, wordt alle informatie getoond, of deze nu
	verborgen is of niet.
NICK_HELP_INFO_AUTH
	
	Wanneer het E-mail adres van de bijnaam nog niet bevestigd
	is met het AUTH commando wordt het alleen getoond aan de
	eigenaar van de bijnaam en aan Services Administrators,
	Ongeacht de instelling van SET HIDE EMAIL.

NICK_HELP_LISTCHANS
	Syntax: LISTCHANS
	
	Geeft een lijst van de kamers die geregistreerd zijn onder
	uw bijnaam.

NICK_HELP_LIST
	Syntax: LIST patroon
	
	Geeft een lijst van alle bijnamen waarvan ofwel de bijnaam
	zelf, of wel het laatst geziene adres (in de vorm
	gebruiker@host) overeenkomt met het gegeven patroon.
	Bijnamen met de PRIVATE optie aan worden niet getoont.
	
	Voorbeelden:
	
	    LIST joeuser@foo.com
	        Geeft alle geregistreerde bijnamen die het laatst gebruikt zijn door joeuser@foo.com.
	
	    LIST *Bot*
	        Geeft alle geregistreerde bijnamen met Bot in de naam (hoofd of kleine letters).
	
	    LIST *@*.bar.org
	        Geeft alle geregistreerde bijnamen die het laatst gebruikt zijn in het bar.org domein.
NICK_HELP_LIST_OPERSONLY
	
	Alleen IRC Operators kunnen dit commando gebruiken.

NICK_HELP_LISTEMAIL
	Syntax: LISTEMAIL patroon
	
	Geeft een lijst van geregistreerde bijnamen, zoals het LIST
	commando, maar zoekt op E-mail addressen in plaats van
	gebruiker@host adressen.
	Zie de help van het LIST commando (/msg %S HELP LIST) voor
	meer informatie.

NICK_HELP_STATUS
	Syntax: STATUS bijnaam...
	
	Verteld of de gebruiker van de bijnaam op dat moment de
	eigenaar van die bijnaam is.  Dit in de volgende vorm:
	
	    bijnaam status-code
	
	Waar bijnaam de gegeven bijnaam is en status-code
	n van de volgende:
	
	    0 - Gebruiker niet online of bijnaam niet geregistreerd
	    1 - Gebruiker niet herkend als eigenaar van de bijnaam
	    2 - Gebruiker alleen herkend via toegangslijst
	    3 - Gebruiker herkend door wachtwoord identificatie
	
	Maximaal 16 bijnamen mogen gegeven worden met dit commando;
	de rest wordt genegeerd. Er wordt geen error gegeven als
	geen bijnaam gegeven is.

NICK_HELP_AJOIN
	Syntax: AJOIN ADD kamer
	        AJOIN DEL kamer
	        AJOIN LIST
	
	Verandert of toont de autojoin lijst van uw bijnaam.  Dit
	is de lijst van kamers die u automatisch binnengaat, en treedt
	in werking wanneer u zich identificeert bij %S. U kunt alleen
	kamers die beginnen met "#" in de autojoin lijst plaatsen
	(lokale kamers kunnen niet toegevoegd worden).
	
NICK_HELP_AJOIN_END
	Let op dat de IRC server u kan verbieden sommige kamers
	uit de autojoin lijst binnen te gaan, zoals kamers die een sleutel
	hebben (mode +k), of die uitnodiging vereisen (mode +i).
NICK_HELP_AJOIN_END_CHANSERV
	Let op dat de IRC server u kan verbieden sommige kamers
	uit de autojoin lijst binnen te gaan, zoals kamers die een sleutel
	hebben (mode +k), of die uitnodiging vereisen (mode +i).
	Echter, wanneer u toegang heeft tot het %s INVITE commando
	in een geregistreerde kamer, zal %S u automatisch uitnodigen
	in de kamer.

NICK_OPER_HELP_COMMANDS
	
	De volgende commando's zijn beschikbaar voor Services admins:
	
	    DROPNICK    Verwijder een bijnaam
NICK_OPER_HELP_COMMANDS_DROPEMAIL
	    DROPEMAIL   Verwijder alle bijnamen die overeenkomen met
	                    een E-mail adres
NICK_OPER_HELP_COMMANDS_GETPASS
	    GETPASS     Verkrijg het wachtwoord van een bijnaam
	                    (alleen als versleuteling uitstaat)
NICK_OPER_HELP_COMMANDS_FORBID
	    FORBID      Zorg dat een bijnaam niet gebruikt kan worden
	    SUSPEND     Zorg dat voor een bijnaam niet geindentificeerd
	                kan worden
	    UNSUSPEND   Maak SUSPEND ongedaan
NICK_OPER_HELP_COMMANDS_LISTLINKS
	    LISTLINKS   Geef een lijst van bijnamen gekoppeld aan de gegeven
	                bijnaam
NICK_OPER_HELP_COMMANDS_SETAUTH
	    SETAUTH    Stelt een nieuwe authenticatie code in voor een bijnaam
	    GETAUTH    Toont de authenticatie code van een bijnaam
	    CLEARAUTH  Verwijderd de authenticatie code van een bijnaam
NICK_OPER_HELP_COMMANDS_END
	
	Services admins kunnen ook de volgende commando's voor een
	bijnaam gebruiken zonder hiervoor te hoeven identificeren:
	
	    SET, ACCESS LIST, INFO ALL
	
	Voor details, zie de help van de verschillende commando's.

NICK_OPER_HELP_DROPNICK
	Syntax: DROPNICK [bijnaam]
	
	Verwijdert de gegeven bijnaam uit de %S database, evenals alle
	gekoppelde bijnamen.
	
	Gebruik beperkt tot Services admins.

NICK_OPER_HELP_DROPEMAIL
	Syntax: DROPEMAIL patroon
	        DROPEMAIL-CONFIRM patroon
	
	Verwijdert alle bijnamen waarvan het E-mail adres
	overeenkomt met het gegeven patroon.  Wanneer patroon
	slechts bestaat uit het karakter "-", worden alle bijnamen
	zonder E-mail adres verwijdert.
	
	Om te voorkomen dat bijnamen per ongeluk verwijdert worden
	met dit commando dient het tweemaal gegeven te worden: eerst
	middels het DROPEMAIL commando, daarna met DROPEMAIL-CONFIRM
	en hetzelfde patroon.  Het DROPEMAIL-CONFIRM commando moet
	binnen %s na het DROPEMAIL commando door dezelfde
	persoon gegeven worden.  Wanneer meer dan 4 DROPEMAIL
	commando's na elkaar gegeven worden zal de oudste worden
	vergeten en niet langer worden herkent voor een
	DROPEMAIL-CONFIRM commando.
	
	Gebruik beperkt tot Services admins.

NICK_OPER_HELP_SET
	
	Services admins kunnen ook de optie NOEXPIRE gebruiken,
	waarmee voorkomen kan worden dat bijnamen vervallen.
	Ook kunnen Services Admins opties veranderen voor elke
	bijnaam zonder wachtwoord op de volgende manier:
	SET bijnaam optie parameters.

NICK_OPER_HELP_SET_NOEXPIRE
	Syntax: SET [bijnaam] NOEXPIRE {ON | OFF}
	
	Stelt in of een bijnaam vervalt of niet. ON zorgt dat de
	bijnaam niet vervalt.  Als geen bijnaam gegeven is wordt de
	instelling toegepast op uw eigen bijnaam.
	
	Beperkt tot Services admins.

NICK_OPER_HELP_UNSET
	
	Services admins mogen het UNSET commando voor elke bijnaam
	gebruiken op dezelfde manier als bij het SET commando.

NICK_OPER_HELP_OLD_UNLINK
	
	Services admins kunnen elke bijnaam koppeling ongedaan maken
	zonder wachtwoord.

NICK_OPER_HELP_UNLINK
	Syntax: UNLINK bijnaam [FORCE]
	
	Verwijdert een koppeling (alias) van uw bijnaam gemaakt met
	het LINK commando. U kunt de bijnaam die u momenteel gebruikt
	niet ontkoppelen; verander uw bijnaam naar een andere gekoppelde
	bijnaam voordat u dit commando gebruikt.
	
	Wanneer u de link met de "hoofd bijnaam" die u geselecteerd heeft
	met het SET MAINNICK commando verwijderd, wordt uw huidige bijnaam
	automatisch ingesteld als hoofd bijnaam.
	
	Services admins kunnen de FORCE optie meegeven, hiermee kan een
	koppeling van een bijnaam van iemand anders ongedaan worden
	gemaakt.

NICK_OPER_HELP_OLD_LISTLINKS
	Syntax: LISTLINKS bijnaam
	
	Geeft een lijst van bijnamen die aan de gegeven bijnaam
	gekoppeld zijn.
	
	Beperkt tot Services admins.

NICK_OPER_HELP_LISTLINKS
	Syntax: LISTLINKS [bijnaam]
	
	Geeft een lijst van alle bijnamen die aan uw bijnaam gekoppeld
	zijn.  De hoofd bijnaam van de groep van bijnamen wordt aangegeven
	met een "*" aan de linkerkant van de bijnaam.  Services admins
	kunnen lijsten met gelinkte bijnamen bekijken voor elke bijnaam
	door de bijnaam mee te geven in het commando.

NICK_OPER_HELP_ACCESS
	
	Services Admins kunnen een bijnaam parameter meegeven aan
	het LIST commando om de toegangslijst voor elke bijnaam te
	bekijken.

NICK_OPER_HELP_INFO
	
	Services Admins kunnen de parameter ALL gebruiken bij elke
	bijnaam.

NICK_OPER_HELP_LISTCHANS
	
	Services Admins kunnen een lijst opvragen van elke bijnaam
	door een bijnaam mee te geven (bijvoorbeeld, /msg %S
	LISTCHANS AndereBijnaam).

NICK_OPER_HELP_LIST
	Syntax: LIST patroon [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Geeft een lijst van alle bijnamen waarvan ofwel de bijnaam
	zelf, of wel het laatst geziene adres (in de vorm
	gebruiker@host) overeenkomt met het gegeven patroon.
	Bijnamen met de PRIVATE optie aan worden alleen getoond aan
	Services Admins. Voor Services Admins worden bijnamen die op
	NOEXPIRE staan aangeduidt met een ! en bijnamen die buiten
	gebruik zijn met een *.
	
	Als de optie FORBIDDEN, SUSPENDED of NOEXPIRE gegeven
	is, worden alleen corresponderende bijnamen getoond. De
	opties kunnen gebruikt worden in elke volgorde of combinatie en zijn alleen
	beschikbaar voor Services admins.
	
	Voorbeelden:
	
	    LIST joeuser@foo.com
	        Geeft alle geregistreerde bijnamen die het laatst gebruikt zijn door joeuser@foo.com.
	
	    LIST *Bot*
	        Geeft alle geregistreerde bijnamen met Bot in de naam (hoofd of kleine letters).
	
	    LIST * NOEXPIRE
	        Geeft alle geregistreerde bijnamen die op NOEXPIRE staan.

NICK_OPER_HELP_LIST_AUTH
	Syntax: LIST patroon [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
	
	Geeft een lijst van alle bijnamen waarvan ofwel de bijnaam
	zelf, of wel het laatst geziene adres (in de vorm
	gebruiker@host) overeenkomt met het gegeven patroon.
	Bijnamen met de PRIVATE optie aan worden alleen getoond aan
	Services Admins. Voor Services Admins worden bijnamen die op
	NOEXPIRE staan aangeduidt met een ! en bijnamen die buiten
	gebruik zijn met een *, en bijnamen die nog niet geauthenticeerd
	zijn (met het AUTH commando) worden aangeduid met een ?.
	
	Als de optie FORBIDDEN, SUSPENDED, NOEXPIRE of NOAUTH gegeven
	is, worden alleen bijnamen getoond die respectievelijk verboden zijn,
	buiten gebruik zijn, NOEXPIRE aan hebben, of nog niet geauthenticeerd zijn.
	De opties kunnen gebruikt worden in elke volgorde of combinatie en zijn
	alleen beschikbaar voor Services admins.
	
	Voorbeelden:
	
	    LIST joeuser@foo.com
	        Geeft alle geregistreerde bijnamen die het laatst gebruikt zijn door joeuser@foo.com.
	
	    LIST *Bot*
	        Geeft alle geregistreerde bijnamen met Bot in de naam (hoofd of kleine letters).
	
	    LIST * NOEXPIRE
	        Geeft alle geregistreerde bijnamen die op NOEXPIRE staan.

NICK_OPER_HELP_LISTEMAIL
	Syntax: LISTEMAIL patroon [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Geeft een lijst van geregistreerde bijnamen, zoals het LIST
	commando, maar zoekt op E-mail addressen in plaats van
	gebruiker@host addressen.
	Zie de help van het LIST commando (/msg %S HELP LIST) voor
	meer informatie.

NICK_OPER_HELP_LISTEMAIL_AUTH
	Syntax: LISTEMAIL patroon [FORBIDDEN] [NOEXPIRE] [SUSPENDED] [NOAUTH]
	
	Geeft een lijst van geregistreerde bijnamen, zoals het LIST
	commando, maar zoekt op E-mail addressen in plaats van
	gebruiker@host addressen.
	Zie de help van het LIST commando (/msg %S HELP LIST) voor
	meer informatie.

NICK_OPER_HELP_GETPASS
	Syntax: GETPASS nickname
	
	Toont het wachtwoord van de gegeven bijnaam.  Let op dat
	elke keer wanneer iemand dit commando uitvoerd dit getoond
	wordt als WALLOPS/GLOBOPS, inclusief de bijnaam van degene
	die het commando uitvoerd.
	
	Wanneer encryptie aan staat is dit commando mogelijk niet
	beschikbaar, afhankelijk van het gebruikte type encryptie.
	
	Alleen voor Services Admins.
	
NICK_OPER_HELP_FORBID
	Syntax: FORBID bijnaam
	
	Zorgt dat een bijnaam niet geregistreerd of gebruikt kan
	worden. Kan ongedaan worden gemaakt met het %S
	DROP commando.
	
	Alleen voor Services Admins.

NICK_OPER_HELP_SUSPEND
	Syntax: SUSPEND [+vervaltijd] bijnaam rede
	
	Voorkomt gebruik van, of identificatie voor een bijnaam,
	en alle hieraan gelinkte bijnamen.  Dit kan ongedaan worden
	gemaakt met het UNSUSPEND commando, waardoor de bijnaam
	weer gewoon gebruikt kan worden.  De vervaltijd parameter
	werkt hetzelfde als bij het %s AKILL commando.
	
	Beperkt tot Services Admins.

NICK_OPER_HELP_UNSUSPEND
	Syntax: UNSUSPEND bijnaam
	
	Maakt buitenwerkstelling van een bijnaam ongedaan.
	
	Beperkt tot Services Admins.

NICK_OPER_HELP_AJOIN
	
	Services admins kunnen de auto entree lijst van elke bijnaam
	bekijken met de parameter LIST bijnaam.

NICK_OPER_HELP_SETAUTH
	Syntax: SETAUTH bijnaam
	
	Stelt een nieuwe authenticatie code in voor de gegeven
	bijnaam.  De eigenaar van de bijnaam dient het AUTH commando
	te gebruiken voor de bijnaam om zich weer voor deze te
	kunnen identificeren.  Wanneer de bijnaam in gebruik is,
	wordt een waarschuwing gestuurd naar de gebruiker van de
	bijnaam, en wordt deze niet langer als geindentificeerd
	gezien.
	
	Beperkt tot Services Admins.

NICK_OPER_HELP_GETAUTH
	Syntax: GETAUTH bijnaam
	
	Verkrijgt de authenticatie code behorend bij bijnaam, wanneer
	deze bestaat.
	
	Beperkt tot Services Admins.

NICK_OPER_HELP_CLEARAUTH
	Syntax: CLEARAUTH bijnaam
	
	Verwijdert elke authenticatie code behorend bij bijnaam,
	waardoor de bijnaam normaal gebruikt kan worden.
	
	Beperkt tot Services Admins.

###########################################################################
#
# ChanServ help messages
#
###########################################################################

# Used in OP/VOICE/etc for required access levels for commands
CHAN_HELP_REQSOP_LEVXOP
	level 100 (SOP)
CHAN_HELP_REQSOP_LEV
	level 100
CHAN_HELP_REQSOP_XOP
	SOP
CHAN_HELP_REQAOP_LEVXOP
	level 50 (AOP)
CHAN_HELP_REQAOP_LEV
	level 50
CHAN_HELP_REQAOP_XOP
	AOP
CHAN_HELP_REQHOP_LEVXOP
	level 40 (HOP)
CHAN_HELP_REQHOP_LEV
	level 40
CHAN_HELP_REQHOP_XOP
	HOP
CHAN_HELP_REQVOP_LEVXOP
	level 30 (VOP)
CHAN_HELP_REQVOP_LEV
	level 30
CHAN_HELP_REQVOP_XOP
	VOP

# Real help messages start here
CHAN_HELP
	%S Geeft u de mogelijkheid om kamers te registreren en te
	beheren.  %S kan vaak voorkomen dat kwaadwillende gebruikers
	een kamer "overnemen" door het aantal operators te limiteren.
	Typ /msg %S HELP COMMANDS voor een lijst van %S commando's;
	om ze te gebruiken, typ /msg %S commando.  Voor meer informatie
	over een specifiek commando, typ /msg %S HELP commando.
CHAN_HELP_EXPIRES
	
	Let op dat elke kamer die niet gebruikt wordt voor %s
	dagen (niemand van de toegangslijst komt binnen)
	automatisch vervalt.

CHAN_HELP_COMMANDS
	De volgende commando's kunnen gebruikt worden met %S:
	
	    REGISTER   Registreer een kamer
	    IDENTIFY   Identificeer uzelf met uw wachtwoord
CHAN_HELP_COMMANDS_SENDPASS
	    SENDPASS   Stuur het wachtwoord van een kamer naar
	                   uzelf.
CHAN_HELP_COMMANDS_DROP
	    DROP       Maak de registratie van een kamer ongedaan
	    SET        Verander informatie en opties van een kamer
	    UNSET      Verwijder informatie van een kamer
	    INFO       Toon kamer opties en informatie
CHAN_HELP_COMMANDS_LIST
	    LIST       Geef een lijst van geregistreerde kamers
CHAN_HELP_COMMANDS_AKICK
	    AKICK      Muteer de AutoKick lijst
CHAN_HELP_COMMANDS_LEVELS
	    ACCESS     Verander de algemene kamer toegangslijst
	    LEVELS     Bewerk kamer toegangsniveaus
CHAN_HELP_COMMANDS_XOP
	    SOP        Muteer de SuperOp lijst
	    AOP        Muteer de AutoOp lijst
	    VOP        Muteer de VoiceOp lijst
CHAN_HELP_COMMANDS_HOP
	    HOP        Muteer AutoHalfop lijst
CHAN_HELP_COMMANDS_OPVOICE
	    OP         Geef een gebruiker operator status (+o)
	    DEOP       Verwijder operator status (+o)
	    VOICE      Geef een gebruiker voice (+v)
	    DEVOICE    Verwijder voice (+v)
CHAN_HELP_COMMANDS_HALFOP
	    HALFOP     Geef een gebruiker halfop status (+o)
	    DEHALFOP   Verwijder halfop status (+o)
CHAN_HELP_COMMANDS_PROTECT
	    PROTECT    Geef een gebruiker bescherming (+a)
	    DEPROTECT  Verwijder bescherming (+a)
CHAN_HELP_COMMANDS_INVITE
	    INVITE     Nodig uzelf uit tot de kamer
	    UNBAN      Verwijder verbanning van de kamer
	    KICK       Verwijder een gebruiker van de kamer
	    TOPIC      Verander het onderwerp van een kamer
	    CLEAR      Verwijder kamer modes of alle gebruikers
	    STATUS     Toont het toegangslevel van een gebruiker
	                   in een kamer

CHAN_HELP_REGISTER
	Syntax: REGISTER kamer wachtwoord beschrijving
	
	Registreert een kamer in de %S database.  Om dit
	commando te kunnen gebruiken dient u eerst operator status
	te hebben in de kamer die u wilt registreren.
	Het wachtwoord wordt gebruikt met het IDENTIFY commando
	zodat u achteraf instellingen van de kamer kunt veranderen.
	De laatste parameter, die gegeven moet worden, is een
	beschrijving van het doel van de kamer.
	
	Wanneer u een kamer registreerd, wordt u gezien als de
	eigenaar van de kamer. De kamer eigenaar kan alle
	instellingen van de kamer veranderen; %S geeft de eigenaar
	ook autmatisch operator status wanneer hij/zij de kamer
	binnenkomt.
	Zie het ACCESS commando (/msg %S HELP ACCESS) voor
	informatie over het geven van delen van deze rechten aan
	andere kamer gebruikers.
	
	OPMERKING: Om een kamer te registreren dient uw bijnaam
	geregistreerd te zijn. Wanneer u dit nog niet gedaan heeft
	kunt u via /msg %s HELP informatie hierover krijgen.

CHAN_HELP_REGISTER_ADMINONLY
	
	Beperkt tot Services admins.

CHAN_HELP_SENDPASS
	Syntax: SENDPASS kamer
	
	Stuurt u een E-mail bericht met het wachtwoord van de gegeven
	kamer.  U dient de eigenaar van de kamer te zijn om dit commando
	te kunnen gebruiken, en u dient zich eerst te identificeren voor
	uw bijnaam met het %s .IDENTIFY. commando.

CHAN_HELP_IDENTIFY
	Syntax: IDENTIFY kamer wachtwoord
	
	Identificeerd uzelf in %S als de eigenaar van de gegeven
	kamer.  Veel commando's kunnen pas uitgevoerd worden nadat
	u dit commando heeft gebruikt. Het wachtwoord is hetzelfde
	als dat u met het REGISTER commando gebruikt heeft.

CHAN_HELP_DROP
	Syntax: DROP kamer
	
	Verwijdert een kamer.  Kan alleen gebruikt worden door de
	kamer eigenaar, die eerst het IDENTIFY commando gebruikt
	heeft.

CHAN_HELP_SET
	Syntax: SET kamer optie parameters
	
	Geeft de kamer eigenaar de mogelijkheid om verschillende
	opties te veranderen. De eigenaar moet het IDENTIFY
	commando gebruiken voor het gebruik van SET.
	
	Beschikbare opties:
	
	    FOUNDER     Verandert de eigenaar van een kamer
	    SUCCESSOR   Verandert de opvolger van de kamer
	    PASSWORD    Verandert het eigenaar wachtwoord
	    DESC        Verandert de kamer omschrijving
	    URL         Associeert een pagina met de kamer
	    EMAIL       Associeert een E-mail adres met de kamer
	    ENTRYMSG    Stelt een welkomstboodschap in voor wie
	                        de kamer binnenkomt
	    TOPIC       Verandert het onderwerp van de kamer
	    KEEPTOPIC   Behoud het onderwerp wanneer de kamer niet
	                        gebruikt wordt
	    TOPICLOCK   Onderwerp kan alleen veranderd worden met
	                        SET TOPIC
	    MLOCK       Zet een slot op bepaalde kamer modes
	    PRIVATE     Verbergt de kamer voor het LIST commando
	    RESTRICTED  Beperkt toegang tot de kamer
	    SECURE      Activeert %S beveiliging opties
	    SECUREOPS   Strengere controle op operator status
	    LEAVEOPS    Operator status wordt niet afgenomen bij
	                        binnenkomst
	    OPNOTICE    Geeft een waarschuwing wanneer OP/VOICE
	                        commando's gebruikt worden
	    ENFORCE     Behoudt auto-op en auto-voice in de kamer.
	
	Typ /msg %S HELP SET optie voor meer informatie over
	een bepaald commando.

CHAN_HELP_SET_FOUNDER
	Syntax: SET kamer FOUNDER bijnaam
	
	Verandert de eigenaar van een kamer.  De nieuwe bijnaam moet
	een geregistreerde zijn.

CHAN_HELP_SET_SUCCESSOR
	Syntax: SET kamer SUCCESSOR bijnaam
	
	Verandert de opvolger van een kamer. Als de eigenaar
	bijnaam vervalt of verwijderd wordt als de kamer nog is
	geregistreerd wordt de opvolger de nieuwe eigenaar van de
	kamer.  Let op, als de opvolger al te vele kamers op zijn
	naam heeft staan (%d), wordt de kamer verwijderd, alsof
	er geen opvolger in was gesteld.
	De nieuwe bijnaam moet geregistreerd zijn.

CHAN_HELP_SET_PASSWORD
	Syntax: SET kamer PASSWORD wachtwoord
	
	Verandert het wachtwoord waarmee de eigenaar zich moet
	identificeren.

CHAN_HELP_SET_DESC
	Syntax: SET channel DESC description
	
	Verandert de beschrijving van de kamer, die getoond wordt
	in de LIST en INFO commando's.

CHAN_HELP_SET_URL
	Syntax: SET kamer URL pagina
	
	Associeert de gegeven pagina met de kamer.  Deze pagina
	wordt getoond wanneer iemand informatie over de kamer
	opvraagt met het INFO commando.

CHAN_HELP_SET_EMAIL
	Syntax: SET kamer EMAIL adres
	
	Associeert het gegeven E-mail adres met de kamer.  Dit
	adres wordt getoond wanneer iemand informatie over de
	kamer opvraagt met het INFO commando.

CHAN_HELP_SET_ENTRYMSG
	Syntax: SET kamer ENTRYMSG bericht
	
	Verandert het bericht dat gebruikers via /notice krijgen
	als zij de kamer binnenkomen.

CHAN_HELP_SET_KEEPTOPIC
	Syntax: SET kamer KEEPTOPIC {ON | OFF}
	
	Schakelt de onderwerp behoud optie van een kamer aan
	of uit.  Wanneer onderwerp behoud aan staat, onthoudt
	%S het onderwerp, zelfs nadat de laaste gebruiker de
	kamer verlaat, en deze zal teruggezet worden wanneer er
	weer iemand binnenkomt.

CHAN_HELP_SET_TOPICLOCK
	Syntax: SET kamer TOPICLOCK {ON | OFF}
	
	Schakelt de onderwerp slot optie can een kamer aan
	of uit.  Wanneer onderwerp slot aan staat, zal
	%S niet toestaan dat het onderwerp van de kamer veranderd
	wordt, anders dan met het SET TOPIC commando.

CHAN_HELP_SET_MLOCK
	Syntax: SET kamer MLOCK modes
	
	Stelt de mode-slot optie van een kamer in. %S kan ervoor
	zorgen dat bepaalde kamer modes altijd aan of uit staan.
	Alle binaire modes (n, s, t, k, l, enzovoort)
	kunnen in het slot geplaatst worden.  Elke mode kan op
	altijd aan, altijd uit of buiten het slot worden gezet.
	De modes parameter werkt het zelfde als het /MODE
	commando; wat inhoud dat modes die volgen op een + altijd
	aangezet worden en modes volgend op een - altijd uit.
	
	Waarschuwing: Wanneer u mode k in het slot plaatst,
	zoals in voorbeeld twee hieronder, dient u ook de
	RESTRICTED optie aan te zetten voor de kamer (zie HELP
	SET RESTRICTED), anders kan een ieder die de kamer
	binnenkomt als deze leeg is de sleutel zien!  MLOCK +i zal
	gebruikers eveneens niet tegenhouden wanneer zij zonder
	uitnodiging de kamer binnen gaan als deze leeg is.
	
	Voorbeelden:
	
	    SET #channel MLOCK +nt-ikl
	        Zet modes n en t aan, en modes i, k, en l uit.
	        Alle andere modes zijn gewoon te veranderen.
	
	    SET #channel MLOCK +knst-ilmp mijn-sleutel
	        Zet modes k, n, s, en t aan, en modes i, l, m,
	        en p uit.  Tevens blijft de kamersleutel altijd
	        op "mijn-sleutel" staan.
	
	    SET #channel MLOCK +
	        Verwijdert het mode slot; alle kamermodes zijn vrij
	        aan of uit te zetten.

CHAN_HELP_SET_HIDE
	Syntax: SET kamer HIDE {EMAIL | TOPIC | MLOCK} {ON | OFF}
	
	Geeft u de mogelijkheid om te voorkomen dat bepaalde informatie
	getoond wordt wanneer iemand een %S INFO op de gegeven kamer
	doet.  U kunt het E-mail adres (EMAIL), laatste onderwerp
	(TOPIC), en mode-slot (MLOCK) verbergen.  De tweede parameter
	geeft aan of de informatie moet worden getoont (OFF) of verborgen
	(ON).
	
	Let op dat het onderwerp altijd verborgen is wanneer de kamer een
	mode-slot heeft met +p of +s.

CHAN_HELP_SET_PRIVATE
	Syntax: SET kamer PRIVATE {ON | OFF}
	
	Zet de priv optie van een kamer aan of uit.
	Wanneer priv aan staat zal de kamer niet getoond worden
	in een /msg %S LIST.

CHAN_HELP_SET_RESTRICTED
	Syntax: SET kamer RESTRICTED {ON | OFF}
	
	Zet de beperkte toegang optie van een kamer aan of uit.
	Wanneer beperkte toegang aan staat worden gebruikers die
	niet op de toegangslijst staan of die normaal geen kamer
	operator status mogen hebben uit de kamer verwijderd en
	verbannen.

CHAN_HELP_SET_SECURE
	Syntax: SET kamer SECURE {ON | OFF}
	
	Zet %S's beveiligings optie van een kamer aan of uit.
	Wanneer SECURE aanstaat krijgen alleen gebruikers met
	geregistreerde bijnamen waarvoor ze zich geindentificeerd
	rechten volgens de toegangslijst. Wanneer de RESTRICTED
	ook in gebruik is kunnen gebruikers de kamer niet
	binnengaan zonder zich te identificeren bij %s.

CHAN_HELP_SET_SECUREOPS
	Syntax: SET kamer SECUREOPS {ON | OFF}
	
	Zet de operator beveilging optie van een kamer aan of uit.
	Wanneer operator beveilging aan staat kunnen mensen de
	niet op de toegangslijst staan geen operator status krijgen.

CHAN_HELP_SET_LEAVEOPS
	Syntax: SET kamer LEAVEOPS {ON | OFF}
	
	Zet de operator behoud optie van een kamer aan of uit.
	Wanneer operator behoud aan staat zal %S de operator
	status van iemand die als eerste de kamer binnen komt niet
	afnemen, ookal zou de gebruiker normaal geen auto-op krijgen.
	De SECUREOPS optie wordt nog wel toegepast.
	Opmerking:  Dit kan er voor zorgen dat gebruikers operator
	status "stelen" na een netsplit.

CHAN_HELP_SET_OPNOTICE
	Syntax: SET kamer OPNOTICE {ON | OFF}
	
	Zet de operator-alarm optie van een kamer aan of uit.
	Wanneer operator-alarm aan staat, geeft %S een melding aan de
	kamer wanneer de OP, VOICE, of soortgelijke commando's
	gebruikt worden voor iemand in de kamer.

CHAN_HELP_SET_ENFORCE
	Syntax: SET kamer ENFORCE {ON | OFF}
	
	Zet de behoud optie van een kamer aan of uit.
	Wanneer behoud aan staat, zal %S auto-op en auto-voice
	levels van alle gebruikers naleven.  Bijvoorbeeld, als een
	gebruiker met auto-op rechten operator status verliest, zal
	%S deze automatisch teruggeven, en %S zal ook het
	DEOP commando niet toestaan op de betreffende gebruiker.

CHAN_HELP_UNSET
	Syntax: UNSET kamer {SUCCESSOR | URL | EMAIL | ENTRYMSG}
	
	Verwijdert de gegeven optie van een kamer.

CHAN_HELP_SOP
	Syntax: SOP kamer ADD bijnaam
	        SOP kamer DEL bijnaam
	        SOP kamer LIST [masker | list]
	        SOP kamer COUNT
	
CHAN_HELP_SOP_MID1
	Berwerkt de SuperOp (SOP) lijst van een kamer.
	Gebruikers met SOP status krijgen autmatisch operator
	status (mode +o) wanneer zij de kamer binnengaan.
CHAN_HELP_SOP_MID1_CHANPROT
	Berwerkt de SuperOp (SOP) lijst van een kamer.
	Gebruikers met SOP status krijgen autmatisch operator
	status (mode +o) en bescherming (mode +a) wanneer zij de
	kamer binnengaan.
CHAN_HELP_SOP_MID2
	
	Een SOP kan de AOP en VOP lijsten bewerken. Alleen
	de kamer eigenaar kan de SOP lijst bewerken.
CHAN_HELP_SOP_MID2_HALFOP
	
	Een SOP kan de AOP, HOP en VOP lijsten bewerken.  Alleen
	een kamer eigenaar kan de SOP lijst bewerken.

CHAN_HELP_SOP_END
	
	Het SOP LIST commando toont de SOP lijst.  Wanneer een
	masker wordt gegeven, worden alleen die invoeren getoond.
	Wanneer een lijst van invoernummers gegeven wordt,
	worden alleen deze invoeren getoond; bijvoorbeeld:
	
	   SOP #channel LIST 2-5,7-9
	      Geeft SOP lijst invoeren 2 tot en met 5 en
	      7 tot en met 9.
	
	Het SOP COUNT commando geeft het aantal invoeren op de
	SOP lijst.

CHAN_HELP_AOP
	Syntax: AOP kamer ADD bijnaam
	        AOP kamer DEL bijnaam
	        AOP kamer LIST [masker | lijst]
	        AOP kamer COUNT
	
	Bewerkt de AutoOp (AOP) lijst van een kamer.
	Gebruikers met AOP status krijgen automatisch operator
	status (mode +o) wanneer zij de kamer binnengaan.
CHAN_HELP_AOP_MID
	
	Een AOP kan de VOP lijst bewerken; SOPs kunnen de AOP
	lijst bewerken.
CHAN_HELP_AOP_MID_HALFOP
	
	Een AOP kan de HOP en VOP lijsten bewerken; SOPs kunnen de
	AOP lijst bewerken.
CHAN_HELP_AOP_END
	
	Het AOP LIST commando toont de AOP lijst.  Wanneer een
	masker wordt gegeven, worden alleen die invoeren getoond.
	Wanneer een lijst van invoernummers gegeven wordt,
	worden alleen deze invoeren getoond; bijvoorbeeld:
	
	   AOP #channel LIST 2-5,7-9
	      Geeft AOP lijst invoeren 2 tot en met 5 en
	      7 tot en met 9.
	
	Het AOP COUNT commando geeft het aantal invoeren op de
	AOP lijst.

CHAN_HELP_HOP
	Syntax: HOP kamer ADD bijnaam
	        HOP kamer DEL bijnaam
	        HOP kamer LIST [masker | list]
	        HOP kamer COUNT
	
	Bewerkt de HalfOp (HOP) lijst van een kamer.
	Gebruikers met HOP status krijgen automatisch halfop
	status (mode +h) wanneer zij de kamer binnengaan.
	
	Een HOP kan de VOP lijst bewerken; SOPs en AOPs kunnen
	de HOP lijst bewerken.
	
	Het HOP LIST commando toont de HOP lijst.  Wanneer een
	masker wordt gegeven, worden alleen die invoeren getoond.
	Wanneer een lijst van invoernummers gegeven wordt,
	worden alleen deze invoeren getoond; bijvoorbeeld:
	
	   HOP #channel LIST 2-5,7-9
	      Geeft HOP lijst invoeren 2 tot en met 5 en
	      7 tot en met 9.
	
	Het HOP COUNT commando geeft het aantal invoeren op de
	HOP lijst.

CHAN_HELP_VOP
	Syntax: VOP kamer ADD bijnaam
	        VOP kamer DEL bijnaam
	        VOP kamer LIST [masker | list]
	        VOP kamer COUNT
	
	Bewerkt de VoiceOp (VOP) lijst van een kamer.
	Gebruikers met VOP status krijgen automatisch voice
	(mode +v) wanneer zij de kamer binnengaan.
	
	Het VOP LIST commando toont de VOP lijst.  Wanneer een
	masker wordt gegeven, worden alleen die invoeren getoond.
	Wanneer een lijst van invoernummers gegeven wordt,
	worden alleen deze invoeren getoond; bijvoorbeeld:
	
	   VOP #channel LIST 2-5,7-9
	      Geeft VOP lijst invoeren 2 tot en met 5 en
	      7 tot en met 9.
	
	Het VOP COUNT commando geeft het aantal invoeren op de
	VOP lijst.

CHAN_HELP_ACCESS
	Syntax: ACCESS kamer ADD bijnaam level
	        ACCESS kamer DEL {bijnaam | invoer-num | list}
	        ACCESS kamer LIST [masker | list]
	        ACCESS kamer COUNT
	
	Bewerkt de toegangslijst van een kamer. De toegangslijst
	houdt bij welke gebruikers toegang hebben tot operator
	status en %S commando's in de kamer.  Verschillende
	gebruiker levels geven de mogelijkheid toegang te geven tot
	verschillende onderdelen van rechten;  /msg %S HELP
	ACCESS LEVELS voor meer specifieke informatie.  Elke
	bijnaam die niet op de toegangslijst staat heeft level 0.
	
	Het ACCESS ADD commando voegt de gegeven bijnaam toe aan
	de toegangslijst met het gegeven toegangslevel; wanneer de
	bijnaam al op de lijst staat wordt het toegangslevel
	veranderd naar de gegeven waarde.  Het gegeven level dient
	lager te zijn dan dat van de gebruiker die het commando
	geeft, en als de bijnaam al op de toegangslijst staat
	dient zijn/haar level lager te zijn dan dat van de gebruiker
	die het commando geeft.
	
	Het ACCESS DEL commando verwijdert de gegeven bijnaam uit
	de toegangslijst.  Wanneer een lijst van invoer nummers
	wordt gegeven, worden deze verwijderd.  (Zie de voorbeelden
	van LIST hieronder.)
	
	Het ACCESS LIST commando toont de toegangslijst.  Wanneer
	een masker gegeven wordt, worden alleen de invoeren volgens
	het masker getoond.  Wanneer een lijt van invoernummers
	gegeven wordt, worden alleen deze invoeren getoond.;
	bijvoorbeeld:
	
	   ACCESS #channel LIST 2-5,7-9
	      Geeft toegangslijst invoeren 2 tot en met 5 en
	      7 tot en met 9.
	
	Het ACCESS COUNT commando geeft het aantal invoeren in de
	toegangslijst.
CHAN_HELP_ACCESS_XOP
	
	Let op, de toegangslijst kan ook berwerkt worden met de
	SOP, AOP, en VOP commando's, welke respectievelijk
	corresponderen met de levels %d, %d, en %d.
CHAN_HELP_ACCESS_XOP_HALFOP
	
	Let op, de toegangslijst kan ook berwerkt worden met de
	SOP, AOP, en HOP, en VOP commando's, welke
	respectievelijk corresponderen met de levels %d, %d, %d, en %d.

CHAN_HELP_ACCESS_LEVELS
	Gebruiker toegangslevels
	
	Standaard zijn de volgende toegangslevels gedefineerd:
	
	    Founder   Volledige toegang tot %S functies; automatische
	                  operator status bij binnenkomst.  Let op
	                  dat slechts 1 gebruiker als eigenaar
	                  ingesteld kan worden (het kan niet gegeven
	                  worden met het ACCESS commando).
	       %4d   Toegang tot AKICK commando; automatische
	                      operator status.
	       %4d   Automatische operator status.
CHAN_HELP_ACCESS_LEVELS_HALFOP
	       %4d   Automatische halfop status.
CHAN_HELP_ACCESS_LEVELS_END
	       %4d   Automatische voice.
	          0   Geen speciale rechten; kan ops krijgen van
	                  anderen (behalve wanneer SECUREOPS aan
	                  staat).
	         -1   Mag geen operator status krijgen.
	       -100   Mag de kamer niet binnengaan.
	
	Deze levels (behalve de laatste 2) kunnen veranderd worden,
	of worden aangevuld, met het LEVELS commando; typ
	/msg %S HELP LEVELS voor informatie.

CHAN_HELP_LEVELS
	Syntax: LEVELS kamer SET type level
	        LEVELS kamer {DIS | DISABLE} type
	        LEVELS kamer LIST
	        LEVELS kamer RESET
	
	Met het LEVELS commando kunnen de kamer toegangslevels
	gebruikt door het ACCESS commando nauwkeurig bewerkt worden.
	Met dit commando kunt u de het vereisde toegangslevel voor de
	meeste van %S's functies bepalen. (De SET FOUNDER en
	SET PASSWORD commando's, en dit commando, kunnen alleen door de
	eigenaar gebruikt worden.)
CHAN_HELP_LEVELS_XOP
	
	PAS OP:  Dit commando is alleen voor gevorderde gebruikers!  Het
	veranderen van level instellingen kan ervoor zorgen dat de
	SOP, AOP en VOP commando's niet meer goed werken.
CHAN_HELP_LEVELS_XOP_HOP
	
	PAS OP:  Dit commando is alleen voor gevorderde gebruikers!  Het
	veranderen van level instellingen kan ervoor zorgen dat de
	SOP, AOP, HOP en VOP commando's niet meer goed werken.
CHAN_HELP_LEVELS_END
	
	LEVELS SET geeft de mogelijkheid om het toegangslevel voor
	een functie of groep van functies te veranderen.
	LEVELS DISABLE (of DIS in het kort) schakelt een
	automatische instelling uit of maakt een bepaalde functie
	alleen toegangkelijk tot de kamer eigenaar.
	LEVELS LIST toont de huidige levels voor elke functie of
	groep van functies.  LEVELS RESET herstelt de levels naar
	de standaardwaardes voor een nieuwe kamer (zie HELP ACCESS
	LEVELS).
	
	Voor de lijst van functies waarvan levels veranderd kunnen
	worden, zie HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	De volgende functienamen zijn bekend.

CHAN_HELP_AKICK
	Syntax: AKICK kamer ADD masker [rede]
	        AKICK kamer DEL masker
	        AKICK kamer LIST [masker | lijst]
	        AKICK kamer VIEW [masker | lijst]
	        AKICK kamer ENFORCE
	        AKICK kamer COUNT
	
	Bewerkt de autokick lijst van een kamer.  Wanneer een
	gebruiker op de autokick de kamer probeert binnen te gaan
	zal %S de gebruiker van de kamer verwijderen en verbannen.
	
	Het AKICK ADD commando voegt het gegeven gebruiker@host
	of bijnaam!gebruiker@host masker toe aan de autokick
	lijst.  Wanneer een rede wordt gegeven wordt deze als
	kick-boodschap gebruikt; zo niet, de standaard rede is
	"You have been banned from the channel".
	
	Het AKICK DEL commando verwijdert het gegeven masker van
	de autokick lijst.  Het verwijdert echter geen verbanningen
	die door autokick zijn geplaatst; deze dienen handmatig
	verwijderd te worden.
	
	Het AKICK LIST commando toont de autokick lijst, of
	of alleen de autokick invoeren met het gegeven masker.
	AKICK VIEW toont meer details.
	
	Het AKICK ENFORCE commando zorgt dat %S de huidige
	autokick lijst uitvoerd door alle gebruikers die in de lijst
	staan te verwijderen uit de kamer.
	
	Het AKICK COUNT commando toont het aantal invoeren op de
	autokick lijst.
	
	Standaard alleen beschikbaar voor gebruikers met
	toegangslevel %s of hoger in de kamer.

CHAN_HELP_INFO
	Syntax: INFO kamer [ALL]
	
	Geeft informatie over de gegeven geregistreerde kamer,
	inclusief eigenaar, tijd van registratie, laatst gebruikte
	tijd en mode-slot, als deze ingesteld is.  Als u
	geidentificeerd bent als de kamer eigenaar van de gegeven
	kamer en u geeft de parameter ALL mee, worden ook de kamer
	opvolger en binnenkomst bericht getoond.

CHAN_HELP_LIST
	Syntax: LIST patroon
	
	Geeft een lijst van alle geregistreerde kamers volgens een
	bepaald patroon. (Kamers waar de PRIVATE optie aanstaat
	worden niet getoond.)
CHAN_HELP_LIST_OPERSONLY
	
	Alleen IRC operators kunnen dit commando gebruiken.

CHAN_HELP_OP
	Syntax: OP kamer bijnaam
	
	Geeft de gegeven gebruiker operator status in een kamer.
	Standaard alleen beschikbaar voor gebruikers met
	toegangslevel %s of hoger in de kamer.

CHAN_HELP_DEOP
	Syntax: DEOP kamer bijnaam
	
	Verwijdert de operator status van de gegeven gebruiker in
	een kamer.  Standaard alleen beschikbaar voor gebruikers met
	toegangslevel %s of hoger in de kamer.

CHAN_HELP_VOICE
	Syntax: VOICE kamer bijnaam
	
	Geeft de gegeven gebruiker voice in een kamer.  Standaard
	alleen beschikbaar voor gebruikers met toegangslevel %s of
	hoger in de kamer.

CHAN_HELP_DEVOICE
	Syntax: DEVOICE kamer bijnaam
	
	Verwijdert de voice van de gegeven gebruiker in een kamer.
	Standaard alleen beschikbaar voor gebruikers met
	toegangslevel %s of hoger in de kamer.

CHAN_HELP_HALFOP
	Syntax: HALFOP kamer bijnaam
	
	Geeft de gegeven gebruiker halfop status in een kamer.
	Standaard alleen beschikbaar voor gebruikers met
	toegangslevel %s of hoger in de kamer.

CHAN_HELP_DEHALFOP
	Syntax: DEHALFOP kamer bijnaam
	
	Verwijdert de halfop status van de gegeven gebruiker in een
	kamer.  Standaard alleen beschikbaar voor gebruikers met
	toegangslevel %s of hoger in de kamer.

CHAN_HELP_PROTECT
	Syntax: PROTECT kamer bijnaam
	
	Geeft de gegeven gebruiker protection (mode +a) in een kamer.
	Standaard alleen beschikbaar voor gebruikers met
	toegangslevel %s of hoger in de kamer.

CHAN_HELP_DEPROTECT
	Syntax: DEPROTECT kamer bijnaam
	
	Verwijdert de protection (mode +a) van de gegeven gebruiker
	in een kamer.  Standaard alleen beschikbaar voor gebruikers
	met toegangslevel %s of hoger in de kamer.

CHAN_HELP_INVITE
	Syntax: INVITE kamer
	
	Zorgt dat %S u uitnodigt voor de gegeven kamer.  Standaard
	alleen beschikbaar voor gebruikers met toegangslevel %s of
	hoger in de kamer.

CHAN_HELP_UNBAN
	Syntax: UNBAN kamer
	
	Zorgt dat %S alle verbanningen van u verwijdert uit de
	gegeven kamer. Standaard alleen beschikbaar voor gebruikers
	met toegangslevel %s of hoger in de kamer.

CHAN_HELP_KICK
	Syntax: KICK kamer bijnaam [rede]
	
	Geeft %S opdracht de gegeven bijnaam uit de gegeven kamer te
	verwijderen.  Het bijgevoegde bericht toont wie het kick-commando
	gebruikte, evenals de rede gegeven met het commando, als die er
	is.  Standaard alleen beschikbaar voor gebruikers met
	toegangslevel %s of hoger in de kamer.

CHAN_HELP_KICK_PROTECTED
	
	Let op dat beschermde (+a) gebruikers niet met dit commando
	verwijderd kunnen worden, zelfs niet door de kamer eigenaar.

CHAN_HELP_TOPIC
	Syntax: TOPIC kamer onderwerp
	
	Zorgt dat %S het onderwerp van de kamer verandert naar
	het gegeven onderwerp.  Dit commando is vooral nuttig in
	combinatie met SET TOPICLOCK.  Standaard alleen beschikbaar
	voor gebruikers met toegangslevel %s of hoger in de kamer.

CHAN_HELP_CLEAR
	Syntax: CLEAR kamer wat
	
	Zorgt dat %S een bepaald iets verwijdert van de gegeven
	kamer.  wat
	kan n van de volgende dingen zijn:
	
	    MODES       Verwijdert alle modes op de kamer behalve
	                    die in het mode-slot.
	    BANS        Verwijdert alle verbanningen van de kamer.
CHAN_HELP_CLEAR_EXCEPTIONS
	    EXCEPTIONS  Verwijdert alle uitzonderingen van de kamer.
CHAN_HELP_CLEAR_INVITES
	    INVITES     Verwijdert alle uitnodigingsmaskers van de kamer.
CHAN_HELP_CLEAR_MID
	    OPS         Verwijdert operator status (mode +o) van
	                    alle gebruikers.
CHAN_HELP_CLEAR_HALFOPS
	    HALFOPS     Verwijdert halfop status (mode +h) van
	                    alle gebruikers.
CHAN_HELP_CLEAR_END
	    VOICES      Verwijdert "voice" status (mode +v) van
	                    alle gebruikers.
	    USERS       Verwijdert (kicks) alle gebruikers van de
	                    kamer.
	
	Standaard alleen beschikbaar voor gebruikers met toegangslevel
	%s of hoger in de kamer.

CHAN_HELP_STATUS
	Syntax: STATUS kamer bijnaam
	
	Geeft het huidige toegangslevel van de gegeven bijnaam in de
	gegeven kamer.  Deze wordt getoond in de vorm:
	
	    STATUS kamer bijnaam toegangslevel
	
	Wanneer een fout optreedt wordt de volgende melding getoond:
	
	    STATUS kamer bijnaam ERROR foutbericht
	
	Standaard alleen beschikbaar voor gebruikers met toegangslevel
	%s of hoger in de kamer.

CHAN_OPER_HELP_COMMANDS
	
	De volgende commando's zijn beschikbaar voor Services admins:

CHAN_OPER_HELP_COMMANDS_GETPASS
	    GETPASS   Verkrijg het eigenaar wachtwoord van een kamer
	                  (alleen wanneer versleuteling uit staat)
CHAN_OPER_HELP_COMMANDS_FORBID
	    FORBID    Voorkom dat een kamer wordt geregistreerd/
	                  gebruikt
	    SUSPEND   Voorkom dat een geregistreerde kamer wordt
	                  gebruikt
	    UNSUSPEND Maak SUSPEND ongedaan
CHAN_OPER_HELP_COMMANDS_END
	
	Services Admins kunnen ook een kamer verwijderen zonder gebruik
	van een wachtwoord, en zij kunnen de ACCESS, AKICK en LEVEL
	lijsten van elke kamer bekijken en het STATUS commando voor elke
	kamer gebruiken.

CHAN_OPER_HELP_DROP
	Syntax: DROP channel
	
	Verwijdert de gegeven kamer. Alleen Services admins
	kunnen een kamer verwijderen waar zij zich niet voor
	geidentificeerd hebben.
	
CHAN_OPER_HELP_SET
	
	Services Admins kunnen ook de optie NOEXPIRE gebruiken,
	waarmee voorkomen kan worden dat kamers vervallen. Ook
	kunnen Services Admins opties voor elke kamer veranderen
	zonder wachtwoord identificatie voor de kamer.

CHAN_OPER_HELP_SET_NOEXPIRE
	Syntax: SET kamer NOEXPIRE {ON | OFF}
	
	Stelt in of de gegeven kamer zal vervallen.  De optie ON
	voorkomt dat de kamer vervalt.
	
	Beperkt tot Services Admins.

CHAN_OPER_HELP_UNSET
	
	Net zoals bij het SET commando kunnen Services Admins opties wissen
	voor elke kamer zonder wachtwoord identificatie voor de
	kamer.

CHAN_OPER_HELP_INFO
	
	Services admins kunnen de ALL parameter gebruiken bij elke
	kamer.

CHAN_OPER_HELP_LIST
	Syntax: LIST patroon [FORBIDDEN] [NOEXPIRE] [SUSPENDED]
	
	Geeft een lijst van alle geregistreerde kamers volgens het
	gegeven patroon. Kamers die de PRIVATE optie aan hebben
	staan worden alleen aan Services Admins getoond. Kamers die
	de NOEXPIRE optie aan hebben staan hebben een ! voor de
	kamernaam staan voor Services Admins.
	
	Wanneer de FORBIDDEN, SUSPENDED of NOEXPIRE optie is
	gegeven, worden alleen kamers getoond die respectievelijk
	verboden zijn, buiten werking zijn gesteld of niet vervallen.
	De opties kunnen gebruikt worden in elke volgorde en combinatie.
	Deze opties zijn alleen beschikbaar voor Services Admins.

CHAN_OPER_HELP_GETPASS
	Syntax: GETPASS kamer
	
	Geeft het wachtwoord van de gegeven kamer.  Let op dat
	wanneer dit commando gebruikt wordt er een bericht met onder
	andere de persoon die het commando gebruikt en de kamer
	waarvoor het gebruikt werd opgeslagen wordt en verstuurd als
	WALLOPS/GLOBOPS.
	
	Wanneer encryptie aanstaat is dit commando mogelijk niet te
	gebruiken, afhankelijk van het gebruikte type encryptie.
	
	Beperkt tot Services Admins.

CHAN_OPER_HELP_FORBID
	Syntax: FORBID kamer
	
	Verbied iedereen de gegeven kamer te gebruiken of
	registreren.  Kan ongedana worden gemaakt door de kamer
	te verwijderen.
	
	Beperkt tot Services Admins.

CHAN_OPER_HELP_SUSPEND
	Syntax: SUSPEND [+vervaltijd] kamer rede
	
	Voorkomt gebruik van, of identificatie voor een kamer.
	Dit kan ongedaan worden gemaakt met het UNSUSPEND commando,
	waardoor de kamer weer gewoon gebruikt kan worden.
	De vervaltijd parameter werkt hetzelfde als bij het
	%s AKILL commando.
	
	Beperkt tot Services Admins.

CHAN_OPER_HELP_UNSUSPEND
	Syntax: UNSUSPEND kamer
	
	Maakt het weer mogelijk om een voorheen buiten werking
	gestelde kamer te gebruiken en voor te identificeren.
	
	Beperkt tot Services admins.

###########################################################################
#
# MemoServ help messages
#
###########################################################################

MEMO_HELP
	%S geeft IRC gebruikers de mogelijkheid korte berichten
	naar andere gebruikers te sturen, of deze online zijn of
	niet, of naar kamers(*).  Zowel de bijnaam van de verzender
	als die van de ontvangende persoon of kamer dienen
	geregistreerd te zijn om deze Service te kunnen gebruiken.
	Typ /msg %S HELP COMMANDS voor een lijst van %S commando's;
	om een commando te gebruiken, typ /msg %S commando, of voor
	meer informatie over een commando, typ /msg %S HELP commando.
MEMO_HELP_EXPIRES
	
	Let op:  Memo's vervallen (worden automatisch verwijderd)
	%s na versturen, behalve als ze gemarkeerd zijn als niet vervallend
	met het SAVE commando.
MEMO_HELP_END_LEVELS
	
	(*) Standaard kan een gebruiker met minimaal %s in de
	    kamer de memo's van die kamer lezen.  Dit kan veranderd
	    worden door middel van het %s LEVELS commando.
MEMO_HELP_END_XOP
	
	(*) Alle gebruikers op de SOP lijst van een kamer kunnen de
	   memo's van die kamer lezen.

MEMO_HELP_COMMANDS
	%S's commando's zijn:
	
	    SEND      Stuurt een memo naar een gebruiker of kamer
	    LIST      Geeft een lijst van uw memo's
	    READ      Leest memo('s)
MEMO_HELP_COMMANDS_FORWARD
	    FORWARD   Stuurt memo's naar uw E-mail adres
MEMO_HELP_COMMANDS_SAVE
	    SAVE      Markeert memo's als niet vervallend
MEMO_HELP_COMMANDS_DEL
	    DEL       Verwijdert memo('s)
	    SET       Verandert opties met betrekking tot memo's
	    INFO      Geeft informatie over memo's
MEMO_HELP_COMMANDS_IGNORE
	    IGNORE    Negeer memo's van bepaalde gebruikers

MEMO_HELP_SEND
	Syntax: SEND {bijnaam | kamer} memo-tekst
	
	Stuurt de gegeven bijnaam of kamer een memo met daarin
	memo-tekst.  Wanneer u naar een bijnaam stuurt krijgt de
	ontvanger een melding van de nieuwe memo.  De ontvangende
	bijnaam/kamer dient geregistreerd te zijn.

MEMO_HELP_LIST
	Syntax: LIST [kamer] [lijst | NEW]
	
	Geeft een lijst van memo's die u momenteel heeft.  Met NEW,
	worden alleen nieuwe (ongelezen) memo's getoond.  Ongelezen
	memo's worden aangegeven met een "*" aan de linkerkant van
	het nummer.  U kunt ook een lijst van nummers specificeren
	zoals in het voorbeeld hieronder:
	
	   LIST 2-5,7-9
	      Geeft een lijst van memo's 2 tot en met 5 en 7 tot
	      en met 9.

MEMO_HELP_LIST_EXPIRE
	Syntax: LIST [kamer] [lijst | NEW]
	
	Geeft een lijst van memo's die u momenteel heeft.  Met NEW,
	worden alleen nieuwe (ongelezen) memo's getoond.  Ongelezen
	memo's worden aangegeven met een "*" aan de linkerkant van
	het nummer; memo's die neit vervallen worden aangegeven met een
	"+".  U kunt ook een lijst van nummers specificeren zoals in
	het voorbeeld hieronder:
	
	   LIST 2-5,7-9
	      Geeft een lijst van memo's 2 tot en met 5 en 7 tot
	      en met 9.

MEMO_HELP_READ
	Syntax: READ [kamer] {num | lijst | LAST | NEW}
	
	Toont u de tekst van de gegeven memo.  Wanneer LAST gegeven
	is wordt de laatst ontvangen memo getoond.  Wanneer NEW
	gegeven is worden alle ongelezen memo's getoond.  Anders
	wordt memo nummer num getoond.  U kunt ook een lijst van
	nummers geven, zoals bij het LIST commando.

MEMO_HELP_SAVE
	Syntax: SAVE [kamer] {num | lijst}
	
	Markeert de gegeven memo of memo's als niet vervallend.  U kunt
	ofwel een enkel memo nummer of, zoals bij het LIST commando,
	een lijst van memo's geven.

MEMO_HELP_DEL
	Syntax: DEL [kamer] {num | list | ALL}
	
	Verwijdert de gegeven memo of memo's.  U kunt meerdere memo
	nummers of reeksen van nummers geven in plaatst van een enkel
	nummer, zoals met het LIST commando; u kunt ook het woord
	ALL opgegeven, wat ervoor zorgt dat al uw memo's verwijderd
	worden.
	
	Waarschuwing: Wanneer een memo is verwijderd kan deze niet
	meer terug gehaald worden.

MEMO_HELP_SET
	Syntax: SET optie parameters
	
	Verandert verscheidene memo opties. optie kan zijn:
	
	    NOTIFY      Verandert wanneer u bericht krijgt van
	                    nieuwe memo's (alleen voor bijnamen)
	    LIMIT       Stelt het maximum aantal te ontvangen memo's
	                    in
MEMO_HELP_SET_OPTION_FORWARD
	    FORWARD     Stelt in of memo's automatisch naar uw doorgestuurd
	                worden
MEMO_HELP_SET_END
	
	Typ /msg %S HELP SET optie voor meer informatie over
	een bepaalde optie.

MEMO_HELP_SET_NOTIFY
	Syntax: SET NOTIFY {ON | LOGON | NEW | OFF}
	
	Verandert wanneer u bericht krijgt van nieuwe memo's:
	
	    ON      U krijgt bericht van nieuwe memo's als u inlogged,
	               terugkomt van /AWAY en wanneer een memo naar
	               u verstuurd wordt.
	    LOGON   U krijgt bericht van nieuwe memo's als u inlogged,
	               en wanneer u terugkomt van /AWAY.
	    NEW     U krijgt bericht van nieuwe memo's wanneer deze
	               naar u verstuurd worden.
	    OFF     U krijgt geen bericht van nieuwe memo's.
	
	ON is gelijk aan LOGON en NEW samen.
	
	Let op dat wanneer uw bijnaam de "secure" optie aan heeft u
	alleen bericht krijgt van nieuwe memo's (voor LOGON of ON)
	als u zich geidentificeerd heeft met %s.

MEMO_HELP_SET_LIMIT
	Syntax: SET LIMIT [kamer] limiet
	
	Stelt het maximum aantal memo's in dat u (of de gegeven
	kamer) kunt ontvangen. Wanneer u deze optie op 0 zet kan
	niemand memo's naar u sturen.  Let op, u kunt deze optie
	niet hoger zetten dan %d.

MEMO_HELP_INFO
	Syntax: INFO [kamer]
	
	Geeft informatie over het aantal memo's dat u heeft, hoeveel
	hiervan ongelezen zijn, hoeveel memo's u mag ontvangen en
	wanneer u bericht krijgt van nieuwe memo's. Met een
	parameter wordt dezelfde informatie getoond voor de gegeven
	kamer.

MEMO_OPER_HELP_COMMANDS
	
	Services admins kunnen de SET en INFO commando's gebruiken voor
	bijnamen die niet van hun zijn.

MEMO_OPER_HELP_SET_LIMIT
	Syntax: SET LIMIT [user | kamer] {limiet | NONE | DEFAULT} [HARD]
	
	Stelt het maximum aantal memo's in dat een gebruiker of
	kamer mag hebben. De limiet op 0 zetten zorgt dat de
	gebruiker geen memo's kan ontvangen; de limiet op NONE
	zetten zorgt dat de gebruiker een onbeperkt aantal memo's mag
	hebben; en de limiet op DEFAULT zetten zorgt dat de limiet op
	de standaardwaarde (%d) gezet wordt.  Wanneer u geen bijnaam of
	kamer geeft wordt uw eigen limiet veranderd.
	
	Toevoegen van HARD zorgt dat de gebruiker de limiet niet
	kan veranderen.  HARD niet toevoegen heeft het
	tegenovergestelde effect, de gebruiker kan nu zelf zijn
	limiet veranderen (ook al kon dat voorheen niet).
	
	Het gebruik van het SET LIMIT commando is beperkt tot
	Services admins.  Andere gebruikers kunnen alleen de
	limiet van zichzelf of een kamer waar zij de juiste rechten
	hebben veranderen, kunnen hun limiet niet verwijderen,
	kunnen hun limiet niet boven %d zetten en kunnen geen HARD
	limiet instellen.

MEMO_OPER_HELP_INFO
	Syntax: INFO [nick | kamer]
	
	Zonder parameter, geeft informatie over het aantal memo's
	dat u heeft, hoeveel er ongelezen zijn, hoeveel u er mag
	ontvangen en hoe u bericht krijgt van nieuwe memo's.
	
	Wanneer u een kamer als parameter meegeeft, wordt dezelfde
	informatie getoond voor de gegeven kamer.
	
	Wanneer u een bijnaam als parameter meegeeft, wordt dezelfde
	informatie getoond voor de gegeven bijnaam.  Deze optie is
	alleen te gebruiken door Services Admins.

MEMO_HELP_FORWARD
	Syntax: FORWARD {num | lijst | ALL}
	
	Stuurt een of meer van uw memo's door naar uw E-mail adres.
	U dient een geldig E-mail adres ingesteld te hebben voor uw
	bijnaam om dit commando te kunnen gebruiken.  Kamer memo's
	kunnen niet doorgestuurd worden.

MEMO_HELP_SET_FORWARD
	Syntax: SET FORWARD {ON | COPY | OFF}
	
	Stelt in of %S memo's die naar u verzonden worden automatisch
	doorstuurt naar uw E-mail adres.  Wanneer deze optie op ON
	staat worden memo's verstuurd naar uw bijnaam automatisch
	doorgestuurd naar het E-mail adres geregistreerd bij uw bijnaam.
	COPY doet iets soortgelijks, alleen zorgt deze optie dat %S
	een kopie van de memo bewaard die online te lezen is.
	Wanneer deze optie op OFF worden uw memo's online opgeslagen
	zoals normaal.  Zelfs wanneer u deze optie op ON zet is het
	mogelijk dat u memo's online ontvangt wanneer Services deze niet
	kan doorsturen naar u.
	
	Let op dat wanneer deze optie is ingesteld op COPY en u het
	maximum aantal memo's dat u mag ontvangen heeft bereikt, u
	niet meer memo's kan ontvangen (ook niet via E-mail) totdat
	u enige oude memo's verwijdert met het DEL commando.

MEMO_HELP_IGNORE
	Syntax: IGNORE {ADD | DEL | LIST} [bijnaam | masker]
	
	Bewerkt de lijst van "genegeerde" gebruikers.  Gebruikers wiens
	bijnaam of gebruiker@host masker overeenkomt met een invoer in
	deze lijst mogen geen memo's naar u sturen.  ADD voegt gegeven
	bijnaam of gebruiker@host masker toe aan uw negeer lijst, en
	DEL verwijdert gegeven bijnaam of gebruiker@host masker van
	de lijst.; LIST toont uw huidige negeer lijst.
	
	Let op dat bijnaam of gebruiker@host masker gegeven met het
	ADD commando de karakters "*" en "?" mag bevatten en niet
	hoofdletter gevoelig is; bijvoorbeeld, *Evil* komt overeen met
	"EvilNick", "AN_EVIL_USER" en "devil".

###########################################################################
#
# OperServ help messages
#
###########################################################################

OPER_HELP
	%S geeft IRC operators de mogelijkheid verscheidene aspecten van
	het IRC netwerk te beheren.  Type /msg %S HELP COMMANDS voor een
	lijst van commando's.
	
	Let op: Alle commando's gestuurd naar %S worden bijgehouden!

OPER_HELP_COMMANDS
	%S commando's:
	    GLOBAL      Stuur een bericht naar alle gebruikers
	    STATS       Toon status van het netwerk en Services
	    SERVERMAP   Toon kaart van servers op het netwerk
	    OPER LIST   Geef een lijst van alle Services Operators
	    ADMIN LIST  Geef een lijst van alle Services Admins
OPER_HELP_COMMANDS_SERVOPER
	
	Commando's beschikbaar voor Services Operators en Admins:
	    MODE        Verander de modes van een kamer
	    KICK        Verwijder een gebruiker van een kamer
	    CLEARMODES  Verwijder bepaalde modes van een kamer
	    CLEARCHAN   verwijder alle gebruikers van een kamer
	                   (masskick)
	    KILLCLONES  Kill alle gebruikers met een bepaalde host
OPER_HELP_COMMANDS_AKILL
	    AKILL       Bewerk de autokill lijst
	    AKILLCHAN   Verwijder alle gebruikers in een kamer d.m.v. autokill
OPER_HELP_COMMANDS_EXCLUDE
	    EXCLUDE     Bewerk de autokill uitzonderingen lijst
OPER_HELP_COMMANDS_SLINE
	    SGLINE      Bewerk de SGLINE lijst
	    SQLINE      Bewerk de SQLINE lijst
	    SZLINE      Bewerk de SZLINE lijst
OPER_HELP_COMMANDS_SESSION
	    SESSION     Bekijk de lijst van host sessies
	    EXCEPTION   Verander de sessie-limiet uitzonderingen
	                   lijst
OPER_HELP_COMMANDS_NEWS
	    LOGONNEWS   Definieer berichten die bij het inloggen aan
	                   gebruikers worden getoond
	    OPERNEWS    Definieer berichten die bij een /OPER aan
	                   gebruikers worden getoond
OPER_HELP_COMMANDS_SERVADMIN
	
	Commando's beschikbaar voor Services Admins:
	    OPER        Verander de Services Operator lijst
	    JUPE        "Jupiter" een server
	    SET         Verander verscheidene Services opties
	    UPDATE      Dwing de Services databases direct te
	                    updaten naar harde schijf
	    SHUTDOWN    Sla de databases op en stop de Services
	    QUIT        Sluit Services af zonder het opslaan van
	                   databases
	    RESTART     Sla de databases op en herstart Services
	    REHASH      Lees de configuratie bestanden opnieuw in
	    SU          Verkrijg Services super-gebruiker rechten
OPER_HELP_COMMANDS_SERVROOT
	
	Commando's beschikbaar voor de Services Super-Gebruiker:
	    ADMIN       Bewerk de Services Admin lijst
OPER_HELP_COMMANDS_RAW
	    RAW         Stuur een regel naar de IRC Server

OPER_HELP_GLOBAL
	Syntax: GLOBAL bericht
	
	Geeft IRCops de mogelijkheid berichten te sturen naar alle
	gebruikers op het netwerk.
	Het bericht wordt gestuurd vanuit de bijnaam %s.
	
OPER_HELP_STATS
	Syntax: STATS [RESET | NETWORK | ALL]
	
	Zonder optie, toont het huidige aantal gebruikers en IRCops
	online (exclusief Services), het hoogste aantal gebruikers
	online sinds Services gestart werd en de tijd die Services
	al draait.
	
	Met de RESET optie, zet het hoogste aantal gebruikers
	terug naar het aantal dat op dat moment online is.
	
	Met de NETWORK optie,toont de hoeveelheid data verstuurd
	en ontvangen van de server waar Services mee verbonden is,
	en de hoeveelheid geheugen gebruikt door de netwerk
	zend/ontvang buffers.  De verhouding van het huidige buffer
	geheugen ten opzichte van de maximale buffergrootte wordt
	ook getoond in de vorm van een percentage wanneer er een
	limiet is ingesteld.
	
	De ALL optie is alleen beschikbaar voor Services Admins en
	geeft informatie over Services' geheugen gebruik.  Gebruik
	van dit commando kan Services tijdelijk "bevriezen" op grote
	netwerken, dus gebruik dit commando met mate!
	
	UPTIME kan gebruikt worden als synoniem voor STATS.

OPER_HELP_SERVERMAP
	Syntax: SERVERMAP
	
	Toont een kaart van servers verbonden aan het netwerk, vanuit
	het oogpunt van Services.  "Nep" servers --Services zelf en
	servers waarvoor JUPE gebruikt is-- worden aangegeven met "(*)"
	achter de servernaam.

OPER_HELP_OPER
	Syntax: OPER ADD bijnaam
	        OPER DEL bijnaam
	        OPER LIST
	
	Geeft Services Admins de mogelijkheid bijnamen toe te voegen
	en te verwijderen uit de Services Operator lijst.  Een
	gebruiker wiens bijnaam op deze lijst staat en wie zich
	geindentificeerd heeft met %s krijgt toegang tot Services
	operator commando's.
	
	Elke IRC Operator kan het OPER LIST commando gebruiken.
	Alle andere functies zijn beperkt tot Services Admins.

OPER_HELP_ADMIN
	Syntax: ADMIN ADD bijnaam
	        ADMIN DEL bijnaam
	        ADMIN LIST
	
	Geeft de Services Super-Gebruiker de mogelijkheid bijnamen
	toe te voegen en te verwijderen uit de Services Admins lijst.
	Een gebruiker wiens bijnaam op deze lijst staat en wie zich
	geindentificeerd heeft met %s krijgt toegang tot Services
	Admin commando's.
	
	Elke IRC Operator kan het ADMIN LIST commando gebruiken.
	Alle andere functies zijn beperkt tot de
	Services Super-Gebruiker.

OPER_HELP_MODE
	Syntax: MODE kamer modes
	
	Geeft Services Operators de mogelijkheid modes te veranderen
	op elke kamer.  Parameters zijn hetzelfde als bij het
	normale /MODE commando.
	
	Beperkt tot Services Operators.

OPER_HELP_CLEARMODES
	Syntax: CLEARMODES kamer [ALL]
	
	Verwijdert alle binaire modes (n,s,t,k,l,enzovoort) en
	verbanningen van een kamer. Wanneer ALL gegeven is worden
	ook gebruiker modes (zoals +o en +v) verwijderd van de kamer.
	
	Beperkt tot Services Operators.

OPER_HELP_CLEARCHAN
	Syntax: CLEARCHAN kamer
	
	Verwijdert alle gebruikers van een kamer (masskick).
	
	Beperkt tot Services Operators.

OPER_HELP_KICK
	Syntax: KICK kamer gebruiker rede
	
	Geeft IRCops de mogelijkheid gebruikers van elke
	kamer te verwijderen. Parameters zijn hetzelfde als bij het
	normale /KICK commando. De kick-boodschap bevat de bijnaam
	van de IRCop die het commando uitvoerd; bijvoorbeeld:
	
	*** SpamMan has been kicked off channel #my_channel by
	    %S (Alcan (Flood))
	
	Beperkt tot Services Operators.

OPER_HELP_AKILL
	Syntax: AKILL ADD [+vervaltijd] masker rede
	        AKILL DEL masker
	        AKILL LIST [masker] [NOEXPIRE]
	        AKILL VIEW [masker] [NOEXPIRE]
	        AKILL COUNT
	
	Geeft Services Operators de mogelijkheid de AKILL lijst te
	bewerken.  Wanneer een gebruiker die in deze lijst staat op
	de server probeert in te loggen zal Services deze autmatisch
	verwijderen en, op ondersteunde servers een verbanning
	(K-line) op alle servers toevoegen voor het betreffende
	masker.
	
	AKILL ADD voegt het gegeven user@host masker aan de AKILL
	lijst toe met de gegeven rede (die gegeven moet worden).
	AKILL DEL verwijdert het gegeven masker van de AKILL lijst
	als deze hierop staat.  AKILL LIST toont alle huidige
	AKILLs; wanneer een optioneel masker gegeven is, worden
	alleen de AKILLs volgens het masker getoond. AKILL VIEW is
	een gedetaileerde versie van AKILL LIST, en toont wie een
	AKILL toevoegde, op welke datum, en wanneer deze verloopt,
	tezamen met het user@host masker en de rede. Wanneer de
	NOEXPIRE optie gegeven is worden alleen AKILLS getoond die
	niet vervallen, en overeenkomen met het gegeven user@host
	masker. AKILL COUNT telt het aantal AKILLs in de AKILL
	lijst.
	
	Optioneel kan er een vervaltijd gegeven worden met het
	AKILL ADD commando.  De vervaltijd gaat vooraf aan het
	user@host masker en wordt geschreven als een nummer gevolgd
	door d (dagen), h (uren), of m (minuten).  Combinaties
	(zoals 1h30m) zijn ook toegestaan.  Wanneer geen eenheid
	gegeven wordt, is de standaardwaarde dagen (dus +30 betekend
	30 dagen).  Om een AKILL in te voeren die niet verloopt gebruikt
	u +0.  Wanneer het masker dat ingevoerd dient te worden start
	met een +, is een vervaltijd verplicht, ook al is deze hetzelfde
	als de standaardwaarde.
	
	De rede dient te beschrijven waarom de invoer is toegevoegd;
	afhankelijk van hoe Services geconfigureerd is, wordt deze wel
	of niet getoond aan gebruikers in KILL berichten.
OPER_HELP_AKILL_OPERMAXEXPIRY
	
	Services operators kunnen een vervaltijd opgeven van ten
	hoogste %s; Services administrators kunnen elke vervaltijd
	opgeven.
OPER_HELP_AKILL_END
	
	Beperkt tot Services Operators.

OPER_HELP_AKILLCHAN
	Syntax: AKILLCHAN [KILL] [+vervaltijd] kamer rede
	
	Voegt autokills toe voor alle gebruikers behalve IRC
	operators in een gegeven kamer, en verwijdert ze (wanneer
	KILL is gegeven) van het netwerk.  De rede wordt opgeslagen
	bij elke autokill, en wordt getoond in kill berichten
	afhankelijk van hoe Services geconfigureerd is.  vervaltijd
	vereist dezelfde syntax als het AKILL ADD commando; wanneer
	deze niet gegeven wordt is ze %s.
	
	Autokills die met dit commando worden toegevoegd hebben de
	vorm *@host masker, voor elk host masker dat gebruikt wordt
	door een client in de kamer.  Wanneer een dergelijke
	autokill al bestaat voor een host masker, zal deze niet
	veranderd worden; hierdoor kan het aantal autokills lager
	zijn dan het aantal gebruikers waarop deze effect hebben.
	
	Beperkt tot Services operators.

OPER_HELP_EXCLUDE
	Syntax: EXCLUDE ADD [+vervaltijd] masker rede
	        EXCLUDE DEL masker
	        EXCLUDE LIST [masker] [NOEXPIRE]
	        EXCLUDE VIEW [masker] [NOEXPIRE]
	        EXCLUDE COUNT
	
	Geeft Services Operators de mogelijkheid om de autokill
	uitzonderingen lijst te bewerken.  Wanneer een gebruiker
	met een masker uit de uitzonderingen lijst verbinding maakt
	met het netwerk, zal Services geen KILL geven, ook al
	komt deze gebruiker voor in de autokill lijst.  Dit is nuttig
	wanneer u brede autokill maskers heeft, maar specifieke hosts
	of gebruikers toch wilt toelaten.
	
	De ADD, DEL, LIST, VIEW en COUNT opties werken het zelfde als
	de opties van het AKILL commando; zie de AKILL help voor meer
	informatie.
	
	Beperkt tot Services operators.

OPER_HELP_SGLINE
	Syntax: SGLINE ADD [+vervaltijd] masker rede
	        SGLINE DEL masker
	        SGLINE LIST [masker] [NOEXPIRE]
	        SGLINE VIEW [masker] [NOEXPIRE]
	        SGLINE COUNT
	
	Geeft Services operators de mogelijkheid de SGLINE lijst te
	beheren.  Wanneer een gebruiker wiens "echte naam" overeenkomt
	met een SGLINE masker probeert op het netwerk te komen, zal
	Services een KILL geven en, op ondersteunde servers, alle
	servers opdracht geven een ban (server G-line) voor het masker
	van de betreffende gebruiker toe te voegen.
	
	SGLINE ADD voegt het gegeven naam masker toe aan de SGLINE
	lijst met de gegeven rede (die moet worden gegeven).
	SGLINE DEL verwijdert het gegeven masker van de SGLINE lijst
	wanneer deze hierop aanwezig is.
	SGLINE LIST toont alle SGLINE invoeren; wanneer het optionele
	masker gegeven is, wordt de lijst gelimiteerd tot de invoeren
	die overeen komen met dit masker.
	SGLINE VIEW is een uitgebreidere versie van SGLINE LIST, en
	toont wie elke SGLINE invoer toegevoegd heeft, de datum waarop
	dit gebeurde, en wanneer deze verloopt, alsmede het masker en
	de rede.  Wanneer de NOEXPIRE optie gegeven wordt, worden
	alleen invoeren die zowel niet verlopen als overeenkomen met
	het gegeven masker getoond.
	SGLINE COUNT geeft simpelweg het aantal invoeren in de SGLINE
	lijst.
	
	De masker parameter mag gegeven worden tussen dubbele
	aanhalingstekens, dit moet wanneer het masker spaties bevat;
	bijvoorbeeld: /msg %S SGLINE ADD +0 "slechte naam" Dit is een
	slechte naam.
	
	Optioneel kan een vervaltijd gegeven worden bij het SGLINE ADD
	commando.  De vervaltijd gaat vooraf aan het gebruiker@host
	masker, en wordt gegeven als een geheel getal gevolgd door een
	van d (dagen), h (uren), or m (minuten).  Combinaties
	(zoals 1h30m) zijn ook toegestaan.  Wanneer een eenheid
	specificatie niet meegegeven wordt is de standaardwaarde dagen
	(dus +30 op zichzelf betekent 30 dagen).  Om een invoer toe
	te voegen die niet verloopt, gebruik +0.  Wanneer het toe te
	voegen masker begint met een + dient een vervaltijd ten alle
	tijden gegeven te worden, ook al is deze hetzelfde als de
	standaardwaarde.
	
	De rede dient te beschrijven waarom de invoer toegevoegd wordt;
	afhankelijk van hoe Services is geconfigureerd wordt het ook
	getoond aan gebruikers in KILL berichten.
	
	Beperkt tot Services operators.

OPER_HELP_SQLINE
	Syntax: SQLINE ADD [+vervaltijd] masker rede
	        SQLINE DEL masker
	        SQLINE LIST [masker] [NOEXPIRE]
	        SQLINE VIEW [masker] [NOEXPIRE]
	        SQLINE COUNT
	
OPER_HELP_SQLINE_KILL
	Geeft Services operators de mogelijkheid de SQLINE lijst te
	manipuleren.  Wanneer een gebruiker wiens bijnaam overeenkomt met
	een SQLINE masker probeert in te loggen, of een gebruiker probeert
	een bijnaam te gebruiken waarvoor een SQLINE masker aanwezig is,
	zal Services een KILL geven en, op ondersteunde server types, alle
	servers opdracht geven een ban (server Q-line) toe te voegen voor
	het masker dat overeenkomt met de gebruiker.
OPER_HELP_SQLINE_NOKILL
	Geeft Services operators de mogelijkheid de SQLINE lijst te
	manipuleren.  Wanneer een gebruiker wiens bijnaam overeenkomt met
	een SQLINE masker probeert in te loggen, of een gebruiker probeert
	een bijnaam te gebruiken waarvoor een SQLINE masker aanwezig is,
	zal Services de bijnaam van de gebruiker veranderen naar een "gast"
	bijnaam, en de gebruiker een bericht sturen dat de IRC client van
	de gebruiker normaalgesproken een nieuwe bijnaam laat aanvragen.
	Op ondersteunde server types zal Services ook alle servers opdracht
	geven een ban (server Q-line) toe te voegen voor het masker dat
	overeenkomt met de gebruiker.
OPER_HELP_SQLINE_IGNOREOPERS
	
	Let op dat SQLINE maskers geen betrekking hebben op IRC Operators.
OPER_HELP_SQLINE_END
	
	De ADD, DEL, LIST, en VIEW, en COUNT subcommando's
	kunnen gebruikt worden om invoeren in de SQLINE lijst toe te voegen,
	te verwijderen, te bekijken (korte of lange versie), of te tellen.
	Zie de help van SGLINE (/msg %S HELP SGLINE) voor details.
	
	Beperkt tot Services operators.

OPER_HELP_SZLINE
	Syntax: SZLINE ADD [+vervaltijd] masker rede
	        SZLINE DEL masker
	        SZLINE LIST [masker] [NOEXPIRE]
	        SZLINE VIEW [masker] [NOEXPIRE]
	        SZLINE COUNT
	
	Geeft Services operators de mogelijkheid de SZLINE lijst te
	manipuleren.  Wanneer een gebruiker wiens IP adres overeenkomt met
	een SQLINE masker zal Services een KILL geven en, op ondersteunde
	servers, alle servers  opdracht geven een ban (server Z-line) voor
	de bijnaam van de betreffende gebruiker toe te voegen.
	
	De ADD, DEL, LIST, en VIEW, en COUNT subcommando's
	kunnen gebruikt worden om invoeren in de SQLINE lijst toe te voegen,
	te verwijderen, te bekijken (korte of lange versie), of te tellen.
	Zie de help van SGLINE (/msg %S HELP SGLINE) voor details.
	
	Beperkt tot Services operators.
	
OPER_HELP_EXCEPTION
	Syntax: EXCEPTION ADD [+vervaltijd] masker limiet rede
	        EXCEPTION DEL {masker | list}
	        EXCEPTION MOVE num nieuwnum
	        EXCEPTION LIST [masker | list]
	        EXCEPTION VIEW [masker | list]
	
	Geeft Services operators de mogelijkheid de lijst van
	hostmaskers die specifieke sessie limieten hebben te
	bewerken. Doormiddel van deze lijt kunnen bepaalde computers
	meer inloggen dan het standaard aantal. Wanneer de limiet
	bereikt is worden alle pogingen tot inloggen die volgen
	vanaf die host afgebroken. Ze worden gewaarschuwd in de vorm
	van een /NOTICE van %S over waar zij heulp op het gebied van
	sessie limieten kunnen krijgen. De inhoud van deze
	waarschuwing is een configuratie instelling.
	
	EXCEPTION ADD voegt het gegeven hostmasker aan de
	uitzonderingslijst toe. Let op dat bijnaam!gebruiker@host
	en gebruiker@host maskers ongeldig zijn!
	Alleen echte hostmaskers, zoals box.host.dom en
	*.host.dom zijn toegestaan omdat sessie limieten niet
	letten op bijnamen of gebruikersnamen. limiet dient een
	nummer gorter of gelijk aan 0 te zijn. Dit bepaald hoevaak
	een bepaalde host mag inloggen tegelijkertijd (de waarde 0
	betekent dat de host een onbeperkt aantal sessies mag hebben).
	
	Optioneel kan een vervaltijd meegegeven worden met het EXCEPTION
	ADD commando.  De vervaltijd gaat voor aan het host masker, en
	wordt gegeven als een integer gevolgd bij n van d (dagen),
	h (uren), of m (minuten).  Combinaties (zoals 1h30m)
	zijn ook toegestaan.  Wanneer geen eenheid gegeven is, is de
	standaardwaarde dagen (dus +30 op zichzelf betekent 30 dagen).
	Om een invoer toe te voegen die niet vervalt gebruikt u +0.
	Wanneer het toe te voegen masker begint met een + dient u
	altijd een vervaltijd te geven, ook al is deze hetzelfde als
	de standaardwaarde.
	
	EXCEPTION DEL verwijdert het gegeven masker of invoer-nummer
	van de uitzonderingslijst (invoer nummers kunnen bekeken worden
	met (VIEW of LIST).
	
	EXCEPTION MOVE verplaatst uitzondering num naar nieuwnum.
	Wanneer nieuwnum al door een andere uitzondering gebruikt
	wordt zal dit nummer verhoogd worden om ruimte te maken.
	
	EXCEPTION LIST en EXCEPTION VIEW tonen alle huidige
	uitzonderingen; wanneer een masker wordt meegegeven worden
	alleen die uitzonderingen getoond. Het verschil is dat
	EXCEPTION VIEW gedetaileerder is, deze geeft de naam van
	de persoon die de uitzondering toegevoegd heeft, de sessie
	limiet, rede, host masker en vervaldatum en tijd, evenals
	wanneer de uitzondering voor het laatst "gebruikt" is, dus
	wanneer er voor het laatst een gebruiker online kwam die
	overeen kwam met het masker van de uitzondering.
	
	Let op dat een inloggende gebruiker de eerste overeenkomende
	uitzondering "gebruikt". Grote uitzonderingslijsten en brede
	maskers kunnen de prestaties van Services omlaag halen.
	
	Beperkt tot Services operators.

OPER_HELP_SESSION
	Syntax: SESSION LIST drempel
	        SESSION VIEW host
	
	Geeft Services operators de mogelijkheid de sessie lijst te
	bekijken.
	
	SESSION LIST toont host maskers met minimaal drempel
	sessies. De drempel dient groter te zijn dan 1. Dit om te
	voorkomen dat het grote aantal enkele sessies onnodig
	getoond wordt.
	
	SESSION VIEW toont gedetaileerde informatie over een
	specifieke host, inclusief het huidige aantal sessies en de
	sessie limiet. De host parameter mag geen globale tekens
	als * en ? bevatten.
	
	Zie de EXCEPTION help voor meer informatie over sessie
	limitering en hoe sessie limieten te specificeren voor
	bepaalde hosts of groepen hosts.
	
	Beperkt tot Services operators.

OPER_HELP_SU
	Syntax: SU wachtwoord
	
	Geeft toegang tot functies die Services Super-Gebruiker
	rechten vereisen. Het wachtwoord is hetgeen ingesteld met
	het SET SUPASS commando; let op dat het wachtwoord
	ingesteld dient te zijn om dit commando te kunnen gebruiken.
	Super-Gebruiker rechten blijven tot u van bijnaam verandert
	of IRC verlaat.
	
	WAARSCHUWING: wanneer u een foutief wachtwoord gebruikt,
	zal Services een waarschuwing geven aan alle IRC Operators.
	
	Beperkt tot Services Admins.

OPER_HELP_SET
	Syntax: SET optie instelling
	
	Verandert verschillende Services opties.  Opties zijn
	momenteel:
	    READONLY   Zet Services in alleen-lezen of lees-schrijf
	                    modus
	    DEBUG      Activeert of deactiveerd debug modus
	    SUPASS     Verandert het wachtwoord voor het SU
	                    commando (Super-Gebruiker)
	
	Beperkt tot Services Admins; de SUPASS optie mag alleen
	ingesteld worden door de Services Super-Gebruiker.

OPER_HELP_SET_READONLY
	Syntax: SET READONLY {ON | OFF}
	
	Zet alleen-lezen modus on (aan) of off (uit).  In alleen-
	lezen modus kunnen normale gebruiekrs niks in Services
	veranderen, inclusief kamer en bijnaam toegangslijsten e.d.
	IRCops met voldoende Services rechten hebben de
	mogelijkheid de AKILL lijst te bewerken en bijnamen te
	verwijderen en te verbieden, maar deze veranderingen worden
	niet opgeslagen als Services niet uit alleen-lezen modus
	gehaald wordt voordat deze uitgezet of geherstart wordt.
	
	Deze optie is gelijk aan de commando-lijn optie -readonly.

OPER_HELP_SET_DEBUG
	Syntax: SET DEBUG {ON | OFF | num}
	
	Zet debug-modus on (aan) of off (uit).  In debug-modus
	worden alle commando's gestuurd naar Services en enkele
	andere foutcontrole berichten naar het logbestand geschreven.
	Wanneer num is gegeven wordt debug-modus geactiveerd met
	het foutcontrole nummer num.
	
	Deze optie is gelijk aan de commando-lijn optie -debug.

OPER_HELP_SET_SUPASS
	Syntax: SET SUPASS [wachtwoord]
	
	Verandert het wachtwoord voor het SU commando.  Het
	wachtwoord dient ingesteld te zijn om het SU commando te
	kunnen gebruiken.  Wanneer geen wachtwoord gegeven wordt,
	is het SU commando niet beschikbaar.
	
	Deze optie kan alleen ingesteld worden door de Services
	Super-Gebruiker.

OPER_HELP_JUPE
	Syntax: JUPE server [rede]
	
	Zorgt dat Services een server "jupiter" maakt, wat inhoud
	dat een nepserver aan Services gekoppeld wordt, zodat de
	echte server met deze naam niet aan het netwerk kan
	koppelen.  De "jupe" kan verwijderd worden met het /SQUIT
	commando.  Wanneer een rede is gegeven wordt deze in de
	server informatie regel geplaatst; zoniet komt in deze regel
	de tekst "Jupitered by <nick>", waarbij <nick> de bijnaam
	is van degene die het jupe commando gaf.
	
	Beperkt tot Services Admins.

OPER_HELP_RAW
	Syntax: RAW tekst
	
	Stuurt een regel tekst direct naar de IRC server waaraan
	Services verbonden is.  Dit commando heeft een beperkt
	aantal functies, en kan een netwerk ernstig verstoren of
	Services laten vastlopen bij foutief gebruik. GEBRUIK
	DIT COMMANDO NIET tenzij u absoluut zeker weet wat u doet!
	
	Beperkt tot de Services Super-Gebruiker.

OPER_HELP_UPDATE
	Syntax: UPDATE [FORCE]
	
	Zorgt dat Services alle database bestanden update direct na het
	sturen van het commando.  Wanneer de FORCE optie gegeven wordt
	zal Services proberen de databases vrij te geven voor het updaten;
	dit kan gebruikt worden om "databases are locked" errors tijdens
	het updaten op te lossen.
	
	Beperkt tot Services Admins.

OPER_HELP_QUIT
	Syntax: QUIT
	
	Zorgt dat Services onmiddelijk afsluit; databases worden
	niet opgeslagen.  Dit commando dient niet gebruikt worden
	tenzij er mogelijk schade is aan de kopien van de databases
	in het geheugen en deze niet opgeslagen dienen te worden.
	Om normaal af te sluiten dient u het SHUTDOWN commando
	te gebruiken.
	
	Beperkt tot Services Admins.

OPER_HELP_SHUTDOWN
	Syntax: SHUTDOWN
	
	Zorgt dat Services alle databases opslaat en vervolgens
	afsluit.
	
	Beperkt tot Services Admins.

OPER_HELP_RESTART
	Syntax: RESTART
	
	Zorgt dat Services alle databases opslaat en vervolgens
	opnieuw opstart (afsluit en meteen weer start).
	
	Beperkt tot Services Admins.

OPER_HELP_REHASH
	Syntax: REHASH
	
	Zorgt dat Services de configuratie bestanden opnieuw inleest
	en actieve instellingen update.  Sommige instellingen, zoals
	RemoteServer (welke de hostname van de IRC server waaraan
	verbonden moet worden instelt), kunnen niet veranderd worden
	met REHASH, en treden pas in werking als Services opnieuw wordt
	opgestart; in dit geval wordt een bericht hiervan geschreven naar
	het Serrvices log bestand, en een notice gestuurd om hierover
	te berichten.
	
	Wanneer LoadModule regels toegevoegd of verwijderd zijn van
	het hoofd Services configuratie bestand (%s), worden de
	nodige modules geladen of verwijderd.  Modules die niet langer
	een LoadModule lijn hebben worden verwijderd in omgekeerde
	volgorde van laden; dan, nadat de overige modules opnieuw zijn
	ingelezen, worden de nieuwe modules geladen in de volgorde
	zoals ze staan in het configuratie bestand.  Wanneer een fout
	optreed tijdens een van deze stappen wordt het proces
	afgebroken.
	
	Let op dat vanwege module afhankelijkheid sommige modules niet
	verwijderd of veranderd  kunnen worden via REHASH; in deze
	gevallen dient u Services opnieuw op te starten om de
	veranderingen tot stand te brengen.
	
	Beperkt tot Services Admins.

OPER_HELP_KILLCLONES
	Syntax: KILLCLONES bijnaam
	
	Verwijdert alle gebruikers met hetzelfde hostmasker als
	bijnaam. Een tijdelijke AKILL in de vorm *@host, wordt
	toegevoegd om te zorgen dat verwijderde gebruikers niet
	meteen weer terugkomen. Er wordt ook een bericht gestuurd
	(Wallops) met daarin degene die het commando uitvoerde, de
	host waarvoor het geld en hoeveel gebruikers verwijderd
	zijn. Het is handig om meerdere dubbelgangers van het
	netwerk te verwijderen.
	
	Beperkt tot Services Admins.


###########################################################################
#
# StatServ help messages
#
############################################################################

STAT_HELP
	%S geeft statistische informatie over het IRC netwerk,
	de servers en de gebruikers. Voor meer informatie over
	een specifiek commando, typ /msg %S HELP commando.

STAT_HELP_COMMANDS
	De volgende commando's kunnen gebruikt worden met %S:
	
	    SERVERS     Server statistieken
	    USERS       Gebruiker statistieken

STAT_HELP_SERVERS
	Syntax: SERVERS STATS
	        SERVERS LIST [masker]
	        SERVERS VIEW [masker] [ONLINE | OFFLINE]
	
	Toont statistieken over de servers in het netwerk.
	
	SERVERS STATS toont een korte samenvatting van de
	servers zichtbaar (online) en onzichtbaar (offline)
	voor Services.
	SERVERS LIST toont een lijst van zichtbare servers en
	hun statistieken.
	SERVERS VIEW toont een lijst van zichtbare en
	onzichtbare servers met gedetailleerde statistieken. De
	ONLINE en OFFLINE opties zorgen dat respectievelijk
	alleen zichtbare of alleen onzichtbare servers getoond
	worden.
	
	Gebruik de masker optie om het aantal te tonen
	servers te verlagen.

STAT_HELP_USERS
	Syntax: USERS STATS
	
	Toont statistieken over gebruikers op het netwerk.

STAT_OPER_HELP_SERVERS
	Syntax: SERVERS STATS
	        SERVERS LIST [masker]
	        SERVERS VIEW [masker] [ONLINE | OFFLINE]
	        SERVERS DELETE server
	        SERVERS COPY server nieuwe naam
	        SERVERS RENAME server nieuwe naam
	
	Toont statistieken over de servers in het netwerk.
	
	SERVERS STATS toont een korte samenvatting van de
	servers zichtbaar (online) en onzichtbaar (offline)
	voor Services.
	SERVERS LIST toont een lijst van zichtbare servers en
	hun statistieken.
	SERVERS VIEW toont een lijst van zichtbare en
	onzichtbare servers met gedetailleerde statistieken. De
	ONLINE en OFFLINE opties zorgen dat respectievelijk
	alleen zichtbare of alleen onzichtbare servers getoond
	worden.
	
	Gebruik de masker optie om het aantal te tonen
	servers te verlagen.
	
	DELETE verwijdert de statistieken van de gegeven server.
	COPY dupliceert een set server statistieken.
	RENAME hernoemt een set server statistieken.
	Deze drie commando's zijn beperkt tot Services Admins.
