/* Ignore handling.
 *
 * IRC Services is copyright (c) 1996-2009 Andrew Church.
 *     E-mail: <achurch@achurch.org>
 * Parts written by Andrew Kempe and others.
 * This program is free but copyrighted software; see the file COPYING for
 * details.
 */

#include "services.h"
#include "ignore.h"
#include "hash.h"

/*************************************************************************/

static int ignore_check_expire(IgnoreData *ign);

void hash_add_ignore(IgnoreData *ign);  /* to avoid warnings */
void hash_del_ignore(IgnoreData *ign);  /* same */

/*************************************************************************/

/* Use ignore code? */
int allow_ignore = 1;

/* People to ignore. */
#define add_ignore hash_add_ignore
#define del_ignore hash_del_ignore
#undef EXPIRE_CHECK
#define EXPIRE_CHECK ignore_check_expire
DEFINE_HASH(ignore, IgnoreData, who)
#undef add_ignore
#undef del_ignore

/*************************************************************************/
/*************************************************************************/

/* ignore_check_expire: Return whether the given IgnoreData has expired.
 *                      Used by get_ignore().
 */

static int ignore_check_expire(IgnoreData *ign)
{
    return ign->time <= time(NULL);
}

/*************************************************************************/

/* add_ignore: Add someone to the ignorance list for the next `delta'
 *             seconds.
 */

void add_ignore(const char *nick, time_t delta)
{
    IgnoreData *ign;
    time_t now = time(NULL);

    ign = get_ignore(nick);
    if (ign) {
	if (ign->time > now)
	    ign->time += delta;
	else
	    ign->time = now + delta;
    } else {
	ign = smalloc(sizeof(*ign));
	strscpy(ign->who, nick, sizeof(ign->who));
	ign->time = now + delta;
	hash_add_ignore(ign);
    }
}

/*************************************************************************/

/* del_ignore: Remove someone from the ignorance list.  Return nonzero if
 *             the nick was found, zero otherwise.
 */

int del_ignore(const char *nick)
{
    IgnoreData *ign;

    ign = get_ignore(nick);
    if (ign) {
	hash_del_ignore(ign);
	free(ign);
	return 1;
    } else {
	return 0;
    }
}

/*************************************************************************/
