/*
 * scandir.h: header for scandir routine.
 *
 * Copyright (c) 1998 glen mccready.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $eterna: scandir.h,v 1.7 2009/04/28 03:18:55 mrg Exp $
 */

#ifndef __scandir_h__
#define __scandir_h__
#ifndef HAVE_SCANDIR

#if (!defined(__386BSD__) && !defined(_HPUX_SOURCE))
# if defined(__SVR4) || defined(POSIX) || defined(__linux__) \
  || defined(__osf__) || defined(__QNX__)

#if defined(__linux__) || defined(__sgi)
int scandir(const char *, struct dirent ***, int (*)(), int (*)());
#else
int scandir(char *, struct dirent ***, int (*)(), int (*)());
#endif /* __linux__ || __sgi */
#else
int scandir(char *, struct direct ***, int (*)(), int (*)());
#endif /* (!__386BSD__ && !_HPUX_SOURCE) */
#endif	/* __386BSD__ || BSD */

#endif /* !HAVE_SCANDIR */
#endif /* __scandir_h__ */
