/*-
 * Copyright (c) 2003 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *   @(#)$Id: ipa_log.h,v 1.2 2011/01/23 18:42:34 simon Exp $
 */

#ifndef IPA_LOG_H
#define IPA_LOG_H

#define IPA_LOG_IDENT	"ipa"

#define LOG_BUF_SIZE	1024

extern const char *log_ident;
extern const char *log_file;

extern void	init_log(void);
extern void	open_log(void);
extern void	close_log(void);

extern void	mvlogmsgx_wrapper(const char *, va_list);

extern void	(*xvlogmsgx)(int, const char *, va_list);

extern void	logbt(const char *);
extern void	logmsg(int, const char *, ...) ATTR_FORMAT(printf, 2, 3);
extern void	logmsgx(int, const char *, ...) ATTR_FORMAT(printf, 2, 3);
extern void	logdbg(const char *, ...) ATTR_FORMAT(printf, 1, 2);
extern void	vlogmsgx(int, const char *, va_list) ATTR_FORMAT(printf, 2, 0);
extern void	vlogmsgx_stderr(int, const char *, va_list)
		    ATTR_FORMAT(printf, 2, 0);

extern void	mod_logmsg(const char *, int, int, const char *, va_list);
extern void	log_stream(int, const char *);

#define log_stderr() do {				\
	(void)fflush(stderr);				\
	log_stream(stderr_read, "STDERR");		\
} while (/* CONSTCOND */ 0)

#define log_stdout() do {				\
	(void)fflush(stdout);				\
	log_stream(stdout_read, "STDOUT");		\
} while (/* CONSTCOND */ 0)

#define log_stdall() do {				\
	if (!debug)					\
		log_stderr();				\
	log_stdout();					\
} while (/* CONSTCOND */ 0)

#endif /* !IPA_LOG_H */
