.\" Converted with mdoc2man 0.2
.\" from NiH: img2eps.mdoc,v 1.15 2005/07/06 14:43:05 dillo Exp 
.\"  $NiH: img2eps.man,v 1.15 2005/07/07 09:31:48 dillo Exp $
.\"
.\"  img2eps.mdoc \-- man page for img2eps(1)
.\"  Copyright (C) 2002, 2005 Dieter Baron and Thomas Klausner
.\"
.\"  This file is part of img2eps, an image to EPS file converter.
.\"  The authors can be contacted at <dillo@giga.or.at> and
.\"  <tk@giga.or.at> respectively
.\"
.\"  Redistribution and use in source and binary forms, with or without
.\"  modification, are permitted provided that the following conditions
.\"  are met:
.\"  1. Redistributions of source code must retain the above copyright
.\"     notice, this list of conditions and the following disclaimer.
.\"  2. Redistributions in binary form must reproduce the above copyright
.\"     notice, this list of conditions and the following disclaimer in
.\"     the documentation and/or other materials provided with the
.\"     distribution.
.\"  3. The name of the author may not be used to endorse or promote
.\"     products derived from this software without specific prior
.\"     written permission.
.\" 
.\"  THIS SOFTWARE IS PROVIDED BY DIETER BARON ``AS IS'' AND ANY EXPRESS
.\"  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\"  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\"  ARE DISCLAIMED.  IN NO EVENT SHALL DIETER BARON BE LIABLE FOR ANY
.\"  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\"  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\"  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\"  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\"  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\"  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\"  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH IMG2EPS 1 "July 7, 2005" NiH
.SH "NAME"
img2eps \- package raster images into EPS file
.SH "SYNOPSIS"
.B img2eps
[\fB-123\fR]
[\fB-a\fR | \fB--ascii\fR \fBENC\fR]
[\fB--bottom-margin\fR \fBM\fR]
[\fB-C\fR | \fB--compress\fR \fBC\fR]
[\fB-c\fR | \fB--stdout\fR]
[\fB-G\fR | \fB--gravity\fR \fBG\fR]
[\fB-g\fR | \-gray | \-grey]
[\fB-h\fR | \fB--help\fR]
[\fB--height\fR \fBH\fR]
[\fB--ignore-order\fR]
[\fB--left-margin\fR \fBM\fR]
[\fB--level\fR]
[\fB-m\fR | \fB--margin\fR \fBM\fR]
[\fB-n\fR | \fB--dry-run\fR]
[\fB-O\fR | \fB--orientation\fR \fBO\fR]
[\fB-o\fR | \fB--output\fR \fBFILE\fR]
[\fB-P\fR | \fB--paper\fR \fBP\fR]
[\fB-r\fR | \fB--resolution\fR \fBR\fR]
[\fB-R\fR | \fB--recompress\fR]
[\fB--right-margin\fR \fBM\fR]
[\fB-s\fR | \fB--size\fR \fBS\fR]
[\fB--top-margin\fR \fBM\fR]
[\fB-v\fR | \fB--verbose\fR]
[\fB-V\fR | \fB--version\fR]
[\fB--width\fR \fBW\fR]
\fBfile ...\fR
.SH "DESCRIPTION"
.B img2eps
packages each
\fBfile\fR
into an EPS (Embedded PostScript) file, using whatever PostScript
features are advantageous.
The default name for each output file is the name of the input file
with its extension changed to
.I .eps.
Supported image file formats are:
.RS
.IP \(bu 
GIF
.IP \(bu 
JPEG
.IP \(bu 
PNG
.IP \(bu 
TIFF
.IP \(bu 
XPM
.RE
.PP
If possible, the compressed image data is copied directly to the EPS file.
.SH "The Options"
.RS
.TP 20
\fB-1\fR
Use only features present in PostScript language level 1.
.TP 20
\fB-2\fR
Use only features present in PostScript language level 2.
.TP 20
\fB-3\fR
Explicitly allow the use of PostScript language level 3 features.
.TP 20
\fB-a\fR \fBENC\fR
.TP 20
\fB--ascii\fR \fBENC\fR
Use
\fBENC\fR
ASCII encoding for binary data.
Supported encodings are:
.RS
.IP \(bu 20
ASCII85
.IP \(bu 20
ASCIIHEX
.RE
.TP 20
\fB--bottom-margin\fR \fBM\fR
Set bottom margin to
\fBM.\fR
.TP 20
\fB-C\fR \fBC\fR
.TP 20
\fB--compress\fR \fBC\fR
Use compression method
\fBC\fR
for image data.
Supported compression methods are:
.RS
.IP \(bu 20
DCT (jpeg)
.IP \(bu 20
Flate (zlib)
.IP \(bu 20
LZW
.IP \(bu 20
RunLength (PackBits)
.RE
.TP 20
\fB-c\fR
.TP 20
\fB--stdout\fR
Write EPSF to standard output.
If this option is used, only one input file may be specified.
.TP 20
\fB-G\fR \fBG\fR
.TP 20
\fB--gravity\fR \fBG\fR
Specify the placement of image within the printable area of the page.
The gravity can be either a pair of numbers (see below) in the range
of 0 to 1 inclusive, which specify how much of the free space is
placed to the left / above the image, or one of the following
pre-defined settings:
.RS
.IP \(bu 20
top-left
.IP \(bu 20
top
.IP \(bu 20
top-right
.IP \(bu 20
left
.IP \(bu 20
center
.IP \(bu 20
right
.IP \(bu 20
bottom-left
.IP \(bu 20
bottom
.IP \(bu 20
bottom-right
.RE
.TP 20
\fB-g\fR
.TP 20
\fB--gray\fR
Convert image to grayscale.
.TP 20
\fB-height\fR \fBH\fR
Specify the height of the image to be
\fBH,\fR
which should be a dimen (see below).
The width will be computed to keep the aspect ratio of the original image.
.TP 20
\fB-h\fR
.TP 20
\fB--help\fR
Display a short help message.
.TP 20
\fB--ignore-order\fR
Ignore pixel order information from image and assume row major
left to right, top to bottom.
.TP 20
\fB--left-margin\fR \fBM\fR
Set left margin to
\fBM,\fR
which should be a dimen (see below).
.TP 20
\fB--level\fR \fBL\fR
Use only features present in PostScript language level
\fBL.\fR
Alternatively, you can also use the
\fB-1\fR,
\fB-2\fR,
and
\fB-3\fR
options.
.TP 20
\fB-m\fR \fBM\fR
.TP 20
\fB--margin\fR \fBM\fR
Set all margins to
\fBM,\fR
which should be a dimen (see below).
.TP 20
\fB-n\fR
.TP 20
\fB-dry-run\fR
Don't create EPSF, only print information about what would have been done.
.TP 20
\fB-O\fR \fBO\fR
.TP 20
\fB--orientation\fR \fBO\fR
Set orientation (rotation) of image:
.RS
.TP 15
portrait
Don't rotate image.
.TP 15
landscape
Rotate image 90 degrees counter-clockwise.
.TP 15
upside-down
Rotate image 180 degrees.
.TP 15
seascape
Rotate image 90 degrees clockwise.
.TP 15
auto
Use portrait or landscape, whichever fits the image better.
.RE
.TP 15
\fB-o\fR \fBFILE\fR
.TP 15
\fB--output\fR \fBFILE\fR
Write EPSF to output file
\fBFILE.\fR
If this option is used, only one input file may be specified.
.TP 15
\fB-P\fR \fBP\fR
.TP 15
\fB--paper\fR \fBP\fR
Set paper size to
\fBP.\fR
The paper size can be specified either as a pair of dimens (see
below), or by using one of the following pre-defined sizes:
.RS
.IP \(bu 15
10x14
.IP \(bu 15
A3, A4, A5
.IP \(bu 15
B4, B5
.IP \(bu 15
executive
.IP \(bu 15
folio
.IP \(bu 15
ledger
.IP \(bu 15
legal
.IP \(bu 15
letter
.IP \(bu 15
quarto
.IP \(bu 15
statement
.IP \(bu 15
tabloid
.RE
.TP 15
\fB-r\fR \fBR\fR
.TP 15
\fB--resolution\fR \fBR\fR
Specify the resolution to print the image at, in dpi (dots per inch).
\fBR\fR
can be a number to specify equal horizontal and vertical resolution
or a pair of numbers (see below) to specify horizontal and vertical
resolutions separately.
.TP 15
\fB-R\fR
.TP 15
\fB--recompress\fR
Force recompression of image data, even if a direct copy would be
possible.  This might be necessary since PostScript stricter image
data constraints than other image manipulation software.
.TP 15
\fB--right-margin\fR \fBM\fR
Set right margin to
\fBM,\fR
which should be a dimen (see below).
.TP 15
\fB-S\fR \fBS\fR
.TP 15
\fB--size\fR \fBS\fR
Specify the size of the printed image.
\fBS\fR
should be a pair of dimens (see below).
.TP 15
\fB--top-margin\fR \fBM\fR
Set top margin to
\fBM,\fR
which should be a dimen (see below).
.TP 15
\fB-V\fR
.TP 15
\fB--version\fR
Display version number.
.TP 15
\fB-width\fR \fBW\fR
Specify the width of the image to be
\fBW,\fR
which should be a dimen (see below).
The height will be computed to keep the aspect ratio of the original image.
.RE
.SS "Dimens and Pairs"
A dimen is a number optionally followed by a unit.
Supported units are:
.RS
.IP \(bu 15
cm
.IP \(bu 15
in
.IP \(bu 15
mm
.IP \(bu 15
pt (PostScript point, 1/72in)
.RE
If no unit is specified, pt is assumed.
.PP
A pair of numbers should be separated by any one of
.Sq x,
.Sq *,
or
.Sq \&,.
.PP
A pair of dimens is a pair of numbers optionally followed by a unit,
which applies to both numbers of the pair.
.SS "Language Levels"
There are three major versions of PostScript, called Language Levels:
.PP
Language Level 1 only supports ASCIIHEX encoded, uncompressed images
and does not support indexed (paletted) images.
.PP
Language Level 2 adds support for ASCII85 encoding and various
compression schemes, 12 bit samples, and indexed images.
Most PostScript printers support Language Level 2.
.PP
Language Level 3 adds support for Flate (zlib) compression, a
patent-free lossless compression scheme.
Ghostscript supports Language Level 3, as do most PostScript colour
printers.
.SS "Default Parameters"
The default value for any parameter not specified via command line
options is derived from the image:
.PP
The color space type is taken from the image.
However, for language level 1, indexed images are converted to their
base color space.
.PP
An unsupported depth is converted to the next higher supported depth,
if it exists, or the highest supported depth (8 for language level 1,
12 for language level 2 or 3).
.PP
If direct copy of the compressed image data is supported, the
compression method of the image is used.
If the image is compressed with DCT (jpeg), DCT compression is used
even if recompression is necessary.
Otherwise, the best lossless compression method available is used,
which is Flate for language level 3 and LZW for language level 2.
Language level 1 disallows compression altogether.
.PP
ASCII85 encoding is used for language level 2 or 3, ASCIIHEX for
language level 1.
.PP
If no language level is specified, the lowest level that supports the
color space type, depth, and, for direct copy or DCT encoding, the
compression method used.
.SH "EXIT STATUS"
The
.B img2eps
utility exits 0 on success, and \*[Gt]0 if an error occurs.
.SH "SEE ALSO"
gs(1)
.Rs
.%A Adobe Systems Incorporated
.%B PostScript Language Reference, 3rd edition
.%D 1999
.Re
.SH "AUTHORS"
.B img2eps
was written by
Dieter Baron <dillo@giga.or.at.>
.PP
The manual page was written with the help of
Thomas Klausner <tk@giga.or.at.>
.PP
The LZW compression routines and various library function replacements
(for portability) were taken from the NetBSD Project.
.SH "BUGS"
Since PostScript's JPEG decoder is stricter than most software
implementations, directly copying JPEG compressed data causes
PostScript errors for some images.  This is not detected by
.Nm.
Use
\fB-R\fR ( \-recompress )
for such images.
.PP
Emulation of the colorimage operator is provided only for 8bit RGB
images.
(The presence of the operator is assumed for other color formats.)
.PP
Predictor functions (for LZW or Flate compression) are not supported.
.PP
TIFF images that include more than one extra sample per pixel, or use
separated planar or tiled layout, are not supported.
Direct copy of LZW compressed TIFF images using the old (bit-swapped)
format is not supported and may result in broken EPS files.
.PP
Multi-page GIF images are not supported.
