#ifndef UI_UI_H
#define UI_UI_H

#include <stdlib.h>
///@name ui
//@{
enum UITYPE_ {
	UITYPE_BUTTON = 1,
	UITYPE_BUTTONOK,
	UITYPE_BUTTONCANCEL,
	UITYPE_EDIT,
	UITYPE_EDIT_LONG,
	UITYPE_CHECK,
	UITYPE_RADIOSTART,
	UITYPE_RADIO,
	UITYPE_RADIOSTOP,

	UITYPE_TEXT,
	UITYPE_BOXSTART,
	UITYPE_BOXSTOP,

	UITYPE_COLUMN_START_2,
	UITYPE_COLUMN_STOP,

	UITYPE_NONE = 0
};

enum UINOTIFY_ {
///This control is about to be initialized, the notify function should set it's values. 
	UINOTIFY_INIT,
///This control has been editted/changed by the user. 
	UINOTIFY_CHANGE,
///This button has been "pushed"/activated. 
	UINOTIFY_ACTIVATED
};

enum UINOTIFYRETURN_ {
///The change was ok
	UINOTIFYRETURN_OK,
///The change was not ok and should be undone
	UINOTIFYRETURN_BAD,
///The user interface should exit the loop after returning.
	UINOTIFYRETURN_EXIT
};

#define UISTATE_NORMAL 0
#define UISTATE_DISABLED 1

#define UIDIALOG_YES 0x01
#define UIDIALOG_NO 0x02
#define UIDIALOG_OK 0x04
#define UIDIALOG_CANCEL 0x08

#define UIDIALOG_YESNO 0x03
#define UIDIALOG_YESNOCANCEL 0x0b
#define UIDIALOG_OKCANCEL 0x0c

#define UIDIALOG_ALLTYPE 0x0f

typedef struct UIEntry {
///The type of control this is.
	int type;
///What identifier it should use for 
	int id;
///The text to show with/on this control
	char *caption;
///The function to call when updated/pressed/set/etc.
//Should ideally be: UIFuncNotifyUIControl
	int (*notifyfunc)(void *, void*, int);
} UIEntry;

#define BLANKUIENTRY {UITYPE_NONE, -1, NULL, NULL}


typedef struct UIControl {
	UIEntry entry;
	int state;
	int value;
	char *stringvalue;
	int oldvalue;
	char *oldstringvalue;
//	void (*freefunc)(struct UIControl *);
//	void (*updatefunc)(struct UIControl *);
} UIControl;

#define BLANKUICONTROL {BLANKUIENTRY, 0, 0, NULL, NULL, NULL}

typedef struct UIControlArrayHandle {
	int size;
	UIControl **data;
} UIControlArrayHandle;

typedef struct UIWindow {
	char *caption;
	UIControlArrayHandle *uica;
	void (*uiwinitfunc)(struct UIWindow *);
	void (*uiwfreefunc)(struct UIWindow *);
	void (*uiwrunfunc)(struct UIWindow *);
	void (*uicsetstatefunc)(struct UIWindow *, int, int);
	void (*uicsetvaluefunc)(struct UIWindow *, int);
	struct UIControl *(*uiaddcontrolfunc)(struct UIWindow *, struct UIEntry *);
} UIWindow;

//#define BLANKUIWINDOW {NULL, NULL}

//typedef void (*UIFuncFreeUIControl)(struct UIControl *);
typedef int (*UIFuncNotifyUIControl)(struct UIWindow *, struct UIControl *, int);
typedef int (*UIFuncNotifyUIControl2)(void *, void *, int);

typedef void (*UIFuncUIWindowInit)(struct UIWindow *);
typedef void (*UIFuncUIWindowFree)(struct UIWindow *);
typedef void (*UIFuncUIWindowRun)(struct UIWindow *);
typedef void (*UIFuncUIControlSetState)(struct UIWindow *, int index, int state);
typedef void (*UIFuncUIControlSetValue)(struct UIWindow *, int index);
typedef struct UIControl *(*UIFuncUIEntryAdd)(struct UIWindow *, struct UIEntry *);

typedef struct UIWindow *(*UIFuncUIWindowMaker)(void);
typedef int (*UIFuncUIDialog)(char *, char *, int, int);
typedef int (*UIFuncUIGetEntropy)(char *, char *, int);



void uiSetFuncs(UIFuncUIWindowMaker uiwmaker, UIFuncUIDialog uid, UIFuncUIGetEntropy uige);

UIWindow *uiwMake(char *caption);
void uiwRun(UIWindow *uiw);
void uiwFree(UIWindow *uiw);
void uiwAddControls(UIWindow *uiw, UIEntry *uiea);
UIControlArrayHandle *uicaMake(void);
void uicaFree(UIControlArrayHandle *uica);
int uicaFind(UIControlArrayHandle *uica, int id);
int uicaClearRadioGroup(UIControlArrayHandle *uica, int index);
void uicaAdd(UIControlArrayHandle *uica, UIControl *uic);
void uicFreeAt(UIControl **uic);
void uieCopyAt(UIEntry *uie, UIEntry *uies);
void uieFree(UIEntry *uie);

void uicEnable(UIWindow *uiw, int id);
void uicDisable(UIWindow *uiw, int id);
void uicSetCheck(UIWindow *uiw, int id, int value);
void uicSetRadio(UIWindow *uiw, int id);
void uicSetString(UIWindow *uiw, int id, char *string);
int uicGetRadio(UIWindow *uiw, int id);
int uicGetValue(UIWindow *uiw, int id);
char *uicGetString(UIWindow *uiw, int id);


int uiDialog(char *title, char *text, int type, int defaultchoice);
int uiGetEntropy(char *title, char *text, int bits);

//@}



#endif //UI_UI_H
