#ifndef PIPE_STEADY_H
#define PIPE_STEADY_H

#include "pipe/pipe.h"
#include <time.h>

typedef struct PipeSteady {
	Pipe	IOPipe;
	int inHandshake;
	int outHandshake;
	int	maxBandwidth;	//bandwidth per second
	int bandwidthCount;	//number of seconds of bandwidth to use/waste
	clock_t lastBandwidth;	//time of last bandwidth gotten
} PipeSteady;

#define BANDWIDTHCOUNT_MAX 10  //maximum number of seconds of backlog there can be.

#define BLANKPIPESTEADY {BLANKPIPE_PIPE, 1, 1, 0, 0, 0}


Pipe *pipesteadyMake(char *pipename, char *options);
void pipesteadyFree(PipeSteady *ps);
void pipesteadyRead(PipeSteady *thispipe, Pipe **errPipe);
void pipesteadyWrite(PipeSteady *thispipe, Pipe **errPipe);
void pipesteadyAttach(PipeSteady *thispipe);
void pipesteadyDetach(PipeSteady *thispipe);
void pipesteadyClose(PipeSteady *thispipe);
void pipesteadyStatus(PipeSteady *thispipe, int *status);

extern int pipesteadyminimum;
extern int pipesteadymaximum;

#endif //PIPE_STEADY_H


