#ifndef PIPE_C_STREAM_H
#define PIPE_C_STREAM_H

#include "pipe/pipe.h"
#include "net/noderef.h"

typedef struct CryptStream {
	void (*WriteFunc)(struct CryptStream *);
	void (*ReadFunc)(struct CryptStream *);
	void (*FreeFunc)(struct CryptStream *);
	Pipe *ParentPipe;
	NodeRef *noderef;
} CryptStream;

typedef CryptStream *(*CSMakeFunc)(char *, char *);
typedef void (*CSFreeFunc)(CryptStream *);
typedef void (*CSReadFunc)(CryptStream *);
typedef void (*CSWriteFunc)(CryptStream *);



typedef struct CryptStreamProtocolEntry {
	char *csname;
	CSMakeFunc csmakefunc;
} CryptStreamProtocolEntry;

typedef struct CryptStreamProtocolArrayHandle {
	int size;
	CryptStreamProtocolEntry *data;
} CryptStreamProtocolArrayHandle;

#define BLANKCRYPTSTREAMPROTOCOLENTRY {NULL, NULL}

void csInit(void);
void csAddList(CryptStreamProtocolEntry *cspelist);

CryptStream *csMake(char *csname, char *options);
void csFree(CryptStream *cs);
void csRead(CryptStream *cs);
void csWrite(CryptStream *cs);



#endif //PIPE_C_STREAM_H
