#ifndef PIPE_BACKWARD_H
#define PIPE_BACKWARD_H

#include "pipe/pipe.h"
#include <stdlib.h>

typedef struct PipeBackward {
	Pipe	IOPipe;
	Pipe	DummyPipe;
	Pipe	*BackwardPipe;
} PipeBackward;

#define BLANKPIPEBACKWARD {BLANKPIPE_PIPE, BLANKPIPE_PIPE, NULL}


Pipe *pipebackwardMake(char *pipename, char *options);
void pipebackwardFree(PipeBackward *thispipe);
void pipebackwardRead(PipeBackward *thispipe, Pipe **errPipe);
void pipebackwardWrite(PipeBackward *thispipe, Pipe **errPipe);
void pipebackwardAttach(PipeBackward *thispipe);
void pipebackwardDetach(PipeBackward *thispipe);
void pipebackwardClose(PipeBackward *thispipe);
void pipebackwardStatus(PipeBackward *thispipe, int *status);


#endif //PIPE_BACKWARD_H

