#ifndef NET_PROTOCOL_H
#define NET_PROTOCOL_H

#include "pipeface/pipeface.h"
#include "net/sock.h"
#include "base/strarray.h"

#define PROTOCOL_DEFAULTPORT 1796

typedef Pipe *(*PipeProtocolMake)(char *, char *);
typedef PipeFace *(*PipeFaceProtocolMake)(char *, char *);

typedef struct PipeProtocolEntry {
	char *pipename;
	PipeProtocolMake make;
} PipeProtocolEntry;

typedef struct PipeFaceProtocolEntry {
	char *pipename;
	PipeFaceProtocolMake make;
} PipeFaceProtocolEntry;

typedef struct PipeProtocolArrayHandle {
	int size;
	PipeProtocolEntry *data;
} PipeProtocolArrayHandle;

typedef struct PipeFaceProtocolArrayHandle {
	int size;
	PipeFaceProtocolEntry *data;
} PipeFaceProtocolArrayHandle;

#define BLANKPIPEPROTOCOLENTRY {NULL, NULL}
#define BLANKPIPEFACEPROTOCOLENTRY {NULL, NULL}

PipeFace *protocolBuildPipe(SockHandle *sh, char *protocol);

void protocolInit(void);
void protocolAddPipeList(PipeProtocolEntry *ppelist);
void protocolAddPipeFaceList(PipeFaceProtocolEntry *pfpelist);
void protocolClearPipeList(void);
void protocolClearPipeFaceList(void);


//internal functions
Pipe *protocolGetPipe(char *pipename, char *options);
PipeFace *protocolGetPipeFace(char *pipefacename, char *options);

#endif //NET_PROTOCOL_H

