#ifndef NET_NODEREF_H
#define NET_NODEREF_H

#include "base/itag.h"
#include "base/strarray.h"

typedef struct NodeRef {
	char *HostName;		//
	char *Protocol;
	char *Transport;
	char *PublicKey;
	char *PrivateKey;
	char *Special;
	char *netname;
	char *version;
	int PortNum;		//
	ITag iTag;			//internal tag
} NodeRef;

// extended node reference
typedef struct ENodeRef {
	NodeRef *noderef;
//	char *HostName;
//	char *Protocol;
//	int PortNum;
//	int iTag;
////the above must be identical to NodeRef
	int connectFails;
	int connectSucceded;
} ENodeRef;

typedef struct NodeRefArrayHandle {
	int size;
	NodeRef *data;
} NodeRefArrayHandle;

typedef struct ENodeRefArrayHandle {
	int size;
	ENodeRef *data;
} ENodeRefArrayHandle;

extern ENodeRefArrayHandle *NRA;
extern NodeRefArrayHandle *LNRA;
extern StringIntPair noderefspecials[];

enum NRS_ {
	NRS_ENTRY,
	NRS_EXIT
};

void noderefInit(NodeRef *nr, char *hostname, char *protocol, char *transport, char *publickey, char *privatekey, char *special, char *netname, char *version, int portnum);
void noderefFree(NodeRef *nr);
void noderefMakeAt(NodeRef *nr);
NodeRef *noderefMake(void);
NodeRef *noderefCopy(NodeRef *nr);

void noderefDelete(NodeRef *nr);
void noderefFree(NodeRef *nr);

void enoderefInit(ENodeRef *nr);
void enoderefDelete(ENodeRef *nr);

void nraCheckMake(void);
void lnraCheckMake(void);
ENodeRef *nraAdd(char* hostname);
int nraFindNodeByITag(ITag itag);
NodeRef *lnraAdd(char *hostname);
void lnraDelete(int index);





#endif //NET_NODEREF_H
