//
//message.c
//
//Functions to handle creation/destruction/manipulation of messages.
//
//
//-UserX 2001/11/09

#include "msgcore/message.h"
#include "base/mem.h"
#include "pipeface/pipeface.h"
#include "base/itag.h"

Message blankmessage = BLANKMESSAGE;


//Copy an existing message.
//Datablock fields are copied.
Message *messageClone(Message *msg) {
	Message *msgcpy;
	if(msg == NULL) {
		return messageMake();
	}
	msgcpy = memCopy(msg, sizeof(Message), "Message", NULL);//xiclone(msg, sizeof(Message));

	msgcpy->body = dblockCopy(msgcpy->body);
	//todo: other copy/register actions

	return msgcpy;
}

//Creates a new blank message.
Message *messageMake() {
	Message *msg;
	msg = messageClone(&blankmessage);
	msg->msgitag = itagGet();
	return msg;
}

void messageFree(Message *msg) {
	//pipefaceFree(msg->from);
	dblockFree(msg->body);
	memFree(msg);//xifree(msg);
}

