#ifndef FILE_FILE_H
#define FILE_FILE_H

#include <stdio.h>
#include "misc/compat.h"
#include "base/strarray.h"
///@name file
//@{


typedef struct FileHandle {
	FILE *file;
	void *buffer;
	char *filename;
} FileHandle;

#define BLANKFILEHANDLE {NULL, NULL, NULL}


void fileInit(void);
FILE *fileOpenFile(char *filename, char *mode);
FileHandle *fileOpen(char *filename, char *mode);
void fileClose(FileHandle *fh);
int fileRead(FileHandle *fh, void *buffer, size_t bytes);
int fileReadChar(FileHandle *fh);
int fileWrite(FileHandle *fh, void *buffer, size_t bytes);
int fileWriteChar(FileHandle *fh, int c);
int fileWriteString(FileHandle *fh, char *buffer);
int fileWriteStringKeep(FileHandle *fh, char *buffer);
int fileFlush(FileHandle *fh);
int fileEOF(FileHandle *fh);
int fileError(FileHandle *fh);
void fileClearError(FileHandle *fh);

void fileAddPath(void *extra, char *str);
void fileGetPath(void *extra, StringArrayHandle **sa);
void fileClearPath(void *extra);


extern FileHandle *fhstdin;
extern FileHandle *fhstdout;
extern FileHandle *fhstderr;

extern int filesysactive;

//@}

#endif //FILE_FILE_H
