#ifndef BASE_THREAD_H
#define BASE_THREAD_H

#include "misc/compat.h"
#include "base/itag.h"

#define THREADSTYLE_COOPERATIVE 1	//a single OS thread for the whole program
#define THREADSTYLE_FAMILY 2	//one OS thread for each thread family
#define THREADSTYLE_FULL 3	//one OS thread for each IIP thread

extern int threadstyle;

typedef void (*threadEntry)(int *, void *);


typedef volatile int Mutex;

#define MUTEXBLANK 0;

typedef struct Thread {
	threadEntry entrypoint;
	void *data;
	ITag itag;
} Thread;

typedef struct ThreadArrayHandle {
	int size;
	Thread *data;
} ThreadArrayHandle;

typedef struct ThreadFamily {
	char *familyID;
	ThreadArrayHandle *threads;
} ThreadFamily;

typedef struct ThreadFamilyArrayHandle {
	int size;
	ThreadFamily *data;
} ThreadFamilyArrayHandle;

#define THREADBLANK {NULL, NULL}
#define THREADFAMILYBLANK {NULL, NULL}


void mutexUnlock(Mutex *m);
int mutexLock(Mutex *m);
void mutexLockWait(Mutex *m);


#endif //BASE_THREAD_H
