#ifndef BASE_MEM_H
#define BASE_MEM_H

#include <stdlib.h>

///@name memory
//@{

//new memory functions
int memTagCheck(void *membuffer);
void memTagAdd(void *membuffer);
void memTagDelete(void *membuffer);
int memUnknown(void *membuffer);

void memInit(void);
void memTagExpandFree(void);
void memTagExpandList(void);


void *memAlloc(size_t memsize, char *group, char *subgroup);
void memFree(void *membuffer);
void memSafeFree(void *membuffer);
void *memResize(void *membuffer, size_t memsize);
void *memClone(void *membuffer);
void *memCopy(void *membuffer, size_t memsize, char *group, char *subgroup);


char *memGetSubgroup(void *membuffer);
char *memGetGroup(void *membuffer);


void memDump(void);

//@}

#endif //BASE_MEM_H
