/*hack of getch() emulation in linux using termios.h - 0x90 */
#include <termios.h>
#include <stdio.h>

#include "base/getch.h"

int getch()
{
  struct termios term, original;
  char c;

  /* get terminal attributes */
  if(tcgetattr(fileno(stdin), &term) < 0)
    {
      perror("error getting terminal information");
      return -1;
    }
  
  original = term;       /* save Terminal Attributes */

  /* switch off echo and canonical mode */
  term.c_lflag &= ~ICANON;
  term.c_lflag &= ~ECHO;
 
  /* set terminal attributes */
  if(tcsetattr(fileno(stdin), TCSANOW, &term) < 0)
    {
      perror("error setting terminal information");
      return -1;
    }

  /* get the character */
  c=getchar();

  /* set original terminal attributes */
  if(tcsetattr(fileno(stdin), TCSANOW, &original) < 0)
    {
      perror("error setting terminal information");
      return -1;
    }
  
  return c;
}
