/* Copyright (c) 1991 by John Atwood deVries II. */
/* $Id: send.c,v 1.33 2001/10/30 19:46:20 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* send various messages to the client */

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "externs.h"
#include "protocol.h"
#include "version.h"

void	sendopen (int, int, char *);
void	sendexit (int);
void	sendping (int);
void	senderror (int, char *);
void    sendstatus (int, char *, char *);
void	sends_cmdout (int, char *);
void	sendperson (int, int, char *);
void	sendsavedmessage(char *, int, char *);
void	sendbeep (int, int);
void	s_new_user (int);
void	send_loginok (int);
void	sendimport (int, char *, char *);
static void	doSend (int, int);
static void	autoBeep (int);
void	user_wline (int, char *, char *, int, int, int, char *, char *, char *);
void	user_whead (int);

#define setlen (*pp = (unsigned char) (strlen(pbuf) + 1))

#define PBUFSZ	(USER_BUF_SIZE - 1)

char	packetbuffer[USER_BUF_SIZE];		/* packet buffer */
char	*pbuf = &packetbuffer[1];		/* packet buffer pointer */
char	*pp = packetbuffer;			/* used in auto.c */

/* send normal open group message to the client */
void
sendopen(int n, int i, char *txt)
{
	filtertext(txt);
	/* construct open message */
	snprintf(pbuf, PBUFSZ, "%c%s\001%s", ICB_OPEN, u_tab[n].nickname, txt);
	doSend(n, i);
}

/* send an exit message to the client -- makes the client disconnect */
void
sendexit(int n)
{
	/* construct exit message */
	snprintf(pbuf, PBUFSZ, "%c",ICB_EXIT);
	doSend(-1, n);
}

/* send a ping */
void
sendping(int n)
{
	/* construct pint message */
	snprintf(pbuf, PBUFSZ, "%c",ICB_PING);
	doSend(-1, n);
}


/* send an error message to the client */
void
senderror(int n, char *error_string)
{
	filtertext(error_string);
        snprintf(pbuf, PBUFSZ, "%c%s", ICB_ERROR, error_string);
	doSend(-1, n);
}

/* send a status message to the client */
void
sendstatus(int n, char *class_string, char *message_string)
{
	filtertext(class_string);
	filtertext(message_string);
        snprintf(pbuf, PBUFSZ, "%c%s\001%s", ICB_STATUS, class_string, message_string);
	doSend(-1, n);
}

/* send simple command output message to the client */
void
sends_cmdout(int n, char *output_string)
{
	filtertext(output_string);
      	snprintf(pbuf, PBUFSZ, "%c%s\001%s", ICB_CMDOUT, "co", output_string);
	doSend(-1, n);
}

/* send personal message to a client */
void
sendperson(int from, int to, char *message_string)
{
	char line[LINE_SIZE], nick[MAX_NICKLEN+1];

	filtertext(message_string);
        snprintf(line, LINE_SIZE, "%s@%s", u_tab[from].loginid, u_tab[from].nodeid);
        ucaseit(line);
        strlcpy(nick, u_tab[from].nickname, MAX_NICKLEN + 1);
        ucaseit(nick);

	if ((!nlmatch(line, *u_tab[to].pri_s_hushed)) && (!nlmatch(nick, *u_tab[to].pri_n_hushed))) {
        	snprintf(pbuf, PBUFSZ, "%c%s\001%s", ICB_PERSONAL, u_tab[from].nickname, message_string);
		doSend(from, to);
	} else
		sendstatus(from, "Bounce", "Message did not go through");
}

/* send personal message to a client when we only know the senders *name*, such as when retrieving a message from someone not logged in */
void
sendsavedmessage(char *from, int to, char *message_string)
{
	snprintf(pbuf, PBUFSZ, "%c%s\001%s", ICB_PERSONAL, from, message_string);
	doSend(-1, to);
}

/* send beep message to a client */
void
sendbeep(int from, int to)
{
	char	line[LINE_SIZE];
	if ( u_tab[to].nobeep != 0 )
	{
	    senderror(from, "User has nobeep enabled.");

	    if ( u_tab[to].nobeep == 2 )
	    {
		snprintf (line, LINE_SIZE, "%s attempted (and failed) to beep you", u_tab[from].nickname);
		sendstatus (to, "No-Beep", line);
	    }

	    return;
	}
        snprintf(pbuf, PBUFSZ, "%c%s", ICB_BEEP, u_tab[from].nickname);
	doSend(from, to);
}

void
s_new_user(int n)
{
	char	*cp;
	char	line[LINE_SIZE];

        /* construct proto(col) message */
        snprintf(pbuf, PBUFSZ, "%c%d\001%s\001%s",ICB_PROTO,PROTO_LEVEL, thishost, VERSION);
	doSend(-1, n);
        cp = getremotename(n);
        if (cp == NULL) {
		snprintf(line, LINE_SIZE, "[CONNECT] %d", n);
		MDB(line);
		return;
		}
        if (strlen(cp) == 0) {
		snprintf(line, LINE_SIZE, "[CONNECT] %d", n);
		MDB(line);
		return;
		}
	snprintf(line, LINE_SIZE, "[CONNECT] %d: %s", n, cp);
	strlcpy(u_tab[n].nodeid, cp, MAX_NODELEN);
	MDB(line);
}

void
send_loginok(int n)
{
	/* construct loginok message */
	snprintf(pbuf, PBUFSZ, "%c",ICB_LOGINOK);
	doSend(-1, n);
}

/* send an important message to the client */
void
sendimport(int n, char *class_string, char *output_string)
{
	filtertext(class_string);
	filtertext(output_string);
        snprintf(pbuf, PBUFSZ, "%c%s\001%s", ICB_IMPORTANT, class_string, output_string);
	doSend(-1, n);
}

static void
doSend(int from, int to)
{
	int ret;
	char line[LINE_SIZE];

	if(to < 0) {
		error("Attempted to send to negative fd: %d", to);
		return;
		}
	if(to >= MAX_REAL_USERS) {
		*pp = ' ';
		switch (*(pp+1)) {
		case ICB_BEEP: /* someone beeped us */
			autoBeep(from);
			break;
		case ICB_PERSONAL: /* someone sent us a message */
			/* autoCommand(from, 1); */
			split(pp);
			snprintf(line, LINE_SIZE, "%s\001%s", getword(fields[1]), 
				get_tail(fields[1]));
			cmdmsg(from, line);
			break;
		default: /* do nothing -- ignore */
			break;
		}
	} else {
		if (strlen(pbuf) > 254) {
			error("doSend: pbuf too large:");
			error(pbuf);
			snprintf (line, LINE_SIZE, "Cannot transmit packet: too large");
			senderror(from, line);
			return;
			}
		if (S_kill[to] > 0) return;
		setlen;
		if ((ret = sendpacket(to,pp)) < 0) {
			error("doSend: %d: %s (%d)",
				to, strerror(errno), ret);
			if (ret == -2) {
				/* bad news! */
				S_kill[to]++;
				/* need to clear the notifies of this user,
				   lest he try to someone else who's dead
				   who has this guy in his notify. Endless
				   loop! */
				/* Don't know if it's still needed, but it
				   doesn't hurt */
				nlclear(u_tab[to].n_notifies);
				nlclear(u_tab[to].s_notifies);
				}
			}
	}
}

static void
autoBeep(int n)
{
	sendperson(NICKSERV, n, "Beep yerself!");
	u_tab[NICKSERV].t_recv = time(NULL);
}

/*
	Copyright (c) 1991 by Keith Graham
	Modifications Copyright (c) 1991 by John Atwood deVries II

	"to" is the destination socket..
*/

void
user_wline(int to, char *mod, char *nick, int idle, int resp, int login, char *user, char *site,char *name)
{ 
	snprintf(pbuf, PBUFSZ, "%cwl\001%s\001%s\001%d\001%d\001%d\001%s\001%s\001%s",
			ICB_CMDOUT, mod, nick, idle, resp, login, user, site, name);
	doSend(-1, to);
}

void
user_whead(int to)
{ 
	snprintf(pbuf, PBUFSZ, "%cwh",ICB_CMDOUT);
	doSend(-1, to);
}
