/* Copyright (c) 1991 by John Atwood deVries II. */
/* For copying and distribution information, see the file COPYING. */
/* $Id: ipcf.c,v 1.15 2001/10/30 05:09:03 jwise Exp $ */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include "externs.h"

#define IDLE_WARN 240	/* If you change this, change the warning message */
#define MOD_TIMEOUT 300

void	s_didpoll (int);
void	s_lost_user (int);
void	s_packet (int, char *);

void
s_didpoll(int n)
{
	int i, j, newmod;
	long TheTime;
	char line[LINE_SIZE];

	if (n == 1) {
		/* do nothing on the frequent polls */
	} else {
		TheTime = time(NULL);
		if ((TheTime >= TimeToDie) && (TimeToDie > 0.0))
			icbexit(0);
		if (((TheTime >= (TimeToDie - 300)) && (TimeToDie > 0.0)) &&
		   (ShutdownNotify == 0)) {
			for (i = 0; i < MAX_REAL_USERS; i++)
				if (u_tab[i].login == 1)
				   sendimport(i, "Shutdown",
				     "Server shutting down in 5 minutes!");
			ShutdownNotify++;
			}
		if (((TheTime >= (TimeToDie - 60)) && (TimeToDie > 0.0)) &&
		   (ShutdownNotify == 1)) {
			for (i = 0; i < MAX_REAL_USERS; i++)
				if (u_tab[i].login == 1)
				   sendimport(i, "Shutdown",
				     "Server shutting down in 1 minute!");
			ShutdownNotify++;
			}
		for(i=0;i<MAX_REAL_USERS;i++)
		   if(S_kill[i] > 0) {
			snprintf(line, LINE_SIZE, "[KILL] killing %d (%d)", i, S_kill[i]);
			MDB(line);
			disconnectuser(i);
			}
		for(i=0;i<MAX_GROUPS;i++)
			if ((g_tab[i].modtimeout > 0.0) &&
			    (g_tab[i].modtimeout < TheTime)) {
		   		newmod = -1;
		   		for (j=0; j<MAX_USERS; j++) 
					if ((u_tab[j].login == 1) && (strcasecmp(u_tab[j].group,g_tab[i].name) == 0))
					{
						if (newmod == -1)
							newmod = j;
						else if ((u_tab[j].t_recv - u_tab[newmod].t_recv) > 0)
							newmod = j;
					}
		   		g_tab[i].mod = newmod;
				g_tab[i].modtimeout = 0.0;
				g_tab[i].missingmod[0] = '\0';
		   		snprintf(line, LINE_SIZE, "%s is now mod.", u_tab[newmod].nickname);
		   		s_status_group(2,0,i, "Timeout", line);
			}
		for(i=0;i<MAX_REAL_USERS;i++) {
			/* look at folx who are logged in */
			if(u_tab[i].login == 1) {
				if((TheTime - u_tab[i].t_recv) > MAX_IDLE) {
					/* kill that puppy */
					snprintf(line, LINE_SIZE, "[TIMEOUT] %d (%ld - %ld > %d)", i, TheTime, u_tab[i].t_recv, MAX_IDLE);
					MDB(line);
					sendstatus(i, "Drop", 
					 "Your connection has been idled out.");
					disconnectuser(i);
					icbdump(0); /*DeBuG*/
					}
				else if ((TheTime - u_tab[i].t_recv)
					> (MAX_IDLE - IDLE_WARN)) {
					if (u_tab[i].t_notify == 0) {
					   sendstatus (i, "Drop", 
					      "Your connection will be dropped in 4 minutes due to idle timeout.");
					   u_tab[i].t_notify++;
					   }
					}
				else u_tab[i].t_notify = 0;
			}
		}
	}
}

void
s_lost_user(int n)
{
	/* n is fd of lost user */
	int num_left;
	int was_mod;
	int ogi;
	char t_grp[MAX_GROUPLEN+1];
	char t_name[MAX_NICKLEN+1];
	char t_fid[512];
	int i, j;
	char one[LINE_SIZE], two[LINE_SIZE], three[LINE_SIZE];
	char line[LINE_SIZE];
	int  newmod, was_registered, is_killed;
	long TheTime, UserTime;

	if (n >= MAX_REAL_USERS) {
		snprintf(line, LINE_SIZE, "[LOST] %d", n);
		MDB(line);
		return;
	}

	/* Make sure the user was logged in at all */
	if (u_tab[n].login == 0) {
		snprintf(line, LINE_SIZE, "[LOST] %d", n);
		MDB(line);
		/* they were NOT logged in */
		/* just clear their entry and return */
		clear_user_item(n);
		return;
	} else {
		snprintf(line, LINE_SIZE, "[LOST] %d: %s@%s", n, u_tab[n].loginid, u_tab[n].nodeid);
		MDB(line);
	}

	/* save stuff we want to know about the user */
	if (strlen(u_tab[n].realname) > 0)
		was_registered = 1;
	else
		was_registered = 0;
	is_killed = S_kill[n];
	UserTime = u_tab[n].t_recv;
	strlcpy(t_grp, u_tab[n].group, MAX_GROUPLEN+1);

	strlcpy(t_name, u_tab[n].nickname, MAX_GROUPLEN+1);

        snprintf(t_fid, 512, "%s (%s@%s)", u_tab[n].nickname, u_tab[n].loginid, u_tab[n].nodeid);

	two[0] = '\0';
	snprintf(one, LINE_SIZE, "%s@%s", u_tab[n].loginid, u_tab[n].nodeid);
	ucaseit(one);
	strlcpy(three, u_tab[n].nickname, LINE_SIZE);
	ucaseit(three);
	for (j = 0; j < MAX_USERS; j++)
		if ((n != j) && (u_tab[j].login > 0)) {
			if ((nlmatch(three, *u_tab[j].n_notifies)
					|| nlmatch(one, *u_tab[j].s_notifies))
					&& (g_tab[find_group(u_tab[n].group)].visibility != SUPERSECRET)) {
				snprintf (two, LINE_SIZE, "%s (%s) has just signed off", u_tab[n].nickname, one);
				sendstatus(j, "Notify-Off", two);
			}
		}

	/* clear the user from the user table to keep searches from finding them. */
	clear_user_item(n);

	/* At least they were logged in */

	/* find out what group they are in */
	/* note: they may be moderator of a group they are NOT in */

	ogi = find_group(t_grp);
	if (ogi < 0) return;

	/* check if there are any users left in present group */
	num_left = count_users_in_group(t_grp);

	if ( num_left > 0) {
		/* tell remaining group members user left */
		TheTime = time(NULL);
		if (is_killed > 0)
			snprintf(line, LINE_SIZE, "%s has been disconnected.", t_fid);
		else if((TheTime - UserTime) > MAX_IDLE)
			snprintf(line, LINE_SIZE, "%s has idled out.", t_fid);
		else
			snprintf(line, LINE_SIZE, "%s has signed off.", t_fid);
		if(g_tab[ogi].volume != QUIET)
			s_status_group(2,0,ogi, "Sign-off", line);
	} else {
		/* otherwise zap the group he was in */
		clear_group_item(ogi);
	}

	/* check if user was mod of any group */
	was_mod = check_mods(n);

	/* if was mod, check if there are any users left in moderated group */
	if (was_mod >= 0) {
		num_left =
			count_users_in_group(g_tab[was_mod].name);
		if ( num_left > 0) {
			/* if, additionally, the user was mod,
			   tell them that too. */
		if (was_registered == 0) {
		   if(g_tab[was_mod].volume != QUIET)
			s_status_group(2,0,was_mod, "Sign-off", 
			   "Your group moderator signed off. (No timeout)");
		   newmod = -1;
		   for (i=0; i<MAX_USERS; i++) 
			if ((u_tab[i].login == 1) && (strcasecmp(u_tab[i].group,g_tab[was_mod].name) == 0))
			{
				if (newmod == -1)
					newmod = i;
				else if ((u_tab[i].t_recv - u_tab[newmod].t_recv) > 0)
					newmod = i;
			}
		   g_tab[was_mod].mod = newmod;
		   snprintf(line, LINE_SIZE, "%s is now mod.", u_tab[newmod].nickname);
		   s_status_group(2,0,was_mod, "Pass", line);
		   }
		else {
		   snprintf(line, LINE_SIZE, "Your group moderator signed off. (%d second timeout)", (int) MOD_TIMEOUT);
		   s_status_group(2,0,was_mod, "Mod", line);
		   g_tab[was_mod].mod = -1;
		   strlcpy(g_tab[was_mod].missingmod, t_name, MAX_NICKLEN);
		   TheTime = time(NULL);
		   g_tab[was_mod].modtimeout = TheTime + MOD_TIMEOUT;
		   }
		}
	}

	

}

void
s_packet(int x, char *pkt)
{
	/* go figure out what kind of packet */
	dispatch(x, ++pkt);	
}
