/* HRE  ٽ header.
   Copyright (C) 2002, 2003, 2004 HRE  ׷

This file is part of Hangul Regular Expression Library (aka HRE).

HRE is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

HRE is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef HRE_CORE_H
#define HRE_CORE_H

#include "hre.h"
#include "lexical.h"


/* ڰ Է  ǥ мϴ  ش  ǥ ǥϴµ,
    ϴµ, Է  ǥϱ  ̴.
    ؼϰ ִ  ¸ Ÿ ִ.

   NOTE : ݵ  hre_action ü  ̸  ־ ϸ, 
   ٸ ǥ ߰  hre_action   ־ Ѵ.  */
typedef enum
{
  RULE,		/* RULE:          -> ǥ $ */
  PAR,		/* PAR:   ǥ  -> '(' ǥ $ ')'    */
  LPAR,		/* LPAR:  ǥ  -> '{' ǥ $ '}'    */
  OPT,		/* OPT:   ǥ  -> '[' ǥ $ ']'    */
  ROPT,
  OR,		/* OR:    ǥ  -> ǥ '|' ǥ $    */
  BAR,		/* BAR:   ǥ  -> ǥ '-' ǥ $    */
  CORON,	/* CORON: ǥ  -> ǥ ':' ǥ $    */
  COMMA,	/* COMMA: ǥ  -> ǥ ',' ǥ $    */
  AND,		/* AND:   ǥ  -> ǥ ǥ $        */
  SSAC,		/* SSAC:  ǥ  -> ^ ǥ $		*/
  HAN,		/* HAN:   ǥ  -> '<' ǥ '>'      */
  HAN_COMMA,
  HAN_OR,
  HAN_BAR,
  MAX_STACK_TAG
} stack_tag;

/* ļ Ʈ ϳ 尡   ִ . ο   ߰ 
   ,   ؼ Ʒ exp_tag_name   ǥ ڸ ߰ϱ
   ٶ.   exp_tag  1  1 ؾ Ѵ.  */
#define DEF_EXP_TAG(SYM, STR) SYM,
typedef enum
{
#include "exp_tag.def"
  MAX_EXP_TAG_X
} exp_tag;
#undef DEF_EXP_TAG
 
/* EXP_TAG    ִ ִ tag .  */
#define MAX_EXP_TAG		256

#define STACK_TAG(DUMMY)	((DUMMY)->tag)
#define STACK_Q(DUMMY)		((DUMMY)->q)

/*  stack_tag    ü.  */
struct stack_dummy
{
  stack_tag tag;
  int q;
};

#define SYM_NAME(SYM)		((SYM)->name)
#define SYM_HASH(SYM)		((SYM)->hash)
#define SYM_NEXT(SYM)		((SYM)->next)
#define SYM_TAIL(SYM)		((SYM)->tail)
#define SYM_LENGTH(SYM)		((SYM)->length)

/* ڰ Է  ǥĿ ؼ, IDENTIFIER  ϴ
   symbol table ̸,  ̸ ؼ DAG  ϰ ȴ.  */
struct symbol
{
  char * name;			/* IDENTIFIER  ̸ */
  int hash;			/* IDENTIFIER  HASH  */

  int length;			/* IDENTIFIER   */
  struct symbol * next;
  struct symbol * tail;
};

/*  ʿ */
#define EXP_BODY(EXP)		((EXP)->body)
#define EXP_UARG(BODY)		((BODY).arg)
#define EXP_UARG_N(BODY, N)	((BODY).arg[(N)])
#define EXP_ULEAF(BODY)		((BODY).leaf)
#define EXP_BODY_ARG_N(EXP, NUM)	(EXP_UARG_N (EXP_BODY((EXP)), (NUM)))
#define EXP_BODY_LEAF(EXP)		(EXP_ULEAF (EXP_BODY((EXP))))
#define EXP_BODY_ARG(EXP)		(EXP_UARG (EXP_BODY((EXP))))
#define EXP_TAG(EXP)		((EXP)->tag)
#define EXP_ARGS(EXP)		((EXP)->args)
#define EXP_TAIL(EXP)		((EXP)->tail)
#define EXP_CLASS(EXP)		((EXP)->class)
#define EXP_HASH(EXP)		((EXP)->hash)

/* տ ؼ   ǥ Ÿ ü.  ߰  ʿ.  */
struct exp
{
  exp_tag tag;
  int hash;
  int class;
  int args;
  struct exp * tail;
  union {
    struct symbol * leaf;
    int * arg;
  } body;
};

#define EQU_VALUE(VAL)		((VAL).value)
#define EQU_HASH(VAL)		((VAL).hash)
#define EQU_STACK(VAL)		((VAL).stack)
#define EQU_INDEX(VAL)		((VAL).index)

/*  ʿ.  */
struct equation
{
  struct exp * value;
  int hash;
  unsigned stack:1;
  int index;
};

#define ITEM_LHS(I)		((I).lhs)
#define ITEM_RHS(I)		((I).rhs)
#define ITEM_RHS_P(I)		((I)->rhs)
#define ITEM_RHS_P_N(I, N)	((I)->rhs[(N)])
#define ITEM_SIZE(I)		((I).size)
#define ITEM_SIZE_P(I)		((I)->size)
#define ITEM_INDEX(I)		((I).index)

struct item
{
  struct symbol * lhs;
  int * rhs;
  int size;
  int index;
};

/* ``µ''    ü DFA ȣ ǹѴ.     
   ü  ° DFA ̺ ϴ ü ش.  */
#define STATE_CLASS(S)			((S).class)
#define STATE_CLASS_P(S)		((S)->class)
/*    S_LIST    ü ǥϰ ִ ``ǥ'' 
   (hre_parser () Լ  )   ° ǥ Ÿ ȣ
    迭  ִ.   S_LIST_SIZE  2  ,  ´ 
   ``ǥ'' ϴ ǥ 2  Ÿٴ ̴.  */
#define STATE_S_LIST_SIZE(S)		((S).s_list_size)
#define STATE_S_LIST_SIZE_P(S)		((S)->s_list_size)
/*   ũ⸦ ǥߴٸ, ̰  迭  ̴.  */
#define STATE_S_LIST(S)			((S).s_list)
#define STATE_S_LIST_P(S)		((S)->s_list)
#define STATE_S_LIST_P_N(S, N)		((S)->s_list[(N)])
/*  ̰ 1  Ǿ ִٸ,  ° accept  Ÿ.  */
#define STATE_ACCEPT(S)			((S)->accept)
/* ̰  ¿  Ǿ ϴ   ǹϴµ,  
     3  ,  ¿ 3   ٸ ڰ ġǱ ٸٴ
   ̴.  */
#define STATE_SHIFTS(S)			((S)->shifts)
/*  ǥ shift Ѵٰ ǥ  ִµ,  ش shift 鿡  ü
     ִ.  LHS  RHS  ׻ ѽ Ǹ, LHS  Է ޾Ƶ 
   ڿ  , RHS  ġǴ ڰ ޾Ƶ鿩  ̵ DFA ̺
   ȣ  ִ.  */
#define STATE_SH_LIST(S)		((S)->sh_list)
#define STATE_SH_LIST_N_LHS(S, N)	((S)->sh_list[(N)].lhs)
#define STATE_SH_LIST_N_RHS(S, N)	((S)->sh_list[(N)].rhs)

struct state
{
  int class, s_list_size, *s_list;
  int accept, shifts;
  struct {
    struct symbol * lhs;
    int rhs;
  } * sh_list;
};

#define EQUIV_L(E)			((E).L)
#define EQUIV_R(E)			((E).R)

struct equiv
{
  struct state * L, * R;
};

#define REG_NOMATCH      1
#define REG_BADPAT       2
#define REG_ECOLLATE     3
#define REG_ECTYPE       4
#define REG_EESCAPE      5
#define REG_ESUBREG      6
#define REG_EBRACK       7
#define REG_EPAREN       8
#define REG_EBRACE       9
#define REG_BADBR       10
#define REG_ERANGE      11
#define REG_ESPACE      12
#define REG_BADRPT      13
#define REG_EMPTY       14
#define REG_ASSERT      15
#define REG_INVARG      16

/*     ũⰡ    ʿ䰡 ִ.  */
#define STACK_MAX	1000
/*  ʿ */
#define TOP		((info->sp - 1)->tag)
#define BEFORE_TOP_Q	((info->sp - 1)->q)
#define TOP_Q		((info->sp)->q)
#define POP()		((--info->sp)->q)
/* Symbol ̺ ִ ũ.  */
#define HASH_MAX	0x100
/*  ʿ.  */
#define EXP_MAX		0x200
/*   ڰ Է Խ ؼϴ   struct exp  
   Ѵ.   struct exp     ũ Ǹ,  ޼ 
    ̴.      ʿ䰡  , 0x100  ϴ  
     ̴.  */
#define EXP_FREE_MAX	0x20000
/*  ʿ.  */
#define EQU_EXTEND	0x100
/*  ʿ.  */
#define X_EXTEND	4

#define TREE_OPTIONS(INFO)		((INFO)->options)
#define TREE_STACK(INFO)		((INFO)->stack)
#define TREE_STACK_N(INFO, NUM)		((INFO)->stack[(NUM)])
#define TREE_SP(INFO)			((INFO)->sp)
#define TREE_EQU_TAB(INFO)		((INFO)->equ_tab)
#define TREE_EQU_TAB_N(INFO, NUM)	((INFO)->equ_tab[(NUM)])
#define TREE_EQUS(INFO)			((INFO)->equs)
#define TREE_T_EQUS(INFO)		((INFO)->total_equs)
#define TREE_EQU_MAX(INFO)		((INFO)->equ_max)
#define TREE_EXP_HASH_N(INFO, NUM)	((INFO)->exp_hash[(NUM)])
#define TREE_EXP_FREE_N(INFO, NUM)	((INFO)->exp_free[(NUM)])
#define TREE_TOKENS(INFO)		((INFO)->tokens)
#define TREE_HASHTAB_N(INFO, HASH)	((INFO)->hashtab[(HASH)])
#define TREE_FIRST_B(INFO)		((INFO)->first_b)
#define TREE_LAST_B(INFO)		((INFO)->last_b)
#define TREE_LAST_RHS(INFO)		((INFO)->last_rhs)
#define TREE_ITEM_BUF(INFO)		((INFO)->i_buf)
#define TREE_ITEM_BUF_N(INFO, NUM)	((INFO)->i_buf[(NUM)])
#define TREE_ITEM_S(INFO)		((INFO)->i_s)
#define TREE_ITEM_MAX(INFO)		((INFO)->i_max)
#define TREE_STATE_TAB(INFO)		((INFO)->s_tab)
#define TREE_STATE_TAB_N(INFO, NUM)	((INFO)->s_tab[(NUM)])
#define TREE_STATE_S(INFO)		((INFO)->s_s)
#define TREE_X_STACK(INFO)		((INFO)->x_stack)
#define TREE_X_STACK_N(INFO, NUM)	((INFO)->x_stack[(NUM)])
#define TREE_X_S(INFO)			((INFO)->x_s)
#define TREE_X_MAX(INFO)		((INFO)->x_max)
#define TREE_EQUIV_TAB(INFO)		((INFO)->e_tab)
#define TREE_EQUIV_TAB_N(INFO, NUM)	((INFO)->e_tab[(NUM)])
#define TREE_EQUIV_S(INFO)		((INFO)->e_s)
#define TREE_EQUIV_MAX(INFO)		((INFO)->e_max)
#define TREE_HTMASK(INFO)		((INFO)->htmask)
#define TREE_PAR_STACK_N(INFO, NUM)	((INFO)->par_stack[(NUM)])
#define TREE_PAR_STACK_POS(INFO)	((INFO)->par_stack_pos)
#define TREE_IS_SSAC(INFO)		((INFO)->is_ssac)
#define TREE_ERRNO(INFO)		((INFO)->errno)
#define TREE_RE_FAILED(INFO)		((INFO)->re_failed)
#define TREE_LPAR_IDENT(INFO)		((INFO)->lpar_ident)
#define TREE_LPAR_EXCEPTION(INFO)	((INFO)->lpar_exception)

/* DFA ̺ ϱ   ؼϰ ִ " ǥ"  
      ִ ü.  */
struct hre_tree
{
  struct hre_options *options;

  /*   ǥĿ  ü  .  */
  struct stack_dummy stack[STACK_MAX];
  /*    Ų.  */
  struct stack_dummy *sp;
  
  /* Symbol ̺    ִ.  */
  struct symbol * hashtab[HASH_MAX];
  struct symbol * first_b;
  struct symbol * last_b;

  /* ǥĿ  ü ͵.  */
  struct exp * exp_hash[EXP_MAX];
  /*   ܼ ߿ ǥ ϱ  غ , hash 
     ν ߺ hash   malloc  ּҸ Ҿ   
     ̴.  */
  struct exp * exp_free[EXP_FREE_MAX];

  /*  ʿ */
  struct equation * equ_tab;
  int equs;
  int total_equs;
  int equ_max;

  /*  ʿ */
  int last_rhs;

  /* FormStates ܰ迡 Ǵ .  */

  /*  ʿ */
  struct item *i_buf;
  int i_s;
  int i_max;
  
  /*  ʿ */
  struct state *s_tab;
  /* DFA  ϱ  ʿ state    ϰ ִµ, 
     hre_write_states () Լ ȣǱ ,    ְ ȴ.  */
  int s_s;

  /*  ʿ */
  int *x_stack;
  int x_s;
  int x_max;

  /*  ʿ */
  struct equiv * e_tab;
  int e_s;
  int e_max;

  /*  hre_compile  ϴ   ǥĿ   , 
     ⿡  ڵ尡 Բ ȯȴ.  */
  int errno;
  /*  Խ ؼϴ   , ã  Ұϵ
      Ѵٸ ̰ ȴ.   , ERE  a^b  ã   
     ̴.  */
  int re_failed;

  /* ̰ Խ "a{,2}"   {  , 2, }   IDENTIFIER  ؼ
     ʿ䰡   ǰ ȴ.  */
  int lpar_ident;
  /* ̰ Խ "a*{1,2}"   * Ȥ +, ? ڿ { token   츦
     ؾ  , 1  ȴ.  */
  int lpar_exception;

  /* ڰ Է  ǥĿ ѱ type 鿡  mask  
     Ǹ, hre_parser () Ĺݺο ǰ Ǵµ, ݱ о token 
       ȴ.   struct hdfa  htmask  ϰ ȴ.  */
  int htmask;
  /*  ǥ ^  ϴ Ÿ.  */
  int is_ssac;
  
  int par_stack[9];
  int par_stack_pos;

  /*  ǥ token     ִ.   token  
     struct hre_token ü Ҵǰ Ǹ,   token  
     ù° Ű ȴ.  */
  struct hre_token *tokens;
};

#define TOKEN_LEN(T)		((T)->length)
#define TOKEN_TYPE(T)		((T)->type)
#define TOKEN_NAME(T)		((T)->name)
#define TOKEN_INDEX(T)		((T)->index)
#define TOKEN_NEXT(T)		((T)->next)
#define TOKEN_PARENT(T)		((T)->parent)
#define TOKEN_HAN_TYPE(T)	((T)->han_type)
#define TOKEN_BACKSLASH(T)	((T)->backslash)

/* ڰ Է  ǥĿ ϳ token     
   ִ.  */
struct hre_token
{
  int type;			/*  token  lexcial   ִ. */
  /* ڰ Է  ǥĿ   token  õ ڿ  ù°
     ͸  ִ.  */
  char *name;
  int length;			/*  token  .  */
  int index;			/*  token   index ȣ.  */
  int han_type;			/*  ū ѱ   , ϼ 
				   ڵ Ѵ.  (  ϼ
				      .)  */

  /* ڰ Է ԽĿ backslash   츦 óϱ  
     ̸,  blackslash  óϰ  , 1  Ǹ, 
      , 0  ȴ.  */
  int backslash;

  struct hre_tree *parent;	/*  token   Ϳ  .  */
  struct hre_token *next;
};

/*  ʿ.  */
extern void hre_process_syntax (struct hre_tree *, int, int);
extern void hre_process_expression (struct hre_tree *, struct hre_token *, int *);
extern hre_t hre_compile (char *, struct hre_options *);
extern int hre_search (hre_t, const char *);
extern void hre_free (hre_t);
#endif
