/***************************************************************************
                       xterm256generator.h  -  description
                             -------------------
    begin                : Oct 13 2006
    copyright            : (C) 2006-2007 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XTERM256GENERATOR_H
#define XTERM256GENERATOR_H

#include <string>

#include "codegenerator.h"


namespace highlight {

/**
   \brief This class generates xterm 256 color escape sequences.

   It contains information about the resulting document structure (document
   header and footer), the colour system, white space handling and text
   formatting attributes.

* @author Andre Simon
*/

class Xterm256Generator : public highlight::CodeGenerator
  {
  public:
    Xterm256Generator();
    ~Xterm256Generator();

   /**initialize colour theme information
      @param themePath string to theme definition file
      @return True if successfull */
    bool initTheme(const string& themePath);

  private:

   /** prints document header
    */
    string getHeader();

    /** Prints document footer*/
    string getFooter();

    /** Prints document body*/
    void printBody();

    /** \return escaped character*/
    virtual string maskCharacter(unsigned char );

    /** @param style associated element style
        @return formatting seqence */
    string getOpenTag(ElementStyle &style);
    /** @param styleID current style ID
        @return matching sequence to begin a new element formatting*/
    string getMatchingOpenTag(unsigned int styleID);

    /** @param styleID current style ID
        @return matching sequence to close element formatting*/
    string getMatchingCloseTag(unsigned int styleID);

    /** convert an xterm color value (0-253) to 3 unsigned chars rgb
        @param color xterm color
        @param rgb RGB destination string */
    void xterm2rgb(unsigned char color, unsigned char* rgb);

    /** fill the colortable for use with rgb2xterm */
    void maketable();

    /** selects the nearest xterm color for a 3xBYTE rgb value
        @param RGB colour string */
    unsigned char rgb2xterm(unsigned char* rgb);

    /// Flag to determine if colourtable is calculated
    static bool initialized;
    /// color tzable for nearest match calculation
    static unsigned char colortable[254][3];

    /// the 6 value iterations in the xterm color cube
    static const unsigned char valuerange[] ;

    /// 16 basic colors
    static const unsigned char basic16[16][3];

  };

}
#endif
