/***************************************************************************
                          TexGenerator.cpp  -  description
                             -------------------
    begin                : Mit Jul 24 2002
    copyright            : (C) 2002 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <sstream>

#include "charcodes.h"
#include "version.h"
#include "texgenerator.h"

namespace highlight {

TexGenerator::TexGenerator()
: CodeGenerator(TEX)
{
  styleTagOpen.push_back( "{\\hlstd ");
  styleTagOpen.push_back( "{\\hlstr ");
  styleTagOpen.push_back( "{\\hlnum ");
  styleTagOpen.push_back( "{\\hlslc ");
  styleTagOpen.push_back( "{\\hlcom ");
  styleTagOpen.push_back( "{\\hlesc ");
  styleTagOpen.push_back( "{\\hldir ");
  styleTagOpen.push_back( "{\\hldstr ");
  styleTagOpen.push_back( "{\\hlline ");
  styleTagOpen.push_back( "{\\hlsym ");
  for (int i=0; i<NUMBER_BUILTIN_STATES; i++)    {
    styleTagClose.push_back( "}");
  }

  /*This makes TeX to use every par it encounters (the \\leavevmode has
  no effect when TeX is in horizontal mode and when TeX is in vertical
  mode, it switches it to horizontal mode).*/
  newLineTag="\\leavevmode\\par\n";

  spacer = "\\ ";
  maskWs=true;
  excludeWs=true;
  maskWsBegin = "{\\hlstd";
  maskWsEnd = "}";
  styleCommentOpen="%";
}

TexGenerator::~TexGenerator()
{}

string TexGenerator::getAttributes(const string & elemName,const ElementStyle & elem)
{
  ostringstream s;
  s << "\\def\\hl"
    << elemName
    << "{";
  if (elem.isBold())  s << "\\bf";
  if (elem.isItalic())  s << "\\it";
  s  <<  "\\textColor{"
     << (elem.getColour().getRed(TEX))<<" "
     << (elem.getColour().getGreen(TEX))<<" "
     << (elem.getColour().getBlue(TEX))<<" 0.0}}\n";
  return  s.str();
}

string TexGenerator::getHeader()
{
  ostringstream os;
  os << styleCommentOpen
     << " Document title: " << docTitle << "\n\n";
  if (langInfo.getSyntaxHighlight()) {
    if (includeStyleDef) {
       os << getStyleDefinition();
       os << CodeGenerator::readUserStyleDef();
    }  else  {
       os << "\\input "
          << getStyleOutputPath()
          << "\n\n";
    }
  }

  return os.str();
}

void TexGenerator::printBody()
{
  *out << "{\n\\"<<getBaseFont()<<"\n";

  processRootState();

  *out << "}\n";
}

string TexGenerator::getFooter()
{
  ostringstream os;
  os << "\\bye\n"
     << "% TeX generated by Highlight "
     << HIGHLIGHT_VERSION
     << ", "
     << HIGHLIGHT_URL
     << endl;
  return os.str();
}

string TexGenerator:: maskCharacter(unsigned char c)
{
  switch (c)
    {
    case '{':
    case '}':
      {
        string m( "$\\" );
        m += c;
        m += '$';
        return m;
      }
      break;
    case '^':
      return "{\\bf\\^{}}";
      break;
    case '_':
      return "\\_{}";
      break;
    case '&':
    case '$':
    case '#':
    case '%':
      {
        string m( "\\" );
        m += c;
        return m;
      }
      break;
    case '\\':
      return "$\\backslash$";
      break;
    case ' ':
      return spacer;
      break;
    case '+':
    case '-':
    case '<':
    case '>':
    case '=':
      {
        string m( "$\\mathord{" );
        m += c;
        m += "}$";
        return m;
      }
      break;
    case AUML_LC:
      return "\\\"a";
      break;
    case OUML_LC:
      return "\\\"o";
      break;
    case UUML_LC:
      return "\\\"u";
      break;
    case AUML_UC:
      return "\\\"A";
      break;
    case OUML_UC:
      return "\\\"O";
      break;
    case UUML_UC:
      return "\\\"U";
      break;
    case AACUTE_LC:
      return "\\'a";
      break;
    case EACUTE_LC:
      return "\\'e";
      break;
    case OACUTE_LC:
      return "\\'o";
      break;
    case UACUTE_LC:
      return "\\'u";
      break;
    case AGRAVE_LC:
      return "\\`a";
      break;
    case EGRAVE_LC:
      return "\\`e";
      break;
    case OGRAVE_LC:
      return "\\`o";
      break;
    case UGRAVE_LC:
      return "\\`u";
      break;
    case AACUTE_UC:
      return "\\'A";
      break;
    case EACUTE_UC:
      return "\\'E";
      break;
    case OACUTE_UC:
      return "\\'O";
      break;
    case UACUTE_UC:
      return "\\'U";
      break;
    case AGRAVE_UC:
      return "\\`A";
      break;
    case EGRAVE_UC:
      return "\\`E";
      break;
    case UGRAVE_UC:
      return "\\`O";
      break;
    case OGRAVE_UC:
      return "\\`U";
      break;
    case SZLIG:
      return "\\ss ";
      break;

    default :
      return string( 1, c );
    }
}

string TexGenerator::getMatchingOpenTag(unsigned int styleID){
  return "{\\hl"+langInfo.getKeywordClasses()[styleID]+" ";
 }

string TexGenerator::getMatchingCloseTag(unsigned int styleID){
  return "}";
}


string TexGenerator::getStyleDefinition()
{
    if (styleDefinitionCache.empty()){
        ostringstream os;
        os << getAttributes("std", docStyle.getDefaultStyle());
        os << getAttributes("num", docStyle.getNumberStyle());
        os << getAttributes("esc", docStyle.getEscapeCharStyle());
        os << getAttributes("str", docStyle.getStringStyle());
        os << getAttributes("dstr", docStyle.getDirectiveStringStyle());
        os << getAttributes("slc", docStyle.getSingleLineCommentStyle());
        os << getAttributes("com", docStyle.getCommentStyle());
        os << getAttributes("dir", docStyle.getDirectiveStyle());
        os << getAttributes("line", docStyle.getLineStyle());
        os << getAttributes("sym", docStyle.getSymbolStyle());

        KeywordStyles styles = docStyle.getKeywordStyles();
        for (KSIterator it=styles.begin(); it!=styles.end(); it++){
            os << getAttributes(it->first, it->second);
        }

        os <<  "% The special option is not supported by all dvi drivers\n"
           << "\\special{background rgb "
           << docStyle.getBgColour().getRed(LATEX) << " "
           << docStyle.getBgColour().getGreen(LATEX) << " "
           << docStyle.getBgColour().getBlue(LATEX) << "}";
        os << "\n\\nopagenumbers\n"
           << "\\input colordvi\n";
        styleDefinitionCache=os.str();
    }
    return styleDefinitionCache;
}


}
