//
// C++ Interface: platform_fs
//
// Description:
//
//
// Author: Andre Simon <andre.simon1@gmx.de>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef PLATFORM_FS__H__INCLUDED
#define PLATFORM_FS__H__INCLUDED

#include <string>
#include <iostream>
#include <vector>
/*
#ifdef USE_FN_MATCH
  #include <fnmatch.h>
#endif
*/

namespace Platform
{
	extern const char pathSeparator;

	std::string getAppPath();

	/** \param fileList Vector where found entries will be stored
        \param  wildcard Directory path and wildcard
        \param recursiveSearch Test if directory should be searched recursively */
        bool getDirectoryEntries(std::vector<std::string> &fileList,
                           std::string wildcard,
                           bool recursiveSearch=false);

	void getFileNames(const std::string &directory,const std::string &wildcard,
			 std::vector<std::string> &fileName);

	int wildcmp(const char *wild, const char *data);

/*
#ifdef USE_FN_MATCH
  struct FnMatcher
  {
    FnMatcher(const char* pattern, int flags)
        : pattern_(pattern)
        , flags_(flags)
    {}
    bool operator()(const std::string& e) const {
        return ! ::fnmatch(pattern_, e.c_str(), flags_);
    }
   private:
    const char* pattern_;
    int flags_;
  };
#endif
*/

}
#endif
