#include <sys/types.h>
#include <sys/time.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>

void usage(void)
{
  fprintf(stderr,"greetdelay: usage: greetdelay \
[ -qQv ] \
[ -sS ] \
program [ args ... ]\n");
  exit(100);
}

struct timeval tv;
fd_set rfds;

int flagstrict = 1;
int verbosity = 1;

int main(int argc,char *argv[])
{
  char *delay, *ip;
  int opt;
  unsigned long pid;

  while ((opt = getopt(argc,argv,"qQsSv")) != -1)
    switch (opt) {
      case 'q': verbosity = 0; break;
      case 'Q': verbosity = 1; break;
      case 'v': verbosity = 2; break;
      case 's': flagstrict = 1; break;
      case 'S': flagstrict = 0; break;
      default: usage();
    }
  argc -= optind;
  argv += optind;

  if (!argv[0]) usage();

  ip = getenv("TCPREMOTEIP");
  if (!ip) ip = "";
  pid = (unsigned long)getpid();

  delay = getenv("GREETDELAY");
  if (delay && *delay) {
    tv.tv_sec = atoi(delay);
    tv.tv_usec = 0;
    FD_ZERO(&rfds);
    if (flagstrict) FD_SET(0,&rfds);
    select(1,&rfds,0,0,&tv);
    if (flagstrict && FD_ISSET(0,&rfds)) {
      if (verbosity >= 1) fprintf(stderr,"greetdelay: %s pid %lu: premature input on stdin\n",ip,pid);
      printf("554 smtp protocol violation (#5.5.1)\r\n");
      return 111;
    }
  }

  if (verbosity >= 2) fprintf(stderr,"greetdelay: %s pid %lu: ok\n",ip,pid);
  execvp(argv[0],argv);
  if (verbosity >= 1) fprintf(stderr,"greetdelay: %s pid %lu: unable to run %s: %s\n",ip,pid,argv[0],strerror(errno));
  return 111;
}
